/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.type;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.persistence.AccessType;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.IdClass;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.parser.impl.metadata.EntityListenerMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.type.ManagedTypeMetadatImpl;
import org.batoo.jpa.parser.metadata.CallbackMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.type.IdentifiableTypeMetadata;

public abstract class IdentifiableMetadataImpl
extends ManagedTypeMetadatImpl
implements IdentifiableTypeMetadata {
    private final String idClass;
    private final List<EntityListenerMetadata> listeners = Lists.newArrayList();
    private final EntityListenerMetadata selfListener;
    private final boolean excludeSuperclassListeners;
    private final boolean excludeDefaultListeners;

    public IdentifiableMetadataImpl(Class<?> clazz, IdentifiableTypeMetadata metadata, AccessType parentAccessType) {
        super(clazz, metadata, parentAccessType);
        this.idClass = this.handleIdClass(metadata);
        this.excludeDefaultListeners = this.handleDefaultListeners(metadata);
        this.excludeSuperclassListeners = this.handleSuperclassListeners(metadata);
        this.handleEntityListeners(metadata);
        this.selfListener = this.handleCallbacks(metadata);
    }

    @Override
    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    @Override
    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    @Override
    public List<CallbackMetadata> getCallbacks() {
        if (this.selfListener != null) {
            return this.selfListener.getCallbacks();
        }
        return Collections.emptyList();
    }

    @Override
    public final String getIdClass() {
        return this.idClass;
    }

    @Override
    public List<EntityListenerMetadata> getListeners() {
        return this.listeners;
    }

    private EntityListenerMetadata handleCallbacks(IdentifiableTypeMetadata metadata) {
        if (metadata != null && metadata.getCallbacks().size() > 0) {
            return new EntityListenerMetadataImpl(metadata.getLocator(), metadata, this.getClassName());
        }
        return new EntityListenerMetadataImpl(this.getLocator(), this.getClazz(), this.getAnnotationsParsed());
    }

    private boolean handleDefaultListeners(IdentifiableTypeMetadata metadata) {
        if (metadata != null && metadata.excludeDefaultListeners()) {
            return true;
        }
        ExcludeDefaultListeners annotation = this.getClazz().getAnnotation(ExcludeDefaultListeners.class);
        if (annotation != null) {
            this.getAnnotationsParsed().add(ExcludeDefaultListeners.class);
            return true;
        }
        return false;
    }

    private void handleEntityListeners(IdentifiableTypeMetadata metadata) {
        if (metadata != null && metadata.getListeners().size() > 0) {
            for (EntityListenerMetadata listener : metadata.getListeners()) {
                new EntityListenerMetadataImpl(metadata.getLocator(), listener);
            }
            this.listeners.addAll(metadata.getListeners());
        } else {
            EntityListeners entityListeners = this.getClazz().getAnnotation(EntityListeners.class);
            if (entityListeners != null) {
                this.getAnnotationsParsed().add(EntityListeners.class);
                for (Class clazz : entityListeners.value()) {
                    this.listeners.add(new EntityListenerMetadataImpl(this.getLocator(), clazz));
                }
            }
        }
    }

    private String handleIdClass(IdentifiableTypeMetadata metadata) {
        if (metadata != null && StringUtils.isNotBlank((String)metadata.getIdClass())) {
            return metadata.getIdClass();
        }
        IdClass idClass = this.getClazz().getAnnotation(IdClass.class);
        if (idClass != null) {
            this.getAnnotationsParsed().add(IdClass.class);
            return idClass.value().getName();
        }
        return null;
    }

    private boolean handleSuperclassListeners(IdentifiableTypeMetadata metadata) {
        if (metadata != null && metadata.excludeSuperclassListeners()) {
            return true;
        }
        ExcludeSuperclassListeners annotation = this.getClazz().getAnnotation(ExcludeSuperclassListeners.class);
        if (annotation != null) {
            this.getAnnotationsParsed().add(ExcludeSuperclassListeners.class);
            return true;
        }
        return false;
    }
}

