/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.GeneratorElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.UniqueConstraintsElement;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class TableGeneratorElement
extends GeneratorElement
implements TableGeneratorMetadata {
    private String table;
    private String pkColumnName;
    private String pkColumnValue;
    private String valueColumnName;
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();

    public TableGeneratorElement(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "unique-constraint");
    }

    @Override
    protected void generate() {
        super.generate();
        this.table = this.getAttribute("table", "");
        this.pkColumnName = this.getAttribute("pk-column-name", "");
        this.pkColumnValue = this.getAttribute("pk-column-value", "");
        this.valueColumnName = this.getAttribute("value-column-name", "");
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof UniqueConstraintsElement) {
            this.uniqueConstraints.add((UniqueConstraintsElement)child);
        }
    }
}

