/*
 * Copyright (c) 2012 - Batoo Software ve Consultancy Ltd.
 * 
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.batoo.jpa.jdbc;

/**
 * The type of the id attributes
 * 
 * @author hceylan
 * @since 2.0.0
 */
public enum IdType {

	/**
	 * Id is identity type.
	 */
	IDENTITY,

	/**
	 * Id is generated by a sequence.
	 */
	SEQUENCE,

	/**
	 * Id is generated by a table generator.
	 */
	TABLE,

	/**
	 * Id is provided manually.
	 */
	MANUAL
}
