// $ANTLR 3.4 org/batoo/jpa/sql/SqlLexer.g 2012-11-29 12:26:20

	package org.batoo.jpa.sql;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class SqlLexer extends Lexer {
    public static final int EOF=-1;
    public static final int COLUMN=4;
    public static final int CR=5;
    public static final int FLOAT=6;
    public static final int ID=7;
    public static final int LF=8;
    public static final int LINE_COMMENT=9;
    public static final int LINE_COMMENT_START_1=10;
    public static final int LINE_COMMENT_START_2=11;
    public static final int LINE_COMMENT_START_3=12;
    public static final int MULTI_LINE_COMMENT=13;
    public static final int MULTI_LINE_COMMENT_END=14;
    public static final int MULTI_LINE_COMMENT_START=15;
    public static final int NUMBER=16;
    public static final int PUNCTUATION=17;
    public static final int QUESTION_MARK=18;
    public static final int QUOT_1=19;
    public static final int QUOT_2=20;
    public static final int QUOT_3=21;
    public static final int SEMI_COLUMN=22;
    public static final int SPACE=23;
    public static final int STRING=24;
    public static final int TAB=25;
    public static final int WORD=26;

    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public SqlLexer() {} 
    public SqlLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public SqlLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "org/batoo/jpa/sql/SqlLexer.g"; }

    // $ANTLR start "CR"
    public final void mCR() throws RecognitionException {
        try {
            int _type = CR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:11:4: ( '\\r' )
            // org/batoo/jpa/sql/SqlLexer.g:12:2: '\\r'
            {
            match('\r'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CR"

    // $ANTLR start "LF"
    public final void mLF() throws RecognitionException {
        try {
            int _type = LF;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:15:4: ( '\\n' )
            // org/batoo/jpa/sql/SqlLexer.g:16:2: '\\n'
            {
            match('\n'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LF"

    // $ANTLR start "SPACE"
    public final void mSPACE() throws RecognitionException {
        try {
            int _type = SPACE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:19:7: ( ' ' )
            // org/batoo/jpa/sql/SqlLexer.g:20:2: ' '
            {
            match(' '); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SPACE"

    // $ANTLR start "TAB"
    public final void mTAB() throws RecognitionException {
        try {
            int _type = TAB;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:23:5: ( '\\t' )
            // org/batoo/jpa/sql/SqlLexer.g:24:2: '\\t'
            {
            match('\t'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "TAB"

    // $ANTLR start "SEMI_COLUMN"
    public final void mSEMI_COLUMN() throws RecognitionException {
        try {
            int _type = SEMI_COLUMN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:27:13: ( ';' )
            // org/batoo/jpa/sql/SqlLexer.g:28:2: ';'
            {
            match(';'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SEMI_COLUMN"

    // $ANTLR start "QUESTION_MARK"
    public final void mQUESTION_MARK() throws RecognitionException {
        try {
            int _type = QUESTION_MARK;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:31:15: ( '?' )
            // org/batoo/jpa/sql/SqlLexer.g:32:2: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUESTION_MARK"

    // $ANTLR start "COLUMN"
    public final void mCOLUMN() throws RecognitionException {
        try {
            int _type = COLUMN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:35:8: ( ':' )
            // org/batoo/jpa/sql/SqlLexer.g:36:2: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COLUMN"

    // $ANTLR start "QUOT_1"
    public final void mQUOT_1() throws RecognitionException {
        try {
            int _type = QUOT_1;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:39:8: ( '\\'' )
            // org/batoo/jpa/sql/SqlLexer.g:40:2: '\\''
            {
            match('\''); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOT_1"

    // $ANTLR start "QUOT_2"
    public final void mQUOT_2() throws RecognitionException {
        try {
            int _type = QUOT_2;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:43:8: ( '\"' )
            // org/batoo/jpa/sql/SqlLexer.g:44:2: '\"'
            {
            match('\"'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOT_2"

    // $ANTLR start "QUOT_3"
    public final void mQUOT_3() throws RecognitionException {
        try {
            int _type = QUOT_3;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:47:8: ( '`' )
            // org/batoo/jpa/sql/SqlLexer.g:48:2: '`'
            {
            match('`'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOT_3"

    // $ANTLR start "NUMBER"
    public final void mNUMBER() throws RecognitionException {
        try {
            int _type = NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:51:8: ( ( '0' .. '9' )+ )
            // org/batoo/jpa/sql/SqlLexer.g:52:2: ( '0' .. '9' )+
            {
            // org/batoo/jpa/sql/SqlLexer.g:52:2: ( '0' .. '9' )+
            int cnt1=0;
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NUMBER"

    // $ANTLR start "FLOAT"
    public final void mFLOAT() throws RecognitionException {
        try {
            int _type = FLOAT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:55:7: ( ( '0' .. '9' )+ '.' ( '0' .. '9' )+ )
            // org/batoo/jpa/sql/SqlLexer.g:56:2: ( '0' .. '9' )+ '.' ( '0' .. '9' )+
            {
            // org/batoo/jpa/sql/SqlLexer.g:56:2: ( '0' .. '9' )+
            int cnt2=0;
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt2 >= 1 ) break loop2;
                        EarlyExitException eee =
                            new EarlyExitException(2, input);
                        throw eee;
                }
                cnt2++;
            } while (true);


            match('.'); 

            // org/batoo/jpa/sql/SqlLexer.g:56:16: ( '0' .. '9' )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FLOAT"

    // $ANTLR start "ID"
    public final void mID() throws RecognitionException {
        try {
            int _type = ID;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:59:4: ( 'a' .. 'z' | 'A' .. 'Z' | '_' ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' )* )
            int alt5=3;
            switch ( input.LA(1) ) {
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
                {
                alt5=1;
                }
                break;
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
                {
                alt5=2;
                }
                break;
            case '_':
                {
                alt5=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;

            }

            switch (alt5) {
                case 1 :
                    // org/batoo/jpa/sql/SqlLexer.g:60:2: 'a' .. 'z'
                    {
                    matchRange('a','z'); 

                    }
                    break;
                case 2 :
                    // org/batoo/jpa/sql/SqlLexer.g:60:13: 'A' .. 'Z'
                    {
                    matchRange('A','Z'); 

                    }
                    break;
                case 3 :
                    // org/batoo/jpa/sql/SqlLexer.g:60:24: '_' ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' )*
                    {
                    match('_'); 

                    // org/batoo/jpa/sql/SqlLexer.g:60:28: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' )*
                    loop4:
                    do {
                        int alt4=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                        case 'A':
                        case 'B':
                        case 'C':
                        case 'D':
                        case 'E':
                        case 'F':
                        case 'G':
                        case 'H':
                        case 'I':
                        case 'J':
                        case 'K':
                        case 'L':
                        case 'M':
                        case 'N':
                        case 'O':
                        case 'P':
                        case 'Q':
                        case 'R':
                        case 'S':
                        case 'T':
                        case 'U':
                        case 'V':
                        case 'W':
                        case 'X':
                        case 'Y':
                        case 'Z':
                        case '_':
                        case 'a':
                        case 'b':
                        case 'c':
                        case 'd':
                        case 'e':
                        case 'f':
                        case 'g':
                        case 'h':
                        case 'i':
                        case 'j':
                        case 'k':
                        case 'l':
                        case 'm':
                        case 'n':
                        case 'o':
                        case 'p':
                        case 'q':
                        case 'r':
                        case 's':
                        case 't':
                        case 'u':
                        case 'v':
                        case 'w':
                        case 'x':
                        case 'y':
                        case 'z':
                            {
                            alt4=1;
                            }
                            break;

                        }

                        switch (alt4) {
                    	case 1 :
                    	    // org/batoo/jpa/sql/SqlLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop4;
                        }
                    } while (true);


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ID"

    // $ANTLR start "PUNCTUATION"
    public final void mPUNCTUATION() throws RecognitionException {
        try {
            int _type = PUNCTUATION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:63:13: ( ',' | '+' | '-' | '*' | '/' | '^' | '||' | '|' | '&' | '@' | '(' | ')' | '<' | '>' | '.' | '!' )
            int alt6=16;
            switch ( input.LA(1) ) {
            case ',':
                {
                alt6=1;
                }
                break;
            case '+':
                {
                alt6=2;
                }
                break;
            case '-':
                {
                alt6=3;
                }
                break;
            case '*':
                {
                alt6=4;
                }
                break;
            case '/':
                {
                alt6=5;
                }
                break;
            case '^':
                {
                alt6=6;
                }
                break;
            case '|':
                {
                switch ( input.LA(2) ) {
                case '|':
                    {
                    alt6=7;
                    }
                    break;
                default:
                    alt6=8;
                }

                }
                break;
            case '&':
                {
                alt6=9;
                }
                break;
            case '@':
                {
                alt6=10;
                }
                break;
            case '(':
                {
                alt6=11;
                }
                break;
            case ')':
                {
                alt6=12;
                }
                break;
            case '<':
                {
                alt6=13;
                }
                break;
            case '>':
                {
                alt6=14;
                }
                break;
            case '.':
                {
                alt6=15;
                }
                break;
            case '!':
                {
                alt6=16;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:2: ','
                    {
                    match(','); 

                    }
                    break;
                case 2 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:8: '+'
                    {
                    match('+'); 

                    }
                    break;
                case 3 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:14: '-'
                    {
                    match('-'); 

                    }
                    break;
                case 4 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:20: '*'
                    {
                    match('*'); 

                    }
                    break;
                case 5 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:26: '/'
                    {
                    match('/'); 

                    }
                    break;
                case 6 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:32: '^'
                    {
                    match('^'); 

                    }
                    break;
                case 7 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:38: '||'
                    {
                    match("||"); 



                    }
                    break;
                case 8 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:45: '|'
                    {
                    match('|'); 

                    }
                    break;
                case 9 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:51: '&'
                    {
                    match('&'); 

                    }
                    break;
                case 10 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:57: '@'
                    {
                    match('@'); 

                    }
                    break;
                case 11 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:63: '('
                    {
                    match('('); 

                    }
                    break;
                case 12 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:69: ')'
                    {
                    match(')'); 

                    }
                    break;
                case 13 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:75: '<'
                    {
                    match('<'); 

                    }
                    break;
                case 14 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:81: '>'
                    {
                    match('>'); 

                    }
                    break;
                case 15 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:87: '.'
                    {
                    match('.'); 

                    }
                    break;
                case 16 :
                    // org/batoo/jpa/sql/SqlLexer.g:64:93: '!'
                    {
                    match('!'); 

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PUNCTUATION"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:67:8: ( ( QUOT_1 (~ ( QUOT_1 ) )* QUOT_1 ) | ( QUOT_2 (~ ( QUOT_2 ) )* QUOT_2 ) | ( QUOT_3 (~ ( QUOT_3 ) )* QUOT_3 ) )
            int alt10=3;
            switch ( input.LA(1) ) {
            case '\'':
                {
                alt10=1;
                }
                break;
            case '\"':
                {
                alt10=2;
                }
                break;
            case '`':
                {
                alt10=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }

            switch (alt10) {
                case 1 :
                    // org/batoo/jpa/sql/SqlLexer.g:68:2: ( QUOT_1 (~ ( QUOT_1 ) )* QUOT_1 )
                    {
                    // org/batoo/jpa/sql/SqlLexer.g:68:2: ( QUOT_1 (~ ( QUOT_1 ) )* QUOT_1 )
                    // org/batoo/jpa/sql/SqlLexer.g:68:3: QUOT_1 (~ ( QUOT_1 ) )* QUOT_1
                    {
                    mQUOT_1(); 


                    // org/batoo/jpa/sql/SqlLexer.g:68:10: (~ ( QUOT_1 ) )*
                    loop7:
                    do {
                        int alt7=2;
                        int LA7_0 = input.LA(1);

                        if ( ((LA7_0 >= '\u0000' && LA7_0 <= '&')||(LA7_0 >= '(' && LA7_0 <= '\uFFFF')) ) {
                            alt7=1;
                        }


                        switch (alt7) {
                    	case 1 :
                    	    // org/batoo/jpa/sql/SqlLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '\uFFFF') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);


                    mQUOT_1(); 


                    }


                    }
                    break;
                case 2 :
                    // org/batoo/jpa/sql/SqlLexer.g:69:4: ( QUOT_2 (~ ( QUOT_2 ) )* QUOT_2 )
                    {
                    // org/batoo/jpa/sql/SqlLexer.g:69:4: ( QUOT_2 (~ ( QUOT_2 ) )* QUOT_2 )
                    // org/batoo/jpa/sql/SqlLexer.g:69:5: QUOT_2 (~ ( QUOT_2 ) )* QUOT_2
                    {
                    mQUOT_2(); 


                    // org/batoo/jpa/sql/SqlLexer.g:69:12: (~ ( QUOT_2 ) )*
                    loop8:
                    do {
                        int alt8=2;
                        int LA8_0 = input.LA(1);

                        if ( ((LA8_0 >= '\u0000' && LA8_0 <= '!')||(LA8_0 >= '#' && LA8_0 <= '\uFFFF')) ) {
                            alt8=1;
                        }


                        switch (alt8) {
                    	case 1 :
                    	    // org/batoo/jpa/sql/SqlLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop8;
                        }
                    } while (true);


                    mQUOT_2(); 


                    }


                    }
                    break;
                case 3 :
                    // org/batoo/jpa/sql/SqlLexer.g:70:4: ( QUOT_3 (~ ( QUOT_3 ) )* QUOT_3 )
                    {
                    // org/batoo/jpa/sql/SqlLexer.g:70:4: ( QUOT_3 (~ ( QUOT_3 ) )* QUOT_3 )
                    // org/batoo/jpa/sql/SqlLexer.g:70:5: QUOT_3 (~ ( QUOT_3 ) )* QUOT_3
                    {
                    mQUOT_3(); 


                    // org/batoo/jpa/sql/SqlLexer.g:70:12: (~ ( QUOT_3 ) )*
                    loop9:
                    do {
                        int alt9=2;
                        int LA9_0 = input.LA(1);

                        if ( ((LA9_0 >= '\u0000' && LA9_0 <= '_')||(LA9_0 >= 'a' && LA9_0 <= '\uFFFF')) ) {
                            alt9=1;
                        }


                        switch (alt9) {
                    	case 1 :
                    	    // org/batoo/jpa/sql/SqlLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '_')||(input.LA(1) >= 'a' && input.LA(1) <= '\uFFFF') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop9;
                        }
                    } while (true);


                    mQUOT_3(); 


                    }


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING"

    // $ANTLR start "LINE_COMMENT_START_1"
    public final void mLINE_COMMENT_START_1() throws RecognitionException {
        try {
            int _type = LINE_COMMENT_START_1;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:73:22: ( '--' )
            // org/batoo/jpa/sql/SqlLexer.g:74:2: '--'
            {
            match("--"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LINE_COMMENT_START_1"

    // $ANTLR start "LINE_COMMENT_START_2"
    public final void mLINE_COMMENT_START_2() throws RecognitionException {
        try {
            int _type = LINE_COMMENT_START_2;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:77:22: ( '//' )
            // org/batoo/jpa/sql/SqlLexer.g:78:2: '//'
            {
            match("//"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LINE_COMMENT_START_2"

    // $ANTLR start "LINE_COMMENT_START_3"
    public final void mLINE_COMMENT_START_3() throws RecognitionException {
        try {
            int _type = LINE_COMMENT_START_3;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:81:22: ( '#' )
            // org/batoo/jpa/sql/SqlLexer.g:82:2: '#'
            {
            match('#'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LINE_COMMENT_START_3"

    // $ANTLR start "MULTI_LINE_COMMENT_START"
    public final void mMULTI_LINE_COMMENT_START() throws RecognitionException {
        try {
            int _type = MULTI_LINE_COMMENT_START;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:85:26: ( '/*' )
            // org/batoo/jpa/sql/SqlLexer.g:86:2: '/*'
            {
            match("/*"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MULTI_LINE_COMMENT_START"

    // $ANTLR start "MULTI_LINE_COMMENT_END"
    public final void mMULTI_LINE_COMMENT_END() throws RecognitionException {
        try {
            int _type = MULTI_LINE_COMMENT_END;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:89:24: ( '*/' )
            // org/batoo/jpa/sql/SqlLexer.g:90:2: '*/'
            {
            match("*/"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MULTI_LINE_COMMENT_END"

    // $ANTLR start "LINE_COMMENT"
    public final void mLINE_COMMENT() throws RecognitionException {
        try {
            int _type = LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:93:14: ( ( LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 ) (~ ( CR | LF ) )* ( ( CR LF ) | LF )? )
            // org/batoo/jpa/sql/SqlLexer.g:94:2: ( LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 ) (~ ( CR | LF ) )* ( ( CR LF ) | LF )?
            {
            // org/batoo/jpa/sql/SqlLexer.g:94:2: ( LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 )
            int alt11=3;
            switch ( input.LA(1) ) {
            case '-':
                {
                alt11=1;
                }
                break;
            case '/':
                {
                alt11=2;
                }
                break;
            case '#':
                {
                alt11=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // org/batoo/jpa/sql/SqlLexer.g:94:3: LINE_COMMENT_START_1
                    {
                    mLINE_COMMENT_START_1(); 


                    }
                    break;
                case 2 :
                    // org/batoo/jpa/sql/SqlLexer.g:94:26: LINE_COMMENT_START_2
                    {
                    mLINE_COMMENT_START_2(); 


                    }
                    break;
                case 3 :
                    // org/batoo/jpa/sql/SqlLexer.g:94:49: LINE_COMMENT_START_3
                    {
                    mLINE_COMMENT_START_3(); 


                    }
                    break;

            }


            // org/batoo/jpa/sql/SqlLexer.g:94:71: (~ ( CR | LF ) )*
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( ((LA12_0 >= '\u0000' && LA12_0 <= '\t')||(LA12_0 >= '\u000B' && LA12_0 <= '\f')||(LA12_0 >= '\u000E' && LA12_0 <= '\uFFFF')) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop12;
                }
            } while (true);


            // org/batoo/jpa/sql/SqlLexer.g:94:83: ( ( CR LF ) | LF )?
            int alt13=3;
            switch ( input.LA(1) ) {
                case '\r':
                    {
                    alt13=1;
                    }
                    break;
                case '\n':
                    {
                    alt13=2;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/batoo/jpa/sql/SqlLexer.g:94:84: ( CR LF )
                    {
                    // org/batoo/jpa/sql/SqlLexer.g:94:84: ( CR LF )
                    // org/batoo/jpa/sql/SqlLexer.g:94:85: CR LF
                    {
                    mCR(); 


                    mLF(); 


                    }


                    }
                    break;
                case 2 :
                    // org/batoo/jpa/sql/SqlLexer.g:94:94: LF
                    {
                    mLF(); 


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LINE_COMMENT"

    // $ANTLR start "MULTI_LINE_COMMENT"
    public final void mMULTI_LINE_COMMENT() throws RecognitionException {
        try {
            int _type = MULTI_LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:97:20: ( MULTI_LINE_COMMENT_START ( . )* MULTI_LINE_COMMENT_END )
            // org/batoo/jpa/sql/SqlLexer.g:98:2: MULTI_LINE_COMMENT_START ( . )* MULTI_LINE_COMMENT_END
            {
            mMULTI_LINE_COMMENT_START(); 


            // org/batoo/jpa/sql/SqlLexer.g:98:27: ( . )*
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0=='*') ) {
                    int LA14_1 = input.LA(2);

                    if ( (LA14_1=='/') ) {
                        alt14=2;
                    }
                    else if ( ((LA14_1 >= '\u0000' && LA14_1 <= '.')||(LA14_1 >= '0' && LA14_1 <= '\uFFFF')) ) {
                        alt14=1;
                    }


                }
                else if ( ((LA14_0 >= '\u0000' && LA14_0 <= ')')||(LA14_0 >= '+' && LA14_0 <= '\uFFFF')) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:98:27: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop14;
                }
            } while (true);


            mMULTI_LINE_COMMENT_END(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MULTI_LINE_COMMENT"

    // $ANTLR start "WORD"
    public final void mWORD() throws RecognitionException {
        try {
            int _type = WORD;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/batoo/jpa/sql/SqlLexer.g:101:6: (~ ( SEMI_COLUMN | PUNCTUATION | QUESTION_MARK | COLUMN | LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 | MULTI_LINE_COMMENT_START | SPACE | TAB | CR | LF | QUOT_1 | QUOT_2 | QUOT_3 ) (~ ( SPACE | TAB | CR | LF | SEMI_COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | PUNCTUATION ) )* )
            // org/batoo/jpa/sql/SqlLexer.g:102:2: ~ ( SEMI_COLUMN | PUNCTUATION | QUESTION_MARK | COLUMN | LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 | MULTI_LINE_COMMENT_START | SPACE | TAB | CR | LF | QUOT_1 | QUOT_2 | QUOT_3 ) (~ ( SPACE | TAB | CR | LF | SEMI_COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | PUNCTUATION ) )*
            {
            if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F')||(input.LA(1) >= '$' && input.LA(1) <= '%')||(input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='='||(input.LA(1) >= 'A' && input.LA(1) <= ']')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= '{')||(input.LA(1) >= '}' && input.LA(1) <= '\uFFFF') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // org/batoo/jpa/sql/SqlLexer.g:109:4: (~ ( SPACE | TAB | CR | LF | SEMI_COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | PUNCTUATION ) )*
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( ((LA15_0 >= '\u0000' && LA15_0 <= '\b')||(LA15_0 >= '\u000B' && LA15_0 <= '\f')||(LA15_0 >= '\u000E' && LA15_0 <= '\u001F')||(LA15_0 >= '#' && LA15_0 <= '%')||(LA15_0 >= '0' && LA15_0 <= ':')||LA15_0=='='||LA15_0=='?'||(LA15_0 >= 'A' && LA15_0 <= ']')||LA15_0=='_'||(LA15_0 >= 'a' && LA15_0 <= '{')||(LA15_0 >= '}' && LA15_0 <= '\uFFFF')) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // org/batoo/jpa/sql/SqlLexer.g:109:4: ~ ( SPACE | TAB | CR | LF | SEMI_COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | PUNCTUATION )
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F')||(input.LA(1) >= '#' && input.LA(1) <= '%')||(input.LA(1) >= '0' && input.LA(1) <= ':')||input.LA(1)=='='||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= ']')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= '{')||(input.LA(1) >= '}' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "WORD"

    public void mTokens() throws RecognitionException {
        // org/batoo/jpa/sql/SqlLexer.g:1:8: ( CR | LF | SPACE | TAB | SEMI_COLUMN | QUESTION_MARK | COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | NUMBER | FLOAT | ID | PUNCTUATION | STRING | LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 | MULTI_LINE_COMMENT_START | MULTI_LINE_COMMENT_END | LINE_COMMENT | MULTI_LINE_COMMENT | WORD )
        int alt16=23;
        alt16 = dfa16.predict(input);
        switch (alt16) {
            case 1 :
                // org/batoo/jpa/sql/SqlLexer.g:1:10: CR
                {
                mCR(); 


                }
                break;
            case 2 :
                // org/batoo/jpa/sql/SqlLexer.g:1:13: LF
                {
                mLF(); 


                }
                break;
            case 3 :
                // org/batoo/jpa/sql/SqlLexer.g:1:16: SPACE
                {
                mSPACE(); 


                }
                break;
            case 4 :
                // org/batoo/jpa/sql/SqlLexer.g:1:22: TAB
                {
                mTAB(); 


                }
                break;
            case 5 :
                // org/batoo/jpa/sql/SqlLexer.g:1:26: SEMI_COLUMN
                {
                mSEMI_COLUMN(); 


                }
                break;
            case 6 :
                // org/batoo/jpa/sql/SqlLexer.g:1:38: QUESTION_MARK
                {
                mQUESTION_MARK(); 


                }
                break;
            case 7 :
                // org/batoo/jpa/sql/SqlLexer.g:1:52: COLUMN
                {
                mCOLUMN(); 


                }
                break;
            case 8 :
                // org/batoo/jpa/sql/SqlLexer.g:1:59: QUOT_1
                {
                mQUOT_1(); 


                }
                break;
            case 9 :
                // org/batoo/jpa/sql/SqlLexer.g:1:66: QUOT_2
                {
                mQUOT_2(); 


                }
                break;
            case 10 :
                // org/batoo/jpa/sql/SqlLexer.g:1:73: QUOT_3
                {
                mQUOT_3(); 


                }
                break;
            case 11 :
                // org/batoo/jpa/sql/SqlLexer.g:1:80: NUMBER
                {
                mNUMBER(); 


                }
                break;
            case 12 :
                // org/batoo/jpa/sql/SqlLexer.g:1:87: FLOAT
                {
                mFLOAT(); 


                }
                break;
            case 13 :
                // org/batoo/jpa/sql/SqlLexer.g:1:93: ID
                {
                mID(); 


                }
                break;
            case 14 :
                // org/batoo/jpa/sql/SqlLexer.g:1:96: PUNCTUATION
                {
                mPUNCTUATION(); 


                }
                break;
            case 15 :
                // org/batoo/jpa/sql/SqlLexer.g:1:108: STRING
                {
                mSTRING(); 


                }
                break;
            case 16 :
                // org/batoo/jpa/sql/SqlLexer.g:1:115: LINE_COMMENT_START_1
                {
                mLINE_COMMENT_START_1(); 


                }
                break;
            case 17 :
                // org/batoo/jpa/sql/SqlLexer.g:1:136: LINE_COMMENT_START_2
                {
                mLINE_COMMENT_START_2(); 


                }
                break;
            case 18 :
                // org/batoo/jpa/sql/SqlLexer.g:1:157: LINE_COMMENT_START_3
                {
                mLINE_COMMENT_START_3(); 


                }
                break;
            case 19 :
                // org/batoo/jpa/sql/SqlLexer.g:1:178: MULTI_LINE_COMMENT_START
                {
                mMULTI_LINE_COMMENT_START(); 


                }
                break;
            case 20 :
                // org/batoo/jpa/sql/SqlLexer.g:1:203: MULTI_LINE_COMMENT_END
                {
                mMULTI_LINE_COMMENT_END(); 


                }
                break;
            case 21 :
                // org/batoo/jpa/sql/SqlLexer.g:1:226: LINE_COMMENT
                {
                mLINE_COMMENT(); 


                }
                break;
            case 22 :
                // org/batoo/jpa/sql/SqlLexer.g:1:239: MULTI_LINE_COMMENT
                {
                mMULTI_LINE_COMMENT(); 


                }
                break;
            case 23 :
                // org/batoo/jpa/sql/SqlLexer.g:1:258: WORD
                {
                mWORD(); 


                }
                break;

        }

    }


    protected DFA16 dfa16 = new DFA16(this);
    static final String DFA16_eotS =
        "\10\uffff\1\25\1\27\1\30\1\31\3\34\1\uffff\3\17\1\42\6\uffff\1\31"+
        "\2\uffff\1\34\1\44\1\uffff\1\45\1\46\6\uffff";
    static final String DFA16_eofS =
        "\50\uffff";
    static final String DFA16_minS =
        "\1\0\7\uffff\7\0\1\uffff\1\55\1\57\1\52\1\0\6\uffff\1\0\2\uffff"+
        "\2\0\1\uffff\2\0\6\uffff";
    static final String DFA16_maxS =
        "\1\uffff\7\uffff\7\uffff\1\uffff\1\55\2\57\1\uffff\6\uffff\1\uffff"+
        "\2\uffff\2\uffff\1\uffff\2\uffff\6\uffff";
    static final String DFA16_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\7\uffff\1\16\4\uffff\1\27\1"+
        "\10\1\17\1\11\1\12\1\13\1\uffff\1\14\1\15\2\uffff\1\24\2\uffff\1"+
        "\22\1\25\1\20\1\21\1\23\1\26";
    static final String DFA16_specialS =
        "\1\3\7\uffff\1\15\1\1\1\7\1\6\1\10\1\11\1\0\4\uffff\1\2\6\uffff"+
        "\1\13\2\uffff\1\4\1\5\1\uffff\1\14\1\12\6\uffff}>";
    static final String[] DFA16_transitionS = {
            "\11\24\1\4\1\2\2\24\1\1\22\24\1\3\1\17\1\11\1\23\2\24\1\17\1"+
            "\10\2\17\1\21\2\17\1\20\1\17\1\22\12\13\1\7\1\5\1\17\1\24\1"+
            "\17\1\6\1\17\32\15\3\24\1\17\1\16\1\12\32\14\1\24\1\17\uff83"+
            "\24",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\0\26",
            "\0\26",
            "\0\26",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\10\uffff\1\33"+
            "\1\uffff\12\32\1\24\2\uffff\1\24\1\uffff\1\24\1\uffff\35\24"+
            "\1\uffff\1\24\1\uffff\33\24\1\uffff\uff83\24",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\12\uffff\13"+
            "\24\2\uffff\1\24\1\uffff\1\24\1\uffff\35\24\1\uffff\1\24\1\uffff"+
            "\33\24\1\uffff\uff83\24",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\12\uffff\13"+
            "\24\2\uffff\1\24\1\uffff\1\24\1\uffff\35\24\1\uffff\1\24\1\uffff"+
            "\33\24\1\uffff\uff83\24",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\12\uffff\12"+
            "\35\1\24\2\uffff\1\24\1\uffff\1\24\1\uffff\32\35\3\24\1\uffff"+
            "\1\35\1\uffff\32\35\1\24\1\uffff\uff83\24",
            "",
            "\1\36",
            "\1\37",
            "\1\41\4\uffff\1\40",
            "\0\43",
            "",
            "",
            "",
            "",
            "",
            "",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\10\uffff\1\33"+
            "\1\uffff\12\32\1\24\2\uffff\1\24\1\uffff\1\24\1\uffff\35\24"+
            "\1\uffff\1\24\1\uffff\33\24\1\uffff\uff83\24",
            "",
            "",
            "\11\24\2\uffff\2\24\1\uffff\22\24\3\uffff\3\24\12\uffff\12"+
            "\35\1\24\2\uffff\1\24\1\uffff\1\24\1\uffff\32\35\3\24\1\uffff"+
            "\1\35\1\uffff\32\35\1\24\1\uffff\uff83\24",
            "\0\43",
            "",
            "\0\43",
            "\0\47",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA16_eot = DFA.unpackEncodedString(DFA16_eotS);
    static final short[] DFA16_eof = DFA.unpackEncodedString(DFA16_eofS);
    static final char[] DFA16_min = DFA.unpackEncodedStringToUnsignedChars(DFA16_minS);
    static final char[] DFA16_max = DFA.unpackEncodedStringToUnsignedChars(DFA16_maxS);
    static final short[] DFA16_accept = DFA.unpackEncodedString(DFA16_acceptS);
    static final short[] DFA16_special = DFA.unpackEncodedString(DFA16_specialS);
    static final short[][] DFA16_transition;

    static {
        int numStates = DFA16_transitionS.length;
        DFA16_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA16_transition[i] = DFA.unpackEncodedString(DFA16_transitionS[i]);
        }
    }

    class DFA16 extends DFA {

        public DFA16(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 16;
            this.eot = DFA16_eot;
            this.eof = DFA16_eof;
            this.min = DFA16_min;
            this.max = DFA16_max;
            this.accept = DFA16_accept;
            this.special = DFA16_special;
            this.transition = DFA16_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( CR | LF | SPACE | TAB | SEMI_COLUMN | QUESTION_MARK | COLUMN | QUOT_1 | QUOT_2 | QUOT_3 | NUMBER | FLOAT | ID | PUNCTUATION | STRING | LINE_COMMENT_START_1 | LINE_COMMENT_START_2 | LINE_COMMENT_START_3 | MULTI_LINE_COMMENT_START | MULTI_LINE_COMMENT_END | LINE_COMMENT | MULTI_LINE_COMMENT | WORD );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA16_14 = input.LA(1);

                        s = -1;
                        if ( ((LA16_14 >= '0' && LA16_14 <= '9')||(LA16_14 >= 'A' && LA16_14 <= 'Z')||LA16_14=='_'||(LA16_14 >= 'a' && LA16_14 <= 'z')) ) {s = 29;}

                        else if ( ((LA16_14 >= '\u0000' && LA16_14 <= '\b')||(LA16_14 >= '\u000B' && LA16_14 <= '\f')||(LA16_14 >= '\u000E' && LA16_14 <= '\u001F')||(LA16_14 >= '#' && LA16_14 <= '%')||LA16_14==':'||LA16_14=='='||LA16_14=='?'||(LA16_14 >= '[' && LA16_14 <= ']')||LA16_14=='{'||(LA16_14 >= '}' && LA16_14 <= '\uFFFF')) ) {s = 20;}

                        else s = 28;

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA16_9 = input.LA(1);

                        s = -1;
                        if ( ((LA16_9 >= '\u0000' && LA16_9 <= '\uFFFF')) ) {s = 22;}

                        else s = 23;

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA16_19 = input.LA(1);

                        s = -1;
                        if ( ((LA16_19 >= '\u0000' && LA16_19 <= '\uFFFF')) ) {s = 35;}

                        else s = 34;

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA16_0 = input.LA(1);

                        s = -1;
                        if ( (LA16_0=='\r') ) {s = 1;}

                        else if ( (LA16_0=='\n') ) {s = 2;}

                        else if ( (LA16_0==' ') ) {s = 3;}

                        else if ( (LA16_0=='\t') ) {s = 4;}

                        else if ( (LA16_0==';') ) {s = 5;}

                        else if ( (LA16_0=='?') ) {s = 6;}

                        else if ( (LA16_0==':') ) {s = 7;}

                        else if ( (LA16_0=='\'') ) {s = 8;}

                        else if ( (LA16_0=='\"') ) {s = 9;}

                        else if ( (LA16_0=='`') ) {s = 10;}

                        else if ( ((LA16_0 >= '0' && LA16_0 <= '9')) ) {s = 11;}

                        else if ( ((LA16_0 >= 'a' && LA16_0 <= 'z')) ) {s = 12;}

                        else if ( ((LA16_0 >= 'A' && LA16_0 <= 'Z')) ) {s = 13;}

                        else if ( (LA16_0=='_') ) {s = 14;}

                        else if ( (LA16_0=='!'||LA16_0=='&'||(LA16_0 >= '(' && LA16_0 <= ')')||(LA16_0 >= '+' && LA16_0 <= ',')||LA16_0=='.'||LA16_0=='<'||LA16_0=='>'||LA16_0=='@'||LA16_0=='^'||LA16_0=='|') ) {s = 15;}

                        else if ( (LA16_0=='-') ) {s = 16;}

                        else if ( (LA16_0=='*') ) {s = 17;}

                        else if ( (LA16_0=='/') ) {s = 18;}

                        else if ( (LA16_0=='#') ) {s = 19;}

                        else if ( ((LA16_0 >= '\u0000' && LA16_0 <= '\b')||(LA16_0 >= '\u000B' && LA16_0 <= '\f')||(LA16_0 >= '\u000E' && LA16_0 <= '\u001F')||(LA16_0 >= '$' && LA16_0 <= '%')||LA16_0=='='||(LA16_0 >= '[' && LA16_0 <= ']')||LA16_0=='{'||(LA16_0 >= '}' && LA16_0 <= '\uFFFF')) ) {s = 20;}

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA16_29 = input.LA(1);

                        s = -1;
                        if ( ((LA16_29 >= '0' && LA16_29 <= '9')||(LA16_29 >= 'A' && LA16_29 <= 'Z')||LA16_29=='_'||(LA16_29 >= 'a' && LA16_29 <= 'z')) ) {s = 29;}

                        else if ( ((LA16_29 >= '\u0000' && LA16_29 <= '\b')||(LA16_29 >= '\u000B' && LA16_29 <= '\f')||(LA16_29 >= '\u000E' && LA16_29 <= '\u001F')||(LA16_29 >= '#' && LA16_29 <= '%')||LA16_29==':'||LA16_29=='='||LA16_29=='?'||(LA16_29 >= '[' && LA16_29 <= ']')||LA16_29=='{'||(LA16_29 >= '}' && LA16_29 <= '\uFFFF')) ) {s = 20;}

                        else s = 28;

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA16_30 = input.LA(1);

                        s = -1;
                        if ( ((LA16_30 >= '\u0000' && LA16_30 <= '\uFFFF')) ) {s = 35;}

                        else s = 36;

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA16_11 = input.LA(1);

                        s = -1;
                        if ( ((LA16_11 >= '0' && LA16_11 <= '9')) ) {s = 26;}

                        else if ( (LA16_11=='.') ) {s = 27;}

                        else if ( ((LA16_11 >= '\u0000' && LA16_11 <= '\b')||(LA16_11 >= '\u000B' && LA16_11 <= '\f')||(LA16_11 >= '\u000E' && LA16_11 <= '\u001F')||(LA16_11 >= '#' && LA16_11 <= '%')||LA16_11==':'||LA16_11=='='||LA16_11=='?'||(LA16_11 >= 'A' && LA16_11 <= ']')||LA16_11=='_'||(LA16_11 >= 'a' && LA16_11 <= '{')||(LA16_11 >= '}' && LA16_11 <= '\uFFFF')) ) {s = 20;}

                        else s = 25;

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA16_10 = input.LA(1);

                        s = -1;
                        if ( ((LA16_10 >= '\u0000' && LA16_10 <= '\uFFFF')) ) {s = 22;}

                        else s = 24;

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA16_12 = input.LA(1);

                        s = -1;
                        if ( ((LA16_12 >= '\u0000' && LA16_12 <= '\b')||(LA16_12 >= '\u000B' && LA16_12 <= '\f')||(LA16_12 >= '\u000E' && LA16_12 <= '\u001F')||(LA16_12 >= '#' && LA16_12 <= '%')||(LA16_12 >= '0' && LA16_12 <= ':')||LA16_12=='='||LA16_12=='?'||(LA16_12 >= 'A' && LA16_12 <= ']')||LA16_12=='_'||(LA16_12 >= 'a' && LA16_12 <= '{')||(LA16_12 >= '}' && LA16_12 <= '\uFFFF')) ) {s = 20;}

                        else s = 28;

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA16_13 = input.LA(1);

                        s = -1;
                        if ( ((LA16_13 >= '\u0000' && LA16_13 <= '\b')||(LA16_13 >= '\u000B' && LA16_13 <= '\f')||(LA16_13 >= '\u000E' && LA16_13 <= '\u001F')||(LA16_13 >= '#' && LA16_13 <= '%')||(LA16_13 >= '0' && LA16_13 <= ':')||LA16_13=='='||LA16_13=='?'||(LA16_13 >= 'A' && LA16_13 <= ']')||LA16_13=='_'||(LA16_13 >= 'a' && LA16_13 <= '{')||(LA16_13 >= '}' && LA16_13 <= '\uFFFF')) ) {s = 20;}

                        else s = 28;

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA16_33 = input.LA(1);

                        s = -1;
                        if ( ((LA16_33 >= '\u0000' && LA16_33 <= '\uFFFF')) ) {s = 39;}

                        else s = 38;

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA16_26 = input.LA(1);

                        s = -1;
                        if ( ((LA16_26 >= '0' && LA16_26 <= '9')) ) {s = 26;}

                        else if ( (LA16_26=='.') ) {s = 27;}

                        else if ( ((LA16_26 >= '\u0000' && LA16_26 <= '\b')||(LA16_26 >= '\u000B' && LA16_26 <= '\f')||(LA16_26 >= '\u000E' && LA16_26 <= '\u001F')||(LA16_26 >= '#' && LA16_26 <= '%')||LA16_26==':'||LA16_26=='='||LA16_26=='?'||(LA16_26 >= 'A' && LA16_26 <= ']')||LA16_26=='_'||(LA16_26 >= 'a' && LA16_26 <= '{')||(LA16_26 >= '}' && LA16_26 <= '\uFFFF')) ) {s = 20;}

                        else s = 25;

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA16_32 = input.LA(1);

                        s = -1;
                        if ( ((LA16_32 >= '\u0000' && LA16_32 <= '\uFFFF')) ) {s = 35;}

                        else s = 37;

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA16_8 = input.LA(1);

                        s = -1;
                        if ( ((LA16_8 >= '\u0000' && LA16_8 <= '\uFFFF')) ) {s = 22;}

                        else s = 21;

                        if ( s>=0 ) return s;
                        break;
            }
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 16, _s, input);
            error(nvae);
            throw nvae;
        }

    }
 

}