/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.reflect;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.batoo.common.BatooException;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.reflect.ReflectHelper;

public class FieldAccessor
extends AbstractAccessor {
    private final Field field;
    private final PrimitiveType primitiveType;
    private Class<?> numberType;

    public FieldAccessor(Field field) {
        this.field = field;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FieldAccessor.this.field.setAccessible(true);
                return null;
            }
        });
        this.primitiveType = this.getPrimitiveType();
        if (Number.class.isAssignableFrom(this.field.getType()) || this.field.getType() == Byte.TYPE || this.field.getType() == Short.TYPE || this.field.getType() == Integer.TYPE || this.field.getType() == Long.TYPE) {
            this.numberType = this.field.getType();
        }
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (Exception e) {
            throw new BatooException("Cannot get field value: " + this.field, e);
        }
    }

    private PrimitiveType getPrimitiveType() {
        Class<?> type = this.field.getType();
        if (type.isPrimitive()) {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                if (primitiveType.clazz != type) continue;
                return primitiveType;
            }
        }
        return null;
    }

    @Override
    public void set(Object instance, Object value) {
        if (instance == null) {
            throw new NullPointerException();
        }
        try {
            if (this.primitiveType == null) {
                if (this.numberType != null && value != null && this.numberType != value.getClass()) {
                    Number number = ReflectHelper.convertNumber((Number)value, this.numberType);
                    this.field.set(instance, number);
                } else {
                    this.field.set(instance, value);
                }
            } else {
                switch (this.primitiveType) {
                    case BOOLEAN: {
                        if (value instanceof Number) {
                            this.field.set(instance, ((Number)value).byteValue() != 0);
                            break;
                        }
                        this.field.set(instance, value);
                        break;
                    }
                    case INTEGER: {
                        this.field.set(instance, value);
                        break;
                    }
                    case FLOAT: {
                        this.field.set(instance, Float.valueOf(((Number)value).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.field.set(instance, value);
                        break;
                    }
                    case LONG: {
                        this.field.set(instance, value);
                        break;
                    }
                    case SHORT: {
                        this.field.set(instance, ((Number)value).shortValue());
                        break;
                    }
                    case BYTE: {
                        this.field.set(instance, ((Number)value).byteValue());
                        break;
                    }
                    default: {
                        if (value == null) {
                            this.field.set(instance, Character.valueOf('\u0000'));
                            break;
                        }
                        this.field.set(instance, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set field value: " + this.field, e);
        }
    }

    private static enum PrimitiveType {
        BOOLEAN(Boolean.TYPE),
        INTEGER(Integer.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE),
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        LONG(Long.TYPE),
        CHAR(Character.TYPE);

        private final Class<?> clazz;

        private PrimitiveType(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

