/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.jdbc.Joinable;

public class ManagedMap<X, K, V>
extends ManagedCollection<V>
implements Map<K, V> {
    private HashMap<K, V> delegate;
    private HashMap<K, V> snapshot;
    private boolean initialized;

    public ManagedMap() {
    }

    public ManagedMap(PluralMappingEx<?, ?, V> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        super(mapping, managedInstance);
        this.delegate = Maps.newHashMap();
        this.initialized = !lazy;
    }

    public ManagedMap(PluralMappingEx<?, ?, V> mapping, ManagedInstance<?> managedInstance, Map<? extends K, ? extends V> values) {
        this(mapping, managedInstance, false);
        this.delegate = Maps.newHashMap(values);
        this.initialized = true;
    }

    @Override
    public boolean addChild(EntryImpl<Object, ManagedInstance<?>> child) {
        Object k = child.getKey();
        Object v = child.getValue().getInstance();
        if (!this.delegate.keySet().contains(k) && !this.delegate.values().contains(v)) {
            this.delegate.put(k, v);
            return true;
        }
        return false;
    }

    @Override
    public boolean addElement(EntryImpl<Object, ?> child) {
        Object k = child.getKey();
        Object v = child.getValue();
        if (!this.delegate.keySet().contains(k) && !this.delegate.values().contains(v)) {
            this.delegate.put(k, v);
            return true;
        }
        return false;
    }

    private void attachChildren(Connection connection, ManagedInstance<?> instance, PluralMappingEx<?, ?, V> mapping, Collection<K> keySet) throws SQLException {
        int insertBatchSize = this.getInsertBatchSize();
        Joinable[] batch = new Joinable[insertBatchSize];
        Iterator<K> i = keySet.iterator();
        while (i.hasNext()) {
            int batchSize;
            for (batchSize = 0; i.hasNext() && batchSize < insertBatchSize; ++batchSize) {
                K key = i.next();
                V child = this.delegate.get(key);
                batch[batchSize] = new Joinable(key, child, 0);
            }
            if (batchSize <= 0) continue;
            mapping.attach(connection, instance, batch, batchSize);
        }
    }

    @Override
    public void clear() {
        this.snapshot();
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.initialize();
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.initialize();
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.initialize();
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    @Override
    public void flush(Connection connection, boolean removals, boolean force) throws SQLException {
        if (this.removed(connection, removals)) {
            return;
        }
        ManagedInstance<?> instance = this.getManagedInstance();
        PluralMappingEx mapping = this.getMapping();
        if (force) {
            this.attachChildren(connection, instance, mapping, this.delegate.keySet());
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        if (removals) {
            List<K> childrenRemoved = BatooUtils.subtract(this.snapshot.keySet(), this.delegate.keySet());
            for (int i = 0; i < childrenRemoved.size(); ++i) {
                K key = childrenRemoved.get(i);
                mapping.detach(connection, instance, key, this.snapshot.get(key));
            }
        } else {
            List<K> childrenAdded = BatooUtils.subtract(this.delegate.keySet(), this.snapshot.keySet());
            this.attachChildren(connection, instance, mapping, childrenAdded);
        }
    }

    @Override
    public V get(Object key) {
        this.initialize();
        return this.delegate.get(key);
    }

    @Override
    public Collection<V> getDelegate() {
        return this.delegate.values();
    }

    @Override
    protected Collection<V> getSnapshot() {
        return this.snapshot != null ? this.snapshot.values() : null;
    }

    @Override
    public void initialize() {
        if (!this.initialized) {
            if (this.getManagedInstance() == null) {
                throw new PersistenceException("No session to initialize the collection");
            }
            this.delegate.putAll(this.getMapping().loadMap(this.getManagedInstance()));
            this.initialized = true;
        }
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Set<K> keySet() {
        this.initialize();
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    private UnsupportedOperationException noDuplicates() {
        return new UnsupportedOperationException("Duplicates are not supported");
    }

    @Override
    public V put(K key, V value) {
        this.snapshot();
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (this.delegate.values().contains(value)) {
            throw this.noDuplicates();
        }
        if (this.delegate.values().contains(key)) {
            throw this.noDuplicates();
        }
        V v = this.delegate.put(key, value);
        this.changed();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.snapshot();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void refreshChildren() {
        if (this.initialized) {
            super.reset();
            this.snapshot = null;
            this.delegate.clear();
            this.delegate.putAll(this.getMapping().loadMap(this.getManagedInstance()));
        }
    }

    @Override
    public V remove(Object key) {
        this.snapshot();
        if (this.delegate.containsKey(key)) {
            this.changed();
        }
        return this.delegate.remove(key);
    }

    @Override
    protected void removeChild(V child) {
        for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
            if (!entry.getValue().equals(child)) continue;
            this.delegate.remove(entry.getKey());
            break;
        }
    }

    @Override
    public int size() {
        this.initialize();
        return this.delegate.size();
    }

    @Override
    protected void snapshot() {
        this.initialize();
        if (this.getManagedInstance() != null && this.snapshot == null) {
            this.snapshot = Maps.newHashMap(this.delegate);
            this.reset();
        }
    }

    public String toString() {
        String instance = this.getManagedInstance().getType().getName() + "@" + this.getManagedInstance().getId().getId();
        return "ManagedMap [initialized=" + this.initialized + ", managedInstance=" + instance + ", delegate=" + this.delegate + ", snapshot=" + this.snapshot + ", mapping=" + this.getMapping() + "]";
    }

    @Override
    public Collection<V> values() {
        this.initialize();
        return Collections.unmodifiableCollection(this.delegate.values());
    }
}

