/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.WrappedIterator;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.jdbc.Joinable;

public class ManagedSet<X, E>
extends ManagedCollection<E>
implements Set<E> {
    private HashSet<E> delegate;
    private transient HashSet<E> snapshot;
    private boolean initialized;

    public ManagedSet() {
    }

    public ManagedSet(PluralMappingEx<?, ?, E> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        super(mapping, managedInstance);
        this.delegate = Sets.newHashSet();
        this.initialized = !lazy;
    }

    public ManagedSet(PluralMappingEx<?, ?, E> mapping, ManagedInstance<?> managedInstance, Collection<? extends E> values) {
        super(mapping, managedInstance);
        this.delegate = Sets.newHashSet(values);
        this.initialized = true;
    }

    @Override
    public boolean add(E e) {
        this.snapshot();
        if (this.delegate.add(e)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.snapshot();
        if (this.delegate.addAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addChild(EntryImpl<Object, ManagedInstance<?>> child) {
        Object e = child.getValue().getInstance();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    @Override
    public boolean addElement(EntryImpl<Object, ?> child) {
        Object e = child.getValue();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    private void attachChildren(Connection connection, ManagedInstance<?> instance, PluralMappingEx<?, ?, E> mapping, Collection<E> children) throws SQLException {
        int insertBatchSize = this.getInsertBatchSize();
        Joinable[] batch = new Joinable[insertBatchSize];
        Iterator<E> i = children.iterator();
        while (i.hasNext()) {
            int batchSize;
            for (batchSize = 0; i.hasNext() && batchSize < insertBatchSize; ++batchSize) {
                E child = i.next();
                batch[batchSize] = new Joinable(null, child, 0);
            }
            if (batchSize <= 0) continue;
            mapping.attach(connection, instance, batch, batchSize);
        }
    }

    @Override
    public void clear() {
        this.snapshot();
        if (this.delegate.size() > 0) {
            this.changed();
        }
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.initialize();
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        this.initialize();
        return this.delegate.equals(obj);
    }

    @Override
    public void flush(Connection connection, boolean removals, boolean force) throws SQLException {
        if (this.removed(connection, removals)) {
            return;
        }
        ManagedInstance<?> managedInstance = this.getManagedInstance();
        PluralMappingEx mapping = this.getMapping();
        if (force) {
            this.attachChildren(connection, managedInstance, mapping, this.delegate);
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        if (removals) {
            List<E> childrenRemoved = BatooUtils.subtract(this.snapshot, this.delegate);
            for (int i = 0; i < childrenRemoved.size(); ++i) {
                mapping.detach(connection, managedInstance, null, childrenRemoved.get(i));
            }
        } else {
            List<E> childrenAdded = BatooUtils.subtract(this.delegate, this.snapshot);
            this.attachChildren(connection, managedInstance, mapping, childrenAdded);
        }
    }

    @Override
    public Set<E> getDelegate() {
        return this.delegate;
    }

    @Override
    protected Collection<E> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.delegate.hashCode();
    }

    @Override
    public void initialize() {
        if (!this.initialized) {
            if (this.getManagedInstance() == null) {
                throw new PersistenceException("No session to initialize the collection");
            }
            this.delegate.addAll(this.getMapping().loadCollection(this.getManagedInstance()));
            this.initialized = true;
        }
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Iterator<E> iterator() {
        this.initialize();
        return new WrappedIterator<E>(this.delegate.iterator()){

            @Override
            public void remove() {
                ManagedSet.this.snapshot();
                ManagedSet.this.changed();
                super.remove();
            }
        };
    }

    @Override
    public void refreshChildren() {
        if (this.initialized) {
            this.reset();
            this.snapshot = null;
            this.delegate.clear();
            this.delegate.addAll(this.getMapping().loadCollection(this.getManagedInstance()));
        }
    }

    @Override
    public boolean remove(Object o) {
        this.snapshot();
        if (this.delegate.remove(o)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.removeAll(c)) {
            this.changed();
        }
        return false;
    }

    @Override
    protected void removeChild(E child) {
        this.delegate.remove(child);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.retainAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        this.initialize();
        return this.delegate.size();
    }

    @Override
    protected void snapshot() {
        this.initialize();
        if (this.getManagedInstance() != null && this.snapshot == null) {
            this.snapshot = Sets.newHashSet(this.delegate);
            this.reset();
        }
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.initialize();
        return this.delegate.toArray(a);
    }

    public String toString() {
        String instance = this.getManagedInstance().getType().getName() + "@" + this.getManagedInstance().getId().getId();
        return "ManagedSet [initialized=" + this.initialized + ", managedInstance=" + instance + ", delegate=" + this.delegate + ", snapshot=" + this.snapshot + ", mapping=" + this.getMapping() + "]";
    }
}

