/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;

public abstract class BaseQueryImpl<T>
implements BaseQuery<T> {
    private final MetamodelImpl metamodel;
    private int nextEntityAlias;
    private int nextSelection;
    private int nextparam;
    private final HashMap<Selection<?>, String> selections = Maps.newHashMap();
    private final HashBiMap<AbstractParameterExpressionImpl<?>, Integer> parameters = HashBiMap.create();
    private final HashMap<String, List<AbstractColumn>> fields = Maps.newHashMap();
    private FinalWrapper<String> sql;
    private FinalWrapper<String> jpql;
    private final List<AbstractParameterExpressionImpl<?>> sqlParameters = Lists.newArrayList();

    public BaseQueryImpl(MetamodelImpl metamodel) {
        this.metamodel = metamodel;
    }

    public BaseQueryImpl(MetamodelImpl metamodel, String qlString) {
        this.metamodel = metamodel;
    }

    @Override
    public String generateTableAlias(boolean entity) {
        return "E" + (!entity ? "C" : "") + this.nextEntityAlias++;
    }

    @Override
    public Integer getAlias(AbstractParameterExpressionImpl<?> parameter) {
        Integer alias = (Integer)this.parameters.get(parameter);
        if (alias == null) {
            if (parameter.getAlias() == null) {
                alias = ++this.nextparam;
            } else {
                try {
                    alias = Integer.parseInt(parameter.getAlias());
                }
                catch (Exception e) {
                    alias = ++this.nextparam;
                }
            }
            this.parameters.put(parameter, (Object)alias);
        }
        return alias;
    }

    @Override
    public String getAlias(AbstractSelection<?> selection) {
        String alias = this.selections.get(selection);
        if (alias == null) {
            alias = "S" + this.nextSelection++;
            this.selections.put(selection, alias);
        }
        return alias;
    }

    @Override
    public String getFieldAlias(String tableAlias, AbstractColumn column) {
        int i;
        ArrayList fields = this.fields.get(tableAlias);
        if (fields == null) {
            fields = Lists.newArrayList();
            this.fields.put(tableAlias, fields);
        }
        if ((i = fields.indexOf(column)) >= 0) {
            return Integer.toString(i);
        }
        fields.add(column);
        return Integer.toString(fields.size() - 1);
    }

    @Override
    public JdbcAdaptor getJdbcAdaptor() {
        return this.metamodel.getJdbcAdaptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJpql() {
        FinalWrapper<String> wrapper = this.jpql;
        if (wrapper == null) {
            BaseQueryImpl baseQueryImpl = this;
            synchronized (baseQueryImpl) {
                if (this.jpql == null) {
                    this.jpql = new FinalWrapper<String>(this.generateJpql());
                }
                wrapper = this.jpql;
            }
        }
        return (String)wrapper.value;
    }

    @Override
    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    @Override
    public AbstractParameterExpressionImpl<?> getParameter(int position) {
        return (AbstractParameterExpressionImpl)this.parameters.inverse().get((Object)position);
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        for (AbstractParameterExpressionImpl parameter : this.parameters.keySet()) {
            if (!(parameter instanceof ParameterExpressionImpl)) continue;
            parameters.add((ParameterExpression)parameter);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSql() {
        FinalWrapper<String> wrapper = this.sql;
        if (wrapper == null) {
            BaseQueryImpl baseQueryImpl = this;
            synchronized (baseQueryImpl) {
                if (this.sql == null) {
                    try {
                        this.sql = new FinalWrapper<String>(this.generateSql());
                    }
                    catch (Exception e) {
                        String jpql = null;
                        try {
                            jpql = this.getJpql();
                            throw new PersistenceException("Cannot generate query for: " + jpql, (Throwable)e);
                        }
                        catch (Exception e2) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new PersistenceException("Cannot generate SQL for query", (Throwable)e);
                        }
                    }
                }
                wrapper = this.sql;
            }
        }
        return (String)wrapper.value;
    }

    @Override
    public List<AbstractParameterExpressionImpl<?>> getSqlParameters() {
        return this.sqlParameters;
    }

    public abstract boolean isQuery();

    @Override
    public int setNextSqlParam(AbstractParameterExpressionImpl<?> parameter) {
        Integer position;
        if (parameter instanceof ParameterExpressionImpl && (position = ((ParameterExpressionImpl)parameter).getPosition()) != null) {
            this.sqlParameters.add(parameter);
            return position;
        }
        this.sqlParameters.add(parameter);
        return this.sqlParameters.size() - 1;
    }
}

