/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.base.Joiner;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.RootImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;

public abstract class CriteriaModify<T>
extends BaseQueryImpl<T> {
    private RootImpl<T> root;
    private PredicateImpl restriction;
    private String jpql;

    public CriteriaModify(MetamodelImpl metamodel) {
        super(metamodel);
    }

    public CriteriaModify(MetamodelImpl metamodel, String qlString) {
        super(metamodel);
        this.jpql = qlString;
    }

    public Root<T> from(Class<T> entityClass) {
        if (this.root != null) {
            throw new IllegalStateException("Root has already assigned");
        }
        this.root = new RootImpl(this.getMetamodel().getEntity(entityClass));
        return this.root;
    }

    public Root<T> from(EntityType<T> entity) {
        if (this.root != null) {
            throw new IllegalStateException("Root has already assigned");
        }
        this.root = new RootImpl((EntityTypeImpl)entity);
        return this.root;
    }

    protected String generateSqlRestriction() {
        Object[] restrictions = new String[2];
        if (this.getRestriction() != null) {
            restrictions[0] = this.getRestriction().generateSqlRestriction(this);
        }
        restrictions[1] = this.getRoot().generateDiscrimination(false);
        String restriction = Joiner.on((String)") AND (").skipNulls().join(restrictions);
        if (StringUtils.isBlank((String)restriction)) {
            return null;
        }
        return "(" + restriction + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJpql() {
        if (this.jpql != null) {
            return this.jpql;
        }
        CriteriaModify criteriaModify = this;
        synchronized (criteriaModify) {
            if (this.jpql != null) {
                return this.jpql;
            }
            this.jpql = this.generateJpql();
            return this.jpql;
        }
    }

    public PredicateImpl getRestriction() {
        return this.restriction;
    }

    public RootImpl<T> getRoot() {
        return this.root;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public <U> SubqueryImpl<U> subquery(Class<U> type) {
        return new SubqueryImpl<U>(this.getMetamodel(), this, type);
    }

    public CriteriaModify<T> where(Expression<Boolean> restriction) {
        this.restriction = new PredicateImpl((AbstractExpression<Boolean>)((AbstractExpression)restriction));
        return this;
    }

    public CriteriaModify<T> where(Predicate ... restrictions) {
        this.restriction = new PredicateImpl((AbstractExpression<Boolean>)this.restriction);
        return this;
    }
}

