/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class ComparisonExpression
extends AbstractExpression<Boolean> {
    private final Comparison comparison;
    private final AbstractExpression<?> x;
    private final AbstractExpression<?> y;
    private final AbstractExpression<?> z;
    private String alias;

    public ComparisonExpression(Comparison comparison, Expression<?> x, Expression<?> y) {
        this(comparison, x, y, null);
    }

    public ComparisonExpression(Comparison comparison, Expression<?> x, Expression<?> y, Expression<?> z) {
        super(Boolean.class);
        this.comparison = comparison;
        if (x instanceof ParameterExpression) {
            this.x = (AbstractExpression)y;
            this.y = (AbstractExpression)x;
        } else {
            this.x = (AbstractExpression)x;
            this.y = (AbstractExpression)y;
        }
        this.z = (AbstractExpression)z;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        if (this.z != null) {
            return MessageFormat.format(this.comparison.fragment, this.x.generateJpqlRestriction(query), this.y.generateJpqlRestriction(query), this.z.generateJpqlRestriction(query));
        }
        return MessageFormat.format(this.comparison.fragment, this.x.generateJpqlRestriction(query), this.y.generateJpqlRestriction(query));
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String[] left = this.x.getSqlRestrictionFragments(query);
        String[] right1 = this.y.getSqlRestrictionFragments(query);
        String[] right2 = this.z != null ? this.z.getSqlRestrictionFragments(query) : null;
        ArrayList restrictions = Lists.newArrayList();
        for (int i = 0; i < left.length; ++i) {
            if (this.z != null) {
                restrictions.add(MessageFormat.format(this.comparison.fragment, left[i], right1[i], right2[i]));
                continue;
            }
            restrictions.add(MessageFormat.format(this.comparison.fragment, left[i], right1[i]));
        }
        return new String[]{Joiner.on((String)" AND ").join((Iterable)restrictions)};
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Boolean)row.getObject(this.alias);
    }

    public static enum Comparison {
        EQUAL("{0} = {1}"),
        NOT_EQUAL("{0} <> {1}"),
        LESS("{0} < {1}"),
        LESS_OR_EQUAL("{0} <= {1}"),
        GREATER("{0} > {1}"),
        GREATER_OR_EQUAL("{0} >= {1}"),
        BETWEEN("{0} BETWEEN {1} AND {2}");

        private final String fragment;

        private Comparison(String fragment) {
            this.fragment = fragment;
        }
    }
}

