/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractTypeExpression;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.jdbc.DiscriminatorColumn;

public class EntityTypeExpression<T>
extends AbstractTypeExpression<T> {
    private final DiscriminatorColumn discriminatorColumn;
    private EntityTypeImpl<?> entity;

    public EntityTypeExpression(ParentPath<?, T> path, DiscriminatorColumn discriminatorColumn) {
        super(path);
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String tableAlias = this.getPath().getRootPath().getTableAlias(query, this.discriminatorColumn.getTable());
        return new String[]{tableAlias + "." + this.discriminatorColumn.getName()};
    }

    @Override
    public Class<? extends T> handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        if (this.entity == null) {
            this.entity = session.getEntityManager().getMetamodel().entity(this.getPath().getJavaType()).getRootType();
        }
        Object discriminatorValue = this.handle(row);
        return this.entity.getChildType(discriminatorValue).getJavaType();
    }
}

