/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.join;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.criteria.join.FetchImpl;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.CollectionTable;
import org.batoo.jpa.jdbc.DiscriminatorColumn;
import org.batoo.jpa.jdbc.ElementColumn;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.mapping.SingularMapping;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;

public class FetchParentImpl<Z, X>
implements FetchParent<Z, X>,
Joinable {
    private final EntityTypeImpl<X> entity;
    private final TypeImpl<X> type;
    private JoinedMapping<? super Z, ?, X> mapping;
    private final HashMap<AbstractMapping<?, ?, ?>, FetchImpl<X, ?>> fetches = Maps.newHashMap();
    private final ArrayList<FetchImpl<X, ?>> joins = Lists.newArrayList();
    private String alias;
    private String primaryTableAlias;
    private String discriminatorAlias;
    private final HashMap<SecondaryTable, String> tableAliases = Maps.newHashMap();
    private final HashMap<AbstractColumn, String> idFields = Maps.newHashMap();
    private final HashMap<AbstractColumn, String> joinFields = Maps.newHashMap();
    private final Set<SingularAssociationMappingImpl<?, ?>> singularJoins = Sets.newHashSet();
    private int nextTableAlias = 1;
    private AbstractColumn[] columns;
    private String[] fields;
    private String keyColumnAlias;

    public FetchParentImpl(EntityTypeImpl<X> entity) {
        this.entity = entity;
        this.type = null;
    }

    public FetchParentImpl(JoinedMapping<? super Z, ?, X> mapping) {
        this.mapping = mapping;
        if (mapping.getType() instanceof EntityTypeImpl) {
            this.entity = (EntityTypeImpl)mapping.getType();
            this.type = null;
        } else {
            this.type = mapping.getType();
            this.entity = null;
        }
    }

    public final <Y> FetchImpl<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute) {
        return this.fetch((PluralAttribute)attribute, JoinType.LEFT);
    }

    public final <Y> FetchImpl<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute, JoinType jt) {
        return this.fetch(attribute.getName(), jt);
    }

    public final <Y> FetchImpl<X, Y> fetch(SingularAttribute<? super X, Y> attribute) {
        return this.fetch((SingularAttribute)attribute, JoinType.LEFT);
    }

    public final <Y> FetchImpl<X, Y> fetch(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        return this.fetch(attribute.getName(), jt);
    }

    public final <Y> FetchImpl<X, Y> fetch(String attributeName) {
        return this.fetch(attributeName, JoinType.LEFT);
    }

    public <Y> FetchImpl<X, Y> fetch(String attributeName, JoinType jt) {
        AbstractMapping<?, ?, ?> _mapping = this.getMapping(attributeName);
        if (!(_mapping instanceof JoinedMapping)) {
            throw new IllegalArgumentException("Cannot dereference attribute " + attributeName);
        }
        if (this.fetches.get(_mapping) != null) {
            return this.fetches.get(_mapping);
        }
        FetchImpl fetch = new FetchImpl(this, (JoinedMapping)((Object)_mapping), jt);
        this.fetches.put(_mapping, fetch);
        return fetch;
    }

    public String generateDiscrimination(boolean noQualification) {
        if (this.entity.getRootType().getInheritanceType() == null || this.entity == this.entity.getRootType()) {
            return null;
        }
        Collection discriminators = Collections2.transform(this.entity.getDiscriminators(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return "'" + input + "'";
            }
        });
        if (noQualification) {
            return this.entity.getRootType().getDiscriminatorColumn().getName() + " IN (" + Joiner.on((String)",").join((Iterable)discriminators) + ")";
        }
        return this.primaryTableAlias + "." + this.entity.getRootType().getDiscriminatorColumn().getName() + " IN (" + Joiner.on((String)",").join((Iterable)discriminators) + ")";
    }

    public String generateJpqlFetches(final String parent) {
        StringBuilder description = new StringBuilder();
        Collection _fetches = Collections2.transform(this.fetches.values(), (Function)new Function<FetchImpl<X, ?>, String>(){

            public String apply(FetchImpl<X, ?> input) {
                if (input.getMapping().getMappingType() == MappingType.EMBEDDABLE) {
                    return null;
                }
                return input.generateJpqlFetches(parent);
            }
        });
        description.append(Joiner.on((String)"\n").skipNulls().join((Iterable)_fetches));
        return description.toString();
    }

    public void generateSqlJoins(AbstractCriteriaQueryImpl<?> query, List<String> selfJoins) {
        for (Map.Entry<SecondaryTable, String> e : this.tableAliases.entrySet()) {
            String _alias = e.getValue();
            SecondaryTable table = e.getKey();
            selfJoins.add(table.joinPrimary(this.getPrimaryTableAlias(query), _alias));
        }
    }

    public void generateSqlJoins(AbstractCriteriaQueryImpl<?> query, Map<Joinable, String> joins, boolean recurse) {
        ArrayList selfJoins = Lists.newArrayList();
        this.generateSqlJoins(query, selfJoins);
        String join = Joiner.on((String)"\n").skipNulls().join((Iterable)selfJoins);
        if (join != null && join.trim().length() > 0) {
            joins.put(this, join);
        } else {
            joins.put(this, null);
        }
        for (FetchImpl<X, ?> child : this.joins) {
            child.generateSqlJoins(query, joins, false);
        }
        if (recurse) {
            for (FetchImpl<X, ?> fetch : this.fetches.values()) {
                fetch.generateSqlJoins(query, joins, true);
            }
        }
    }

    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected, boolean root) {
        return this.generateSqlSelect(query, selected, root, MapJoinImpl.MapSelectType.VALUE);
    }

    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected, boolean root, MapJoinImpl.MapSelectType selectType) {
        ArrayList selects = Lists.newArrayList();
        if (!(this.getMapping() instanceof EmbeddedMappingImpl)) {
            selects.add(this.generateSqlSelectImpl(query, selected, root, selectType));
        }
        for (FetchImpl<X, ?> fetch : this.fetches.values()) {
            String select = fetch.generateSqlSelect(query, selected, false);
            if (!StringUtils.isNotBlank((String)select)) continue;
            selects.add(select);
        }
        return Joiner.on((String)",\n").join((Iterable)selects);
    }

    private void generateSqlSelectForElementCollection(AbstractCriteriaQueryImpl<?> query, boolean selected, List<String> selects, Map<AbstractColumn, String> fieldMap, MapJoinImpl.MapSelectType selectType) {
        ArrayList fields1 = Lists.newArrayList();
        CollectionTable table = (CollectionTable)this.mapping.getJoinTable();
        String tableAlias = this.getTableAlias(query, table);
        for (AbstractColumn column : table.getColumns()) {
            if (column instanceof JoinColumn || selectType == MapJoinImpl.MapSelectType.KEY && table.getKeyColumn() != null && table.getKeyColumn() != column || selectType == MapJoinImpl.MapSelectType.VALUE && table.getKeyColumn() == column) continue;
            String fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
            String field = Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]);
            if (selected) {
                fields1.add(field + " AS " + fieldAlias);
            } else {
                fields1.add(field);
            }
            if (column == table.getKeyColumn()) {
                this.keyColumnAlias = fieldAlias;
                continue;
            }
            fieldMap.put(column, fieldAlias);
        }
        selects.add(Joiner.on((String)", ").join((Iterable)fields1));
    }

    private void generateSqlSelectForEntityTable(AbstractCriteriaQueryImpl<?> query, boolean selected, boolean root, List<String> selects, Map<AbstractColumn, String> fieldMap, EntityTable table) {
        ArrayList fields1 = Lists.newArrayList();
        String tableAlias = this.getTableAlias(query, table);
        for (AbstractColumn column : table.getColumns()) {
            String field;
            String fieldAlias;
            if (column.isPrimaryKey()) {
                fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
                field = Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]);
                this.idFields.put(column, fieldAlias);
            } else if (column instanceof DiscriminatorColumn) {
                fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
                field = Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]);
                this.discriminatorAlias = fieldAlias;
            } else if (column.getMapping() instanceof SingularAssociationMappingImpl) {
                SingularAssociationMappingImpl _mapping = (SingularAssociationMappingImpl)column.getMapping();
                if (!root && this.ignoreJoin(_mapping)) continue;
                fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
                field = Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]);
                this.singularJoins.add(_mapping);
                this.joinFields.put(column, fieldAlias);
            } else {
                fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
                if (column.getMapping() instanceof BasicMappingImpl && ((BasicAttribute)((BasicMappingImpl)column.getMapping()).getAttribute()).getColumnTransformer() != null) {
                    ColumnTransformerMetadata columnTransformer = ((BasicAttribute)((BasicMappingImpl)column.getMapping()).getAttribute()).getColumnTransformer();
                    String columnSql = Strings.isNullOrEmpty((String)columnTransformer.getRead()) ? column.getName() : columnTransformer.getRead();
                    field = columnSql.replace(column.getName(), Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]));
                } else {
                    field = Joiner.on((String)".").skipNulls().join((Object)tableAlias, (Object)column.getName(), new Object[0]);
                }
                fieldMap.put(column, fieldAlias);
            }
            if (selected) {
                fields1.add(field + " AS " + fieldAlias);
                continue;
            }
            fields1.add(field);
        }
        selects.add(Joiner.on((String)", ").join((Iterable)fields1));
    }

    private String generateSqlSelectImpl(AbstractCriteriaQueryImpl<?> query, boolean selected, boolean root, MapJoinImpl.MapSelectType selectType) {
        ArrayList selects = Lists.newArrayList();
        HashMap fieldMap = Maps.newHashMap();
        if (this.entity != null) {
            for (EntityTable table : this.entity.getAllTables()) {
                this.generateSqlSelectForEntityTable(query, selected, root, selects, fieldMap, table);
            }
            for (SingularAssociationMappingImpl<?, ?> associationMapping : this.entity.getAssociationsSingular()) {
                if (associationMapping.getForeignKey() == null || !associationMapping.getForeignKey().isReadOnly()) continue;
                this.singularJoins.add(associationMapping);
            }
        } else {
            this.generateSqlSelectForElementCollection(query, selected, selects, fieldMap, selectType);
        }
        this.columns = new AbstractColumn[fieldMap.size()];
        this.fields = new String[fieldMap.size()];
        int i = 0;
        for (Map.Entry entry : fieldMap.entrySet()) {
            this.columns[i] = (AbstractColumn)entry.getKey();
            this.fields[i] = (String)entry.getValue();
            ++i;
        }
        return Joiner.on((String)",\n\t").join((Iterable)selects);
    }

    private String getAlias(BaseQueryImpl<?> query) {
        if (this.alias == null) {
            this.alias = query.generateTableAlias(this.entity != null);
        }
        return this.alias;
    }

    private Object getAssociateId(ResultSet row, EntityTypeImpl<?> entity, SingularAssociationMappingImpl<?, ?> mapping) throws SQLException {
        SingularMapping idMapping;
        if (entity.hasSingleIdAttribute() && (idMapping = this.entity.getIdMapping()) instanceof BasicMappingImpl) {
            JoinColumn column = mapping.getForeignKey().getJoinColumns().get(0);
            String field = null;
            if (!column.isVirtual()) {
                field = this.joinFields.get(column);
            } else {
                AbstractColumn masterColumn = column.getMasterColumn();
                for (int i = 0; i < this.columns.length; ++i) {
                    if (this.columns[i] != masterColumn) continue;
                    field = this.fields[i];
                    break;
                }
            }
            return row.getObject(field);
        }
        return null;
    }

    @Override
    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    public final Set<Fetch<X, ?>> getFetches() {
        HashSet _fetches = Sets.newHashSet();
        _fetches.addAll(this.fetches.values());
        return _fetches;
    }

    private <Y extends X> ManagedInstance<Y> getInstance(SessionImpl session, ResultSet row) throws SQLException {
        ManagedId<X> managedId = this.entity.getId(session, row, this.idFields);
        if (managedId == null) {
            return null;
        }
        ManagedInstance<ManagedId<X>> instance = session.get(managedId);
        if (instance != null) {
            if (!(instance.getInstance() instanceof EnhancedInstance)) {
                return instance;
            }
            EnhancedInstance enhancedInstance = (EnhancedInstance)((Object)instance.getInstance());
            if (!enhancedInstance.__enhanced__$$__isInitialized()) {
                this.initializeInstance(session, row, instance);
                session.lazyInstanceLoading(instance);
                enhancedInstance.__enhanced__$$__setInitialized();
            }
            return instance;
        }
        if (this.entity.getInheritanceType() == null) {
            instance = this.entity.getManagedInstanceById(session, managedId, false);
        } else {
            Object discriminatorValue = row.getObject(this.discriminatorAlias);
            EntityTypeImpl<X> effectiveType = this.entity.getChildType(discriminatorValue);
            if (effectiveType == null) {
                throw new IllegalArgumentException("Discriminator " + discriminatorValue + " not found in the type " + this.entity.getName());
            }
            instance = effectiveType.getManagedInstanceById(session, managedId, false);
        }
        this.initializeInstance(session, row, instance);
        session.put(instance);
        return instance;
    }

    public JoinedMapping<? super Z, ?, X> getMapping() {
        return null;
    }

    private AbstractMapping<?, ?, ?> getMapping(String attributeName) {
        if (this.entity != null) {
            return this.entity.getRootMapping().getMapping(attributeName);
        }
        if (this.type instanceof EmbeddableTypeImpl) {
            if (this.getMapping() instanceof EmbeddedMappingImpl) {
                return ((EmbeddedMappingImpl)this.getMapping()).getChild(attributeName);
            }
            return ((ElementCollectionMappingImpl)this.getMapping()).getMapping(attributeName);
        }
        return null;
    }

    public String getPrimaryTableAlias(BaseQueryImpl<?> query) {
        if (this.primaryTableAlias == null) {
            this.primaryTableAlias = this.getAlias(query) + "_P";
        }
        return this.primaryTableAlias;
    }

    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query, MapJoinImpl.MapSelectType selectType) {
        ArrayList restrictions = Lists.newArrayList();
        if (this.entity != null) {
            for (AbstractColumn column : this.entity.getRootType().getPrimaryTable().getPkColumns()) {
                if (query.isQuery()) {
                    restrictions.add(this.getPrimaryTableAlias(query) + "." + column.getName());
                    continue;
                }
                restrictions.add(column.getName());
            }
        }
        if (this.mapping instanceof ElementCollectionMappingImpl) {
            ElementCollectionMappingImpl elementCollectionMapping = (ElementCollectionMappingImpl)this.mapping;
            CollectionTable collectionTable = elementCollectionMapping.getCollectionTable();
            ElementColumn elementColumn = collectionTable.getElementColumn();
            restrictions.add(this.getPrimaryTableAlias(query) + "." + elementColumn.getName());
        }
        return restrictions.toArray(new String[restrictions.size()]);
    }

    @Override
    public String getTableAlias(BaseQueryImpl<?> query, AbstractTable table) {
        if (table instanceof SecondaryTable) {
            String _alias = this.tableAliases.get(table);
            if (_alias == null) {
                _alias = this.alias + "_S" + this.nextTableAlias++;
                this.tableAliases.put((SecondaryTable)table, _alias);
            }
            return _alias;
        }
        return this.getPrimaryTableAlias(query);
    }

    public X handle(SessionImpl session, ResultSet row) throws SQLException {
        return (X)this.handle(session, row, MapJoinImpl.MapSelectType.VALUE).getValue().getInstance();
    }

    public EntryImpl<Object, ManagedInstance<?>> handle(SessionImpl session, ResultSet row, MapJoinImpl.MapSelectType selectType) throws SQLException {
        return this.handleFetch(session, row, selectType);
    }

    private void handleAssociationFetch(SessionImpl session, ResultSet row, Object instance, FetchImpl<X, ?> fetch) throws SQLException {
        EntryImpl<Object, ManagedInstance<?>> pair = fetch.handleFetch(session, row, MapJoinImpl.MapSelectType.ENTRY);
        if (pair == null) {
            return;
        }
        ManagedInstance<?> child = pair.getValue();
        AssociationMappingImpl _mapping = (AssociationMappingImpl)fetch.getMapping();
        if (_mapping.getMappingType() == MappingType.PLURAL_ASSOCIATION) {
            if (((ManagedCollection)_mapping.get(instance)).addChild(pair) && _mapping.getInverse() != null && _mapping.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY) {
                _mapping.getInverse().set(child.getInstance(), instance);
                child.setJoinLoaded(_mapping.getInverse());
            }
        } else {
            _mapping.set(instance, child.getInstance());
            if (_mapping.getInverse() != null && _mapping.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                _mapping.getInverse().set(child.getInstance(), instance);
                child.setJoinLoaded(_mapping);
            }
        }
    }

    private X handleElement(ResultSet row) throws SQLException {
        if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
            return (X)row.getObject(this.fields[0]);
        }
        Object instance = ((EmbeddableTypeImpl)this.type).newInstance();
        for (int i = 0; i < this.fields.length; ++i) {
            this.columns[i].setValue(instance, row.getObject(this.fields[i]));
        }
        return instance;
    }

    private void handleElementCollectionFetch(ResultSet row, Object instance, FetchImpl<X, ?> fetch) throws SQLException {
        EntryImpl<Object, X> child = fetch.handleElementFetch(row, MapJoinImpl.MapSelectType.ENTRY);
        ElementCollectionMappingImpl _mapping = (ElementCollectionMappingImpl)fetch.getMapping();
        ((ManagedCollection)_mapping.get(instance)).addElement(child);
    }

    public EntryImpl<Object, X> handleElementFetch(ResultSet row) throws SQLException {
        return this.handleElementFetch(row, MapJoinImpl.MapSelectType.VALUE);
    }

    public EntryImpl<Object, X> handleElementFetch(ResultSet row, MapJoinImpl.MapSelectType selectType) throws SQLException {
        if (selectType == MapJoinImpl.MapSelectType.VALUE || !this.mapping.isMap()) {
            return new EntryImpl<Object, X>(null, this.handleElement(row));
        }
        if (this.keyColumnAlias != null) {
            if (selectType == MapJoinImpl.MapSelectType.KEY) {
                return new EntryImpl<Object, Object>(row.getObject(this.keyColumnAlias), null);
            }
            return new EntryImpl<Object, X>(row.getObject(this.keyColumnAlias), this.handleElement(row));
        }
        X value = this.handleElement(row);
        Object key = ((ElementCollectionMappingImpl)this.mapping).extractKey(value);
        return new EntryImpl<Object, X>(key, value);
    }

    public EntryImpl<Object, ManagedInstance<?>> handleFetch(SessionImpl session, ResultSet row, MapJoinImpl.MapSelectType selectType) throws SQLException {
        ManagedInstance instance = this.getInstance(session, row);
        if (instance == null) {
            return null;
        }
        if (instance.isRefreshing()) {
            this.initializeInstance(session, row, instance);
        }
        if (instance.isLoading()) {
            this.handleFetches(session, row, instance.getInstance());
        }
        if (selectType == MapJoinImpl.MapSelectType.VALUE || this.mapping == null || !this.mapping.isMap()) {
            return new EntryImpl(null, instance);
        }
        if (this.keyColumnAlias != null) {
            Object key = row.getObject(this.keyColumnAlias);
            return new EntryImpl(key, instance);
        }
        Object key = this.mapping.extractKey(instance.getInstance());
        return new EntryImpl(key, instance);
    }

    void handleFetches(SessionImpl session, ResultSet row, Object instance) throws SQLException {
        block4: for (FetchImpl<X, ?> fetch : this.fetches.values()) {
            MappingType mappingType = fetch.getMapping().getMappingType();
            switch (mappingType) {
                case EMBEDDABLE: {
                    fetch.handleFetches(session, row, instance);
                    continue block4;
                }
                case ELEMENT_COLLECTION: {
                    this.handleElementCollectionFetch(row, instance, fetch);
                    continue block4;
                }
            }
            this.handleAssociationFetch(session, row, instance, fetch);
        }
    }

    private boolean ignoreJoin(SingularAssociationMappingImpl<?, ?> mapping) {
        if (mapping.getInverse() != null && mapping.getInverse() == this.getMapping()) {
            return true;
        }
        for (FetchImpl<X, ?> fetch : this.fetches.values()) {
            if (fetch.getMapping() != mapping) continue;
            return true;
        }
        return false;
    }

    private void initializeInstance(SessionImpl session, ResultSet row, ManagedInstance<? extends X> managedInstance) throws SQLException {
        managedInstance.setLoading(true);
        X instance = managedInstance.getInstance();
        for (int i = 0; i < this.fields.length; ++i) {
            this.columns[i].setValue(instance, row.getObject(this.fields[i]));
        }
        for (SingularAssociationMappingImpl<?, ?> singularAssociationMappingImpl : this.singularJoins) {
            TypeImpl type = singularAssociationMappingImpl.getType();
            Object id = this.getAssociateId(row, (EntityTypeImpl<?>)type, singularAssociationMappingImpl);
            if (id == null) continue;
            Object reference = session.getEntityManager().getReference(type.getJavaType(), id);
            singularAssociationMappingImpl.set(instance, reference);
            managedInstance.setJoinLoaded(singularAssociationMappingImpl);
        }
        for (FetchImpl fetchImpl : this.fetches.values()) {
            JoinedMapping _mapping = fetchImpl.getMapping();
            if (!(_mapping instanceof SingularAssociationMappingImpl)) {
                _mapping.initialize(managedInstance);
            }
            managedInstance.setJoinLoaded(_mapping);
        }
    }

    public <Y> FetchImpl<X, Y> join(String attributeName, JoinType jt) {
        AbstractMapping<?, ?, ?> _mapping = this.getMapping(attributeName);
        if (!(_mapping instanceof JoinedMapping)) {
            throw new IllegalArgumentException("Cannot dereference attribute " + attributeName);
        }
        FetchImpl fetch = new FetchImpl(this, (JoinedMapping)((Object)_mapping), jt);
        this.joins.add(fetch);
        return fetch;
    }
}

