/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.jpql;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.PluralJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaDeleteImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaUpdateImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.RootImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.AllAnyExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConcatExpression;
import org.batoo.jpa.core.impl.criteria.expression.CountExpression;
import org.batoo.jpa.core.impl.criteria.expression.ExistsExpression;
import org.batoo.jpa.core.impl.criteria.expression.FunctionExpression;
import org.batoo.jpa.core.impl.criteria.expression.MapExpression;
import org.batoo.jpa.core.impl.criteria.expression.NullIfExpression;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.criteria.expression.SimpleConstantExpression;
import org.batoo.jpa.core.impl.criteria.expression.SubstringExpression;
import org.batoo.jpa.core.impl.criteria.expression.TrimExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.join.ListJoinImpl;
import org.batoo.jpa.core.impl.criteria.jpql.Aliased;
import org.batoo.jpa.core.impl.criteria.jpql.Qualified;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.criteria.path.BasicPath;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.jdbc.DateTimeFunctionType;
import org.batoo.jpa.jpql.JpqlLexer;
import org.batoo.jpa.jpql.JpqlParser;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class JpqlQuery {
    private static final BLogger LOG = BLoggerFactory.getLogger(JpqlQuery.class);
    private final MetamodelImpl metamodel;
    private final String qlString;
    private final BaseQuery<?> q;
    private final Map<BaseQuery<?>, Map<String, AbstractFrom<?, ?>>> aliasMap = Maps.newHashMap();
    private HashMap<String, Object> hints;
    private LockModeType lockMode;
    private long lastUsed;

    public JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, CriteriaBuilderImpl cb, NamedQueryMetadata metadata) {
        this(entityManagerFactory, metadata.getQuery(), cb);
        this.lastUsed = Long.MAX_VALUE;
        this.q.getSql();
        this.lockMode = metadata.getLockMode();
        if (metadata.getHints().size() > 0) {
            this.hints = Maps.newHashMap();
            this.hints.putAll(metadata.getHints());
        }
        entityManagerFactory.addNamedQuery(metadata.getName(), this);
    }

    public JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, String qlString) {
        this(entityManagerFactory, qlString, null);
    }

    private JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, String qlString, CriteriaBuilderImpl cb) {
        this.metamodel = entityManagerFactory.getMetamodel();
        this.qlString = qlString;
        this.lastUsed = System.currentTimeMillis();
        if (cb == null) {
            cb = entityManagerFactory.getCriteriaBuilder();
        }
        this.q = this.parse(cb);
    }

    private BaseQueryImpl<?> construct(CriteriaBuilderImpl cb, CommonTree tree) {
        Tree type = tree.getChild(0);
        if (type.getType() == 126) {
            return this.constructSelectQuery(cb, tree);
        }
        if (type.getType() == 39) {
            return this.constructDeleteQuery(cb, tree);
        }
        return this.constructUpdateQuery(cb, tree);
    }

    private CriteriaDeleteImpl constructDeleteQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        CriteriaDeleteImpl<Object> q = new CriteriaDeleteImpl<Object>(this.metamodel, this.qlString);
        Tree deleteDef = tree.getChild(0);
        Tree aliasedDef = deleteDef.getChild(0);
        Aliased aliased = new Aliased(aliasedDef);
        EntityTypeImpl<Object> entity = this.getEntity(aliased.getQualified().toString());
        RootImpl r = (RootImpl)q.from(entity);
        this.putAlias(q, aliasedDef, aliased, r);
        if (deleteDef.getChildCount() == 2) {
            q.where(this.constructJunction(cb, q, deleteDef.getChild(1)));
        }
        return q;
    }

    private void constructFrom(CriteriaBuilderImpl cb, AbstractQuery<?> q, Tree froms) {
        for (int i = 0; i < froms.getChildCount(); ++i) {
            RootImpl r;
            EntityTypeImpl<Object> entity;
            Aliased fromDef;
            Tree from = froms.getChild(i);
            if (from.getType() == 178) {
                fromDef = new Aliased(from.getChild(0));
                entity = this.getEntity(fromDef.getQualified().toString());
                r = (RootImpl)q.from(entity);
                r.alias(fromDef.getAlias());
                this.putAlias((BaseQuery)q, from, fromDef, r);
                this.constructJoins(cb, q, r, from.getChild(1));
                if (from.getChild(from.getChildCount() - 1).getType() != 161) continue;
                for (AssociationMappingImpl<?, ?, ?> association : entity.getAssociations()) {
                    if (association.isEager()) continue;
                    Iterator pathIterator = Splitter.on((String)".").split((CharSequence)association.getPath()).iterator();
                    pathIterator.next();
                    Fetch fetch = null;
                    while (pathIterator.hasNext()) {
                        fetch = fetch == null ? r.fetch((String)pathIterator.next()) : fetch.fetch((String)pathIterator.next());
                    }
                }
                continue;
            }
            if (from.getType() == 175) {
                Aliased aliased = new Aliased(from.getChild(1));
                Join parent = this.getAliased(q, from.getChild(0).getText());
                int depth = 0;
                for (String segment : aliased.getQualified().getSegments()) {
                    if (depth > 0 && parent instanceof PluralJoin) {
                        throw new PersistenceException("Cannot qualify, only embeddable joins within the path allowed, line " + from.getLine() + ":" + from.getCharPositionInLine());
                    }
                    parent = parent.join(segment, JoinType.LEFT);
                    ++depth;
                }
                parent.alias(aliased.getAlias());
                this.putAlias((BaseQueryImpl)q, from.getChild(1), aliased, (AbstractFrom<?, ?>)parent);
                continue;
            }
            fromDef = new Aliased(from);
            entity = this.getEntity(fromDef.getQualified().toString());
            r = (RootImpl)q.from(entity);
            r.alias(fromDef.getAlias());
            this.putAlias((BaseQuery)q, from, fromDef, r);
        }
    }

    private List<Expression<?>> constructGroupBy(CriteriaBuilderImpl cb, AbstractQuery<?> q, Tree groupByDef) {
        ArrayList groupBy = Lists.newArrayList();
        for (int i = 0; i < groupByDef.getChildCount(); ++i) {
            groupBy.add(this.getExpression(cb, q, groupByDef.getChild(i), null));
        }
        return groupBy;
    }

    private void constructJoins(CriteriaBuilderImpl cb, AbstractQuery<?> q, RootImpl<Object> r, Tree joins) {
        for (int i = 0; i < joins.getChildCount(); ++i) {
            Fetch parent;
            Tree join = joins.getChild(i);
            JoinType joinType = JoinType.INNER;
            int joinSpecification = join.getChild(0).getType();
            int offset = 0;
            if (joinSpecification == 70) {
                offset = 1;
                joinType = JoinType.INNER;
            } else if (joinSpecification == 80) {
                offset = 1;
                joinType = JoinType.LEFT;
            }
            if (join.getChildCount() == offset + 3) {
                parent = this.getAliased(q, join.getChild(offset).getText());
                Qualified qualified = new Qualified(join.getChild(offset + 1).getChild(0));
                for (String segment : qualified.getSegments()) {
                    parent = parent.fetch(segment, joinType);
                }
                continue;
            }
            parent = this.getAliased(q, join.getChild(offset).getText());
            Aliased aliased = new Aliased(join.getChild(offset + 1));
            int depth = 0;
            for (String segment : aliased.getQualified().getSegments()) {
                if (depth > 0 && parent instanceof PluralJoin) {
                    throw new PersistenceException("Cannot qualify, only embeddable joins within the path allowed, line " + join.getLine() + ":" + join.getCharPositionInLine());
                }
                parent = parent.join(segment, joinType);
                ++depth;
            }
            parent.alias(aliased.getAlias());
            this.putAlias((BaseQuery)q, join.getChild(1), aliased, (AbstractFrom<?, ?>)parent);
        }
    }

    private AbstractExpression<Boolean> constructJunction(CriteriaBuilderImpl cb, Object q, Tree junctionDef) {
        ArrayList predictions = Lists.newArrayList();
        for (int i = 0; i < junctionDef.getChildCount(); ++i) {
            Tree childDef = junctionDef.getChild(i);
            if (childDef.getType() == 167 || childDef.getType() == 162) {
                predictions.add(this.constructJunction(cb, q, childDef));
                continue;
            }
            predictions.add(this.getExpression(cb, q, childDef, Boolean.class));
        }
        if (predictions.size() == 1) {
            return (AbstractExpression)predictions.get(0);
        }
        if (junctionDef.getType() == 167) {
            return cb.or(predictions.toArray(new Predicate[predictions.size()]));
        }
        Predicate[] predicates = new Predicate[predictions.size()];
        for (int i = 0; i < predictions.size(); ++i) {
            AbstractExpression expression = (AbstractExpression)predictions.get(i);
            predicates[i] = expression instanceof PredicateImpl ? (Predicate)expression : new PredicateImpl((AbstractExpression<Boolean>)expression);
        }
        return cb.and(predicates);
    }

    private void constructOrder(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, List<Selection<?>> selections, Tree orderBy) {
        ArrayList orders = Lists.newArrayList();
        for (int i = 0; i < orderBy.getChildCount(); ++i) {
            Tree orderByItem = orderBy.getChild(i);
            Tree orderItem = orderByItem.getChild(0);
            Order order = null;
            if (orderItem.getType() == 67) {
                String alias = orderItem.getText();
                for (Selection<?> selection : selections) {
                    if (!alias.equals(selection.getAlias())) continue;
                    order = orderByItem.getChildCount() == 2 ? cb.desc((Expression)selection) : cb.asc((Expression)selection);
                    break;
                }
                if (order == null) {
                    throw new PersistenceException("Alias is not bound: " + alias);
                }
            } else {
                order = orderByItem.getChildCount() == 2 ? cb.desc(this.getExpression(cb, q, orderItem, null)) : cb.asc(this.getExpression(cb, q, orderByItem.getChild(0), null));
            }
            orders.add(order);
        }
        q.orderBy(orders);
    }

    private List<Selection<?>> constructSelect(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, Tree selects) {
        ArrayList selections = Lists.newArrayList();
        for (int i = 0; i < selects.getChildCount(); ++i) {
            Tree selectDef = selects.getChild(i);
            AbstractSelection<?> selection = this.constructSingleSelect(cb, q, selectDef.getChild(0));
            if (selectDef.getChildCount() == 2) {
                selection.alias(selectDef.getChild(1).getText());
            }
            selections.add(selection);
        }
        q.updateResultClass(selections);
        return selections;
    }

    private CriteriaQueryImpl constructSelectQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        Tree child;
        CriteriaQueryImpl q = new CriteriaQueryImpl(this.metamodel, this.qlString);
        this.constructFrom(cb, q, tree.getChild(1));
        Tree select = tree.getChild(0);
        List<Selection<?>> selections = this.constructSelect(cb, q, select.getChild(select.getChildCount() - 1));
        if (selections.size() == 1) {
            q.select((Selection)selections.get(0));
        } else {
            q.multiselect(selections);
        }
        if (select.getChild(0).getType() == 41) {
            q.distinct(true);
        }
        int i = 2;
        while ((child = tree.getChild(i)).getType() != -1) {
            if (child.getType() == 154) {
                q.where(this.constructJunction(cb, q, child.getChild(0)));
            }
            if (child.getType() == 164) {
                q.groupBy(this.constructGroupBy(cb, q, child));
            }
            if (child.getType() == 64) {
                q.having((Expression<Boolean>)this.constructJunction(cb, q, child.getChild(0)));
            }
            if (child.getType() == 168) {
                this.constructOrder(cb, q, selections, child);
            }
            ++i;
        }
        return q;
    }

    private AbstractSelection<?> constructSingleSelect(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, Tree selectDef) {
        if (selectDef.getType() == 101) {
            String className = new Qualified(selectDef.getChild(0)).toString();
            ArrayList childSelections = Lists.newArrayList();
            Tree arguments = selectDef.getChild(1);
            for (int i = 0; i < arguments.getChildCount(); ++i) {
                Tree argumentDef = arguments.getChild(i);
                childSelections.add(this.getExpression(cb, q, argumentDef, null));
            }
            try {
                Class<?> clazz = this.metamodel.getEntityManagerFactory().getClassloader().loadClass(className);
                return cb.construct(clazz, childSelections.toArray(new Selection[childSelections.size()]));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Cannot load class: " + className + ", line " + selectDef.getLine() + ":" + selectDef.getCharPositionInLine());
            }
        }
        if (selectDef.getType() == 109) {
            String alias = selectDef.getChild(0).getText();
            return this.getAliased(q, alias);
        }
        return this.getExpression(cb, q, selectDef, null);
    }

    private <T> SubqueryImpl<T> constructSubquery(CriteriaBuilderImpl cb, Object q, Tree subQueryDef, Class<T> javaType) {
        SubqueryImpl<T> s = q instanceof CriteriaQueryImpl ? ((CriteriaQueryImpl)q).subquery(javaType) : (q instanceof CriteriaUpdateImpl ? ((CriteriaUpdateImpl)q).subquery(javaType) : ((CriteriaDeleteImpl)q).subquery(javaType));
        Tree type = subQueryDef.getChild(0);
        if (type.getType() == 126) {
            Tree child;
            this.constructFrom(cb, (AbstractQuery<?>)s, subQueryDef.getChild(1));
            Tree selectDef = subQueryDef.getChild(0).getChild(0);
            s.select(this.getExpression(cb, s, selectDef, javaType));
            if (subQueryDef.getChild(1).getType() == 41) {
                s.distinct(true);
            }
            int i = 2;
            while ((child = subQueryDef.getChild(i)) != null) {
                if (child.getType() == 154) {
                    s.where((Expression<Boolean>)this.constructJunction(cb, s, child.getChild(0)));
                }
                if (child.getType() == 164) {
                    s.groupBy((List)this.constructGroupBy(cb, (AbstractQuery<?>)s, child));
                }
                if (child.getType() == 64) {
                    s.having(this.constructJunction(cb, s, child.getChild(0)));
                }
                ++i;
            }
        }
        return s;
    }

    private CriteriaUpdateImpl<?> constructUpdateQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        CriteriaUpdateImpl<Object> q = new CriteriaUpdateImpl<Object>(this.metamodel, this.qlString);
        Tree updateDef = tree.getChild(0);
        Tree aliasedDef = updateDef.getChild(0);
        Aliased aliased = new Aliased(aliasedDef);
        EntityTypeImpl<Object> entity = this.getEntity(aliased.getQualified().toString());
        RootImpl r = (RootImpl)q.from(entity);
        this.putAlias(q, aliasedDef, aliased, r);
        Tree setDefs = updateDef.getChild(1);
        for (int i = 0; i < setDefs.getChildCount(); ++i) {
            Tree setDef = setDefs.getChild(i);
            BasicPath left = (BasicPath)this.getExpression(cb, q, setDef.getChild(0), null);
            AbstractExpression right = this.getExpression(cb, q, setDef.getChild(1), left.getJavaType());
            q.set(left, right);
        }
        if (updateDef.getChildCount() == 3) {
            q.where(this.constructJunction(cb, q, updateDef.getChild(2)));
        }
        return q;
    }

    public <T> QueryImpl<T> createTypedQuery(EntityManagerImpl entityManager) {
        if (this.lastUsed != Long.MAX_VALUE) {
            this.lastUsed = System.currentTimeMillis();
        }
        QueryImpl typedQuery = new QueryImpl(this.q, entityManager);
        if (this.lockMode != LockModeType.NONE) {
            typedQuery.setLockMode(this.lockMode);
        }
        if (this.hints != null) {
            for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
                typedQuery.setHint(entry.getKey(), entry.getValue());
            }
        }
        return typedQuery;
    }

    private AbstractFrom<?, ?> getAliased(Object q, String alias) {
        AbstractFrom<?, ?> from;
        Map<String, AbstractFrom<?, ?>> aliasMap = this.aliasMap.get(q);
        if (aliasMap != null && (from = aliasMap.get(alias)) != null) {
            return from;
        }
        if (q instanceof Subquery) {
            SubqueryImpl s = (SubqueryImpl)q;
            AbstractFrom<?, ?> aliased = this.getAliased(s.getParent(), alias);
            if (aliased instanceof RootImpl) {
                s.correlate((RootImpl)aliased);
            }
            return aliased;
        }
        throw new PersistenceException("Alias is not bound: " + alias);
    }

    private EntityTypeImpl<Object> getEntity(String entityName) {
        EntityTypeImpl<Object> entity = this.metamodel.entity(entityName);
        if (entity == null) {
            throw new PersistenceException("Type is not managed: " + entityName);
        }
        return entity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <X, C extends Collection<E>, E> AbstractExpression<X> getExpression(CriteriaBuilderImpl cb, Object q, Tree exprDef, Class<X> javaType) {
        if (exprDef.getType() == 52 || exprDef.getType() == 107 || exprDef.getType() == 62 || exprDef.getType() == 61 || exprDef.getType() == 89 || exprDef.getType() == 88 || exprDef.getType() == 13) {
            if (exprDef.getChild(0).getType() == 190 || exprDef.getChild(1).getType() == 190) {
                if (exprDef.getChild(0).getType() == 190) {
                    AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(1), null);
                    SubqueryImpl subqueryImpl = this.constructSubquery(cb, q, exprDef.getChild(0), abstractExpression.getJavaType());
                } else {
                    if (exprDef.getChild(1).getType() != 190) throw new PersistenceException("Both sides of the comparison cannot be sub query, line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                    AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
                    SubqueryImpl subqueryImpl = this.constructSubquery(cb, q, exprDef.getChild(1), abstractExpression.getJavaType());
                }
            } else {
                Tree leftExpr = exprDef.getChild(0);
                Tree rightExpr = exprDef.getChild(1);
                if (leftExpr.getType() == 106 || leftExpr.getType() == 114 || leftExpr.getType() == 121) {
                    AbstractExpression<X> abstractExpression = this.getExpression(cb, q, rightExpr, null);
                    AbstractExpression abstractExpression2 = this.getExpression(cb, q, leftExpr, abstractExpression.getJavaType());
                } else {
                    AbstractExpression<X> abstractExpression = this.getExpression(cb, q, leftExpr, null);
                    AbstractExpression abstractExpression3 = this.getExpression(cb, q, rightExpr, abstractExpression.getJavaType());
                }
            }
            switch (exprDef.getType()) {
                case 52: {
                    void var6_9;
                    void var5_47;
                    return cb.equal((Expression)var5_47, (Expression)var6_9);
                }
                case 107: {
                    void var6_9;
                    void var5_47;
                    return cb.notEqual((Expression)var5_47, (Expression)var6_9);
                }
                case 62: {
                    void var6_9;
                    void var5_47;
                    if (!Comparable.class.isAssignableFrom(var5_47.getJavaType())) return cb.gt((Expression)var5_47, (Expression)var6_9);
                    return cb.greaterThan((Expression)var5_47, (Expression)var6_9);
                }
                case 61: {
                    void var6_9;
                    void var5_47;
                    if (!Comparable.class.isAssignableFrom(var5_47.getJavaType())) return cb.ge((Expression)var5_47, (Expression)var6_9);
                    return cb.greaterThanOrEqualTo((Expression)var5_47, (Expression)var6_9);
                }
                case 89: {
                    void var6_9;
                    void var5_47;
                    if (!Comparable.class.isAssignableFrom(var5_47.getJavaType())) return cb.lt((Expression)var5_47, (Expression)var6_9);
                    return cb.lessThan((Expression)var5_47, (Expression)var6_9);
                }
                case 88: {
                    void var6_9;
                    void var5_47;
                    if (!Comparable.class.isAssignableFrom(var5_47.getJavaType())) return cb.le((Expression)var5_47, (Expression)var6_9);
                    return cb.lessThanOrEqualTo((Expression)var5_47, (Expression)var6_9);
                }
                case 13: {
                    void var6_9;
                    void var5_47;
                    AbstractExpression right2 = this.getExpression(cb, q, exprDef.getChild(2), var5_47.getJavaType());
                    Predicate between = cb.between((Expression)var5_47, (Expression)var6_9, right2);
                    if (exprDef.getChildCount() != 4) return between;
                    return between.not();
                }
            }
        }
        if (exprDef.getType() == 82) {
            AbstractExpression<String> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), String.class);
            AbstractExpression<String> abstractExpression4 = this.getExpression(cb, q, exprDef.getChild(1), String.class);
            if (exprDef.getChildCount() > 2 && exprDef.getChild(2).getType() == 133) {
                AbstractExpression<Character> escape = this.getExpression(cb, q, exprDef.getChild(2), Character.class);
                if (exprDef.getChild(exprDef.getChildCount() - 1).getType() != 102) return cb.like((Expression)abstractExpression, (Expression)abstractExpression4, (Expression)escape);
                return cb.notLike((Expression)abstractExpression, (Expression)abstractExpression4, (Expression)escape);
            }
            if (exprDef.getChild(exprDef.getChildCount() - 1).getType() != 102) return cb.like((Expression)abstractExpression, abstractExpression4);
            return cb.notLike((Expression)abstractExpression, abstractExpression4);
        }
        if (exprDef.getType() == 181) {
            void var5_53;
            void var5_51;
            Object var5_49 = null;
            if (exprDef.getChild(0).getType() != 106 && exprDef.getChild(0).getType() != 114 && exprDef.getChild(0).getType() != 121) {
                AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            }
            ArrayList arrayList = Lists.newArrayList();
            Tree inDefs = exprDef.getChild(1);
            if (inDefs.getType() == 106 || inDefs.getType() == 114 || inDefs.getType() == 121) {
                return var5_51.in(new Expression[]{this.getExpression(cb, q, inDefs, var5_51.getJavaType())});
            }
            if (inDefs.getType() == 67) {
                this.getAliased(q, inDefs.getText());
            }
            if (inDefs.getType() == 190) {
                SubqueryImpl subquery = this.constructSubquery(cb, q, inDefs, var5_51.getJavaType());
                return var5_51.in(new Expression[]{subquery});
            }
            for (int i = 0; i < inDefs.getChildCount(); ++i) {
                arrayList.add(this.getExpression(cb, q, inDefs.getChild(i), var5_51 != null ? var5_51.getJavaType() : null));
            }
            if (var5_51 != null) return var5_53.in((Collection)arrayList);
            AbstractExpression abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), ((AbstractExpression)arrayList.get(0)).getJavaType());
            return var5_53.in((Collection)arrayList);
        }
        if (exprDef.getType() == 185) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (exprDef.getChildCount() != 2) return cb.isNull(abstractExpression);
            return cb.isNotNull(abstractExpression);
        }
        if (exprDef.getType() == 67) {
            return this.getAliased(q, exprDef.getText());
        }
        if (exprDef.getType() == 187) {
            void var5_56;
            AbstractFrom<?, ?> abstractFrom = this.getAliased(q, exprDef.getChild(0).getText());
            Qualified qualified = new Qualified(exprDef.getChild(1));
            Iterator i = qualified.getSegments().iterator();
            while (i.hasNext()) {
                String segment = (String)i.next();
                if (!(var5_56 instanceof ParentPath)) throw new PersistenceException("Cannot dereference: " + segment + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                AbstractExpression abstractExpression = ((ParentPath)var5_56).getExpression(segment);
            }
            return (AbstractExpression)var5_56;
        }
        if (exprDef.getType() == 184) {
            return (AbstractExpression)cb.neg(this.getExpression(cb, q, exprDef.getChild(0), null));
        }
        if (exprDef.getType() == 106) {
            return cb.parameter((Class)javaType, exprDef.getText().substring(1));
        }
        if (exprDef.getType() == 114 || exprDef.getType() == 121) {
            String string = exprDef.getText().substring(1);
            try {
                int n = Integer.parseInt(string);
                AbstractParameterExpressionImpl<?> parameter = null;
                AbstractQuery<?> q2 = q;
                while (q2 instanceof SubqueryImpl) {
                    q2 = ((SubqueryImpl)q2).getParent();
                }
                parameter = q2 instanceof CriteriaQueryImpl ? ((CriteriaQueryImpl)q2).getParameter(n) : (q2 instanceof CriteriaDeleteImpl ? ((CriteriaDeleteImpl)q2).getParameter(n) : ((CriteriaUpdateImpl)q2).getParameter(n));
                if (parameter != null) return parameter;
                return new ParameterExpressionImpl<X>((BaseQueryImpl)q2, this.metamodel.type(javaType), javaType, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PersistenceException("Invalid ordinal query parameter declaration: " + string);
            }
        }
        if (exprDef.getType() == 119 || exprDef.getType() == 98 || exprDef.getType() == 99 || exprDef.getType() == 43) {
            AbstractExpression<Number> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), Number.class);
            AbstractExpression abstractExpression5 = this.getExpression(cb, q, exprDef.getChild(1), abstractExpression.getJavaType());
            switch (exprDef.getType()) {
                case 119: {
                    return (AbstractExpression)cb.sum(abstractExpression, abstractExpression5);
                }
                case 98: {
                    return (AbstractExpression)cb.diff(abstractExpression, abstractExpression5);
                }
                case 99: {
                    return (AbstractExpression)cb.prod(abstractExpression, abstractExpression5);
                }
                case 43: {
                    return (AbstractExpression)cb.quot(abstractExpression, abstractExpression5);
                }
            }
        }
        if (exprDef.getType() == 173) {
            return this.getExpression(cb, q, exprDef, Boolean.class);
        }
        if (exprDef.getType() == 105) {
            return new SimpleConstantExpression<Long>(this.metamodel.createBasicType(Long.class), Long.valueOf(exprDef.getText()));
        }
        if (exprDef.getType() == 133) {
            if (javaType != Character.class) return new SimpleConstantExpression<String>(this.metamodel.type(String.class), exprDef.getText().substring(1, exprDef.getText().length() - 1));
            return new SimpleConstantExpression<Character>(this.metamodel.type(Character.class), Character.valueOf(exprDef.getText().substring(1, 2).toCharArray()[0]));
        }
        if (exprDef.getType() == 146 || exprDef.getType() == 86 || exprDef.getType() == 134) {
            AbstractExpression<String> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            switch (exprDef.getType()) {
                case 146: {
                    return (AbstractExpression)cb.upper(abstractExpression);
                }
                case 86: {
                    return (AbstractExpression)cb.lower(abstractExpression);
                }
                case 134: {
                    AbstractExpression<Integer> abstractExpression6 = this.getExpression(cb, q, exprDef.getChild(1), Integer.class);
                    AbstractExpression<Integer> end = exprDef.getChildCount() == 3 ? this.getExpression(cb, q, exprDef.getChild(2), Integer.class) : null;
                    return new SubstringExpression(abstractExpression, abstractExpression6, end);
                }
            }
        }
        if (exprDef.getType() == 26) {
            void var6_19;
            ArrayList arrayList = Lists.newArrayList();
            boolean bl = false;
            while (var6_19 < exprDef.getChildCount()) {
                arrayList.add(this.getExpression(cb, q, exprDef.getChild((int)var6_19), String.class));
                ++var6_19;
            }
            return new ConcatExpression(arrayList.toArray(new Expression[arrayList.size()]));
        }
        if (exprDef.getType() == 140) {
            void var6_22;
            void var5_68;
            Object var5_64 = null;
            Object var6_20 = null;
            AbstractExpression<String> inner = null;
            int i = 0;
            int type = exprDef.getChild(i).getType();
            if (type == 15) {
                CriteriaBuilder.Trimspec trimspec = CriteriaBuilder.Trimspec.BOTH;
                ++i;
            } else if (type == 79) {
                CriteriaBuilder.Trimspec trimspec = CriteriaBuilder.Trimspec.LEADING;
                ++i;
            } else if (type == 139) {
                CriteriaBuilder.Trimspec trimspec = CriteriaBuilder.Trimspec.TRAILING;
                ++i;
            }
            if (exprDef.getChildCount() > i + 1) {
                AbstractExpression<Character> abstractExpression = this.getExpression(cb, q, exprDef.getChild(i), Character.class);
                inner = this.getExpression(cb, q, exprDef.getChild(i + 1), String.class);
                return new TrimExpression((CriteriaBuilder.Trimspec)var5_68, (Expression<Character>)var6_22, inner);
            } else {
                inner = this.getExpression(cb, q, exprDef.getChild(i), String.class);
            }
            return new TrimExpression((CriteriaBuilder.Trimspec)var5_68, (Expression<Character>)var6_22, inner);
        }
        if (exprDef.getType() == 142 || exprDef.getType() == 177) {
            switch (exprDef.getType()) {
                case 142: {
                    AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
                    return (AbstractExpression)((AbstractPath)abstractExpression).type();
                }
                case 177: {
                    EntityTypeImpl<Object> entityTypeImpl = this.getEntity(exprDef.getChild(0).getText());
                    if (entityTypeImpl.getRootType().getInheritanceType() != null) return new SimpleConstantExpression<String>(null, entityTypeImpl.getDiscriminatorValue());
                    throw new PersistenceException("Entity does not have inheritence: " + entityTypeImpl.getName() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                }
            }
        }
        switch (exprDef.getType()) {
            case 28: {
                return cb.currentDate();
            }
            case 29: {
                return (AbstractExpression)cb.currentTime();
            }
            case 30: {
                return (AbstractExpression)cb.currentTimestamp();
            }
            case 125: {
                return cb.dateTimeExpression(DateTimeFunctionType.SECOND, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 95: {
                return cb.dateTimeExpression(DateTimeFunctionType.MINUTE, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 65: {
                return cb.dateTimeExpression(DateTimeFunctionType.HOUR, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 35: 
            case 36: {
                return cb.dateTimeExpression(DateTimeFunctionType.DAYOFMONTH, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 37: {
                return cb.dateTimeExpression(DateTimeFunctionType.DAYOFWEEK, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 38: {
                return cb.dateTimeExpression(DateTimeFunctionType.DAYOFYEAR, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 97: {
                return cb.dateTimeExpression(DateTimeFunctionType.MONTH, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 152: {
                return cb.dateTimeExpression(DateTimeFunctionType.WEEK, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
            case 158: {
                return cb.dateTimeExpression(DateTimeFunctionType.YEAR, this.getExpression(cb, q, exprDef.getChild(0), Date.class));
            }
        }
        switch (exprDef.getType()) {
            case 5: {
                return (AbstractExpression)cb.abs(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 131: {
                return (AbstractExpression)cb.sqrt(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 96: {
                return (AbstractExpression)cb.mod(this.getExpression(cb, q, exprDef.getChild(0), Integer.class), this.getExpression(cb, q, exprDef.getChild(1), Integer.class));
            }
            case 84: {
                if (exprDef.getChildCount() != 3) return (AbstractExpression)cb.locate(this.getExpression(cb, q, exprDef.getChild(0), String.class), this.getExpression(cb, q, exprDef.getChild(1), String.class));
                return (AbstractExpression)cb.locate(this.getExpression(cb, q, exprDef.getChild(0), String.class), this.getExpression(cb, q, exprDef.getChild(1), String.class), this.getExpression(cb, q, exprDef, Integer.class));
            }
            case 81: {
                return (AbstractExpression)cb.length(this.getExpression(cb, q, exprDef.getChild(0), String.class));
            }
        }
        switch (exprDef.getType()) {
            case 11: {
                return (AbstractExpression)cb.avg(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 135: {
                return (AbstractExpression)cb.sum(this.getExpression(cb, q, exprDef.getChild(0), Long.class));
            }
            case 92: {
                return (AbstractExpression)cb.max(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 94: {
                return (AbstractExpression)cb.min(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
        }
        if (exprDef.getType() == 27) {
            if (exprDef.getChildCount() != 2) return new CountExpression(this.getExpression(cb, q, exprDef.getChild(0), null), false);
            return new CountExpression(this.getExpression(cb, q, exprDef.getChild(1), null), true);
        }
        if (exprDef.getType() == 172) {
            switch (exprDef.getChild(0).getType()) {
                case 6: {
                    return new AllAnyExpression<X>(true, this.constructSubquery(cb, q, exprDef.getChild(1), javaType));
                }
                case 8: 
                case 130: {
                    return new AllAnyExpression<X>(false, this.constructSubquery(cb, q, exprDef.getChild(1), javaType));
                }
            }
        }
        if (exprDef.getType() == 50) {
            return new ExistsExpression(this.constructSubquery(cb, q, exprDef.getChild(0), javaType));
        }
        if (exprDef.getType() == 102) {
            Tree tree = exprDef.getChild(0);
            AbstractExpression<Boolean> abstractExpression = tree.getType() == 167 ? this.constructJunction(cb, q, tree) : this.getExpression(cb, q, tree, Boolean.class);
            return new PredicateImpl(true, Predicate.BooleanOperator.AND, abstractExpression);
        }
        if (exprDef.getType() == 179) {
            void var6_26;
            CriteriaBuilder.Case case_ = cb.selectCase();
            boolean bl = false;
            while (var6_26 < exprDef.getChildCount()) {
                Tree caseDef = exprDef.getChild((int)var6_26);
                if (caseDef.getType() == 153) {
                    case_.when((Expression<Boolean>)this.constructJunction(cb, q, caseDef.getChild(0)), this.getExpression(cb, q, caseDef.getChild(1), null));
                } else {
                    case_.otherwise(this.getExpression(cb, q, caseDef, null));
                }
                ++var6_26;
            }
            return case_;
        }
        if (exprDef.getType() == 19) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            CriteriaBuilder.SimpleCase simpleCase = cb.selectCase(abstractExpression);
            int i = 1;
            while (i < exprDef.getChildCount()) {
                Tree caseDef = exprDef.getChild(i);
                if (caseDef.getType() == 153) {
                    AbstractExpression<X> condition;
                    AbstractExpression<X> result = this.getExpression(cb, q, caseDef.getChild(1), null);
                    if (exprDef.getChild(0).getType() == 142) {
                        EntityTypeImpl<Object> entity = this.getEntity(caseDef.getChild(0).getText());
                        if (entity.getRootType().getInheritanceType() == null) {
                            throw new PersistenceException("Entity does not have inheritence: " + entity.getName() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                        }
                        condition = new SimpleConstantExpression<String>(null, entity.getDiscriminatorValue());
                    } else {
                        condition = this.getExpression(cb, q, caseDef.getChild(0), null);
                    }
                    simpleCase.when(condition, result);
                } else {
                    simpleCase.otherwise(this.getExpression(cb, q, caseDef, null));
                }
                ++i;
            }
            return simpleCase;
        }
        if (exprDef.getType() == 104) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            AbstractExpression<X> abstractExpression7 = this.getExpression(cb, q, exprDef.getChild(1), null);
            return new NullIfExpression<X>(abstractExpression, abstractExpression7);
        }
        if (exprDef.getType() == 174) {
            void var6_30;
            CriteriaBuilder.Coalesce coalesce = cb.coalesce();
            boolean bl = false;
            while (var6_30 < exprDef.getChildCount()) {
                coalesce.value(this.getExpression(cb, q, exprDef.getChild((int)var6_30), javaType));
                ++var6_30;
            }
            return coalesce;
        }
        if (exprDef.getType() == 58) {
            ArrayList arrayList = Lists.newArrayList();
            String string = exprDef.getChild(0).getText();
            for (int i = 1; i < exprDef.getChildCount(); ++i) {
                arrayList.add(this.getExpression(cb, q, exprDef.getChild(i), null));
            }
            return new FunctionExpression<X>(javaType != null ? javaType : Object.class, string, arrayList.toArray(new Expression[arrayList.size()]));
        }
        if (exprDef.getType() == 69) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (!(abstractExpression instanceof ListJoinImpl)) throw new PersistenceException("Reference is not a list join, line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            return (AbstractExpression)((ListJoinImpl)abstractExpression).index();
        }
        if (exprDef.getType() == 176) {
            void var5_79;
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (abstractExpression instanceof MapExpression) {
                CollectionExpression collectionExpression = ((MapExpression)abstractExpression).values();
            }
            if (!(var5_79 instanceof CollectionExpression)) {
                throw new PersistenceException("Reference is not a collection, line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            if (exprDef.getChildCount() != 2) return (AbstractExpression)cb.isEmpty(var5_79);
            return (AbstractExpression)cb.isNotEmpty(var5_79);
        }
        if (exprDef.getType() == 183) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(1), null);
            if (!(abstractExpression instanceof CollectionExpression)) {
                throw new PersistenceException("Member of expression must evaluate to a collection expression, " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            CollectionExpression collectionExpression = (CollectionExpression)abstractExpression;
            PluralAttributeImpl attribute = (PluralAttributeImpl)collectionExpression.getMapping().getAttribute();
            AbstractExpression elem = this.getExpression(cb, q, exprDef.getChild(0), attribute.getElementType().getJavaType());
            if (exprDef.getChildCount() != 3) return (AbstractExpression)cb.isMember(elem, collectionExpression);
            return (AbstractExpression)cb.isNotMember(elem, collectionExpression);
        }
        if (exprDef.getType() == 129) {
            AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (!(abstractExpression instanceof CollectionExpression)) {
                throw new PersistenceException("Member of expression must evaluate to a collection expression, " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            CollectionExpression collectionExpression = (CollectionExpression)abstractExpression;
            return (AbstractExpression)cb.size(collectionExpression);
        }
        if (exprDef.getType() != 20) throw new PersistenceException("Unhandled expression: " + exprDef.toStringTree() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
        AbstractExpression<X> abstractExpression = this.getExpression(cb, q, exprDef.getChild(0), null);
        Object var6_34 = null;
        switch (exprDef.getChild(1).getType()) {
            case 17: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            case 128: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            case 71: 
            case 72: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            case 85: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            case 56: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            case 42: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
            default: {
                void var6_42;
                return cb.cast(abstractExpression, var6_42);
            }
        }
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public String getQueryString() {
        return this.qlString;
    }

    private BaseQueryImpl<?> parse(CriteriaBuilderImpl cb) {
        CommonTree tree = this.parse(this.qlString);
        LOG.debug("Parsed query successfully {0}", LOG.lazyBoxed(this.qlString, new Object[]{tree.toStringTree()}));
        return this.construct(cb, tree);
    }

    private CommonTree parse(String query) {
        try {
            JpqlLexer lexer = new JpqlLexer((CharStream)new ANTLRStringStream(query));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            JpqlParser parser = new JpqlParser((TokenStream)tokenStream);
            JpqlParser.ql_statement_return ql_statement = parser.ql_statement();
            CommonTree tree = (CommonTree)ql_statement.getTree();
            List<String> errors = parser.getErrors();
            if (errors.size() > 0) {
                String errorMsg = Joiner.on((String)"\n\t").join(errors);
                LOG.error("Cannot parse query: {0}", LOG.boxed(query, new Object[]{"\n\t" + errorMsg, "\n\n" + tree.toStringTree() + "\n"}));
                throw new PersistenceException("Cannot parse the query:\n " + errorMsg + ".\n" + query);
            }
            return tree;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot parse the query:\n " + e.getMessage() + ".\n" + query, (Throwable)e);
        }
    }

    private void putAlias(BaseQuery<?> q, Tree aliasedDef, Aliased aliased, AbstractFrom<?, ?> from) {
        String alias;
        HashMap aliasMap = this.aliasMap.get(q);
        if (aliasMap == null) {
            aliasMap = Maps.newHashMap();
            this.aliasMap.put(q, aliasMap);
        }
        if ((alias = aliased.getAlias()) == null) {
            alias = aliased.getQualified().getSegments().getLast();
            from.alias(alias);
        }
        if (aliasMap.containsKey(alias)) {
            throw new PersistenceException("Alias already exists: " + alias + ", line " + aliasedDef.getLine() + ":" + aliasedDef.getCharPositionInLine());
        }
        aliasMap.put(aliased.getAlias(), from);
    }
}

