/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.jpql.JpqlQuery;
import org.batoo.jpa.core.impl.deployment.DeploymentManager;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class NamedQueriesManager
extends DeploymentManager<NamedQueryMetadata> {
    private static final BLogger LOG = BLoggerFactory.getLogger(NamedQueriesManager.class);
    private final CriteriaBuilderImpl criteriaBuilder;

    public static void perform(MetamodelImpl metamodel, CriteriaBuilderImpl criteriaBuilder) throws BatooException {
        new NamedQueriesManager(metamodel, criteriaBuilder).perform();
    }

    private NamedQueriesManager(MetamodelImpl metamodel, CriteriaBuilderImpl criteriaBuilder) {
        super(LOG, "Query Manager", metamodel, DeploymentManager.Context.NAMED_QUERIES);
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public Void perform(NamedQueryMetadata namedQuery) throws BatooException {
        LOG.debug("Compiling named query {0}...", namedQuery.getName());
        new JpqlQuery(this.getMetamodel().getEntityManagerFactory(), this.criteriaBuilder, namedQuery);
        LOG.debug("Successfully compiled named query {0}.", namedQuery.getName());
        return null;
    }
}

