/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.instance;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.LockModeType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.SingularMapping;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;

public class ManagedInstance<X> {
    private static final BLogger LOG = BLoggerFactory.getLogger(ManagedInstance.class);
    private final EntityTypeImpl<X> type;
    private final SessionImpl session;
    private final X instance;
    private Status status;
    private Status oldStatus;
    private LockModeType lockMode;
    private final HashMap<AbstractMapping<?, ?, ?>, Object> snapshot = Maps.newHashMap();
    private final HashSet<String> joinsLoaded;
    private final ArrayList<PluralMappingEx<?, ?, ?>> collectionsChanged;
    private boolean loading;
    private boolean loadingFromCache;
    private boolean refreshing;
    private boolean changed;
    private boolean hasInitialId;
    private ManagedId<? super X> id;
    private int h;
    private boolean prePersistCalled;
    private boolean preRemoveCalled;
    private Object oldVersion;
    public static ThreadLocal<LockModeType> LOCK_CONTEXT = new ThreadLocal();

    public ManagedInstance(EntityTypeImpl<X> type, SessionImpl session, X instance) {
        this.type = type;
        this.session = session;
        this.instance = instance;
        this.lockMode = LOCK_CONTEXT.get();
        this.collectionsChanged = Lists.newArrayList();
        this.joinsLoaded = Sets.newHashSet();
        this.status = Status.MANAGED;
    }

    public ManagedInstance(EntityTypeImpl<X> type, SessionImpl session, X instance, ManagedId<? super X> id) {
        this(type, session, instance);
        type.setId(session, instance, id.getId());
        this.id = id;
    }

    public void cascadeDetach(EntityManagerImpl entityManager) {
        this.status = Status.DETACHED;
        LOG.debug("Cascading detach on {0}", this);
        for (AssociationMappingImpl<?, ?, ?> association : this.type.getAssociationsDetachable()) {
            AssociationMappingImpl mapping;
            if (association instanceof PluralAssociationMappingImpl) {
                mapping = (PluralAssociationMappingImpl)association;
                Collection collection = ((PluralAssociationMappingImpl)mapping).getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP ? ((Map)mapping.get(this.instance)).values() : (Collection)mapping.get(this.instance);
                if (collection instanceof List) {
                    List list = (List)collection;
                    for (int i = 0; i < list.size(); ++i) {
                        entityManager.detach(list.get(i));
                    }
                    continue;
                }
                for (Object element : collection) {
                    entityManager.detach(element);
                }
                continue;
            }
            mapping = (SingularAssociationMappingImpl)association;
            Object associate = mapping.get(this.instance);
            entityManager.detach(associate);
        }
    }

    public boolean cascadePersist(EntityManagerImpl entityManager, ArrayList<Object> processed, LinkedList<ManagedInstance<?>> instances) {
        LOG.debug("Cascading persist on {0}", this);
        boolean requiresFlush = false;
        block4: for (AssociationMappingImpl<?, ?, ?> association : this.type.getAssociationsPersistable()) {
            AssociationMappingImpl mapping;
            if (association instanceof PluralAssociationMappingImpl) {
                mapping = (PluralAssociationMappingImpl)association;
                switch (((PluralAssociationMappingImpl)mapping).getAttribute().getCollectionType()) {
                    case MAP: {
                        Map map = (Map)mapping.get(this.instance);
                        for (Object element : map.values()) {
                            requiresFlush |= entityManager.persistImpl(element, processed, instances);
                        }
                        continue block4;
                    }
                    case LIST: {
                        List list = (List)mapping.get(this.instance);
                        for (int i = 0; i < list.size(); ++i) {
                            requiresFlush |= entityManager.persistImpl(list.get(i), processed, instances);
                        }
                        continue block4;
                    }
                    default: {
                        Collection collection = (Collection)mapping.get(this.instance);
                        if (collection instanceof List) {
                            List castedList = (List)collection;
                            for (int i = 0; i < castedList.size(); ++i) {
                                requiresFlush |= entityManager.persistImpl(castedList.get(i), processed, instances);
                            }
                            continue block4;
                        }
                        for (Object element : collection) {
                            requiresFlush |= entityManager.persistImpl(element, processed, instances);
                        }
                        continue block4;
                    }
                }
            }
            mapping = (SingularAssociationMappingImpl)association;
            Object associate = mapping.get(this.instance);
            if (associate == null) continue;
            requiresFlush |= entityManager.persistImpl(associate, processed, instances);
        }
        return requiresFlush;
    }

    public void cascadeRemove(EntityManagerImpl entityManager, ArrayList<Object> processed, LinkedList<ManagedInstance<?>> instances) {
        LOG.debug("Cascading remove on {0}", this);
        for (AssociationMappingImpl<?, ?, ?> association : this.type.getAssociationsRemovable()) {
            AssociationMappingImpl mapping;
            if (association instanceof PluralAssociationMappingImpl) {
                mapping = (PluralAssociationMappingImpl)association;
                Collection collection = ((PluralAssociationMappingImpl)mapping).getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP ? ((Map)mapping.get(this.instance)).values() : (Collection)mapping.get(this.instance);
                if (collection instanceof List) {
                    List list = (List)collection;
                    for (int i = 0; i < list.size(); ++i) {
                        entityManager.removeImpl(list.get(i), processed, instances);
                    }
                    continue;
                }
                for (Object element : collection) {
                    entityManager.removeImpl(element, processed, instances);
                }
                continue;
            }
            mapping = (SingularAssociationMappingImpl)association;
            Object associate = mapping.get(this.instance);
            if (associate == null) continue;
            entityManager.removeImpl(associate, processed, instances);
        }
    }

    public void changed() {
        if (!this.changed && this.collectionsChanged.size() == 0) {
            this.session.setChanged(this);
        }
        if (!this.changed) {
            this.snapshot();
            this.changed = true;
        }
    }

    public void checkTransients() {
        for (AssociationMappingImpl<?, ?, ?> association : this.type.getAssociationsNotPersistable()) {
            association.checkTransient(this);
        }
    }

    public void checkUpdated() {
        if (this.snapshot.size() == 0 || this.changed) {
            return;
        }
        if (this.checkUpdatedImpl()) {
            this.changed();
        }
    }

    private boolean checkUpdatedImpl() {
        for (AbstractMapping<?, ?, ?> mapping : this.type.getMappingsSingular()) {
            Object newValue = mapping.get(this.instance);
            Object oldValue = this.snapshot.get(mapping);
            if (!(mapping.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC ? !ObjectUtils.equals((Object)oldValue, newValue) : oldValue != newValue)) continue;
            return true;
        }
        return false;
    }

    public void enhanceCollections() {
        for (PluralMappingEx<?, ?, ?> collection : this.type.getMappingsPlural()) {
            collection.enhance(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ManagedInstance other = (ManagedInstance)obj;
        return this.getId().equals(other.getId());
    }

    public boolean fillIdValues() {
        LOG.debug("Auto generating id values for {0}", this);
        this.hasInitialId = this.fillValuesImpl();
        return this.hasInitialId;
    }

    private boolean fillValuesImpl() {
        EntityTypeImpl<X> _type = this.type;
        if (_type.hasSingleIdAttribute()) {
            return this.type.getRootType().getIdMapping().fillValue(_type.getRootType(), this, this.instance);
        }
        for (Pair<SingularMapping<?, ?>, AbstractAccessor> mapping : _type.getIdMappings()) {
            if (((SingularMappingEx)mapping.getFirst()).fillValue(_type.getRootType(), this, this.instance)) continue;
            return false;
        }
        return true;
    }

    public void fireCallbacks(EntityListenerMetadata.EntityListenerType type) {
        EntityListenerMetadata.EntityListenerType typeToFire = type;
        if (type == EntityListenerMetadata.EntityListenerType.PRE_UPDATE && this.status == Status.NEW) {
            typeToFire = EntityListenerMetadata.EntityListenerType.PRE_PERSIST;
        }
        if (type == EntityListenerMetadata.EntityListenerType.POST_UPDATE && this.oldStatus == Status.NEW) {
            typeToFire = EntityListenerMetadata.EntityListenerType.POST_PERSIST;
        }
        if (typeToFire == EntityListenerMetadata.EntityListenerType.PRE_PERSIST) {
            if (!this.prePersistCalled) {
                this.prePersistCalled = true;
                this.type.fireCallbacks(this.instance, typeToFire);
            }
        } else if (typeToFire == EntityListenerMetadata.EntityListenerType.PRE_REMOVE) {
            if (!this.preRemoveCalled) {
                this.preRemoveCalled = true;
                this.type.fireCallbacks(this.instance, typeToFire);
            }
        } else {
            this.type.fireCallbacks(this.instance, typeToFire);
        }
    }

    public void flushAssociations(Connection connection, boolean removals, boolean force) throws SQLException {
        if (!removals || this.status != Status.NEW) {
            LOG.debug("Flushing associations for instance {0}", this);
            for (JoinedMapping<?, ?, ?> collection : this.type.getMappingsJoined()) {
                collection.flush(connection, this, removals, force);
            }
        }
    }

    public ManagedId<? super X> getId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = this.type.getId(this.instance);
        return this.id;
    }

    public X getInstance() {
        return this.instance;
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public Object getOldVersion() {
        return this.oldVersion;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public Status getStatus() {
        return this.status;
    }

    public EntityTypeImpl<X> getType() {
        return this.type;
    }

    public void handleAdditions(EntityManagerImpl entityManager) {
        LOG.debug("Inspecting additions for instance {0}", this);
        for (int i = 0; i < this.collectionsChanged.size(); ++i) {
            PluralMappingEx<?, ?, ?> collection = this.collectionsChanged.get(i);
            if (!(collection instanceof PluralAssociationMappingImpl)) continue;
            ((PluralAssociationMappingImpl)collection).persistAdditions(entityManager, this);
        }
    }

    public void handleOrphans(EntityManagerImpl entityManager) {
        LOG.debug("Inspecting orphans for instance {0}", this);
        for (int i = 0; i < this.collectionsChanged.size(); ++i) {
            PluralMappingEx<?, ?, ?> collection = this.collectionsChanged.get(i);
            if (!collection.isAssociation()) continue;
            ((PluralAssociationMappingImpl)collection).removeOrphans(entityManager, this);
        }
    }

    public int hashCode() {
        if (this.h != 0) {
            return this.h;
        }
        ManagedId<X> id = this.getId();
        int prime = 31;
        boolean result = true;
        this.h = 31 + this.type.getRootType().getName().hashCode();
        this.h = 31 + ((Object)id).hashCode();
        return this.h;
    }

    public boolean hasInitialId() {
        return this.hasInitialId;
    }

    public boolean hasSelfUpdate() {
        if (!this.changed && this.snapshot.size() == 0) {
            return false;
        }
        if (this.collectionsChanged.size() > 0) {
            return true;
        }
        return this.checkUpdatedImpl();
    }

    public void incrementVersion(Connection connection, boolean commit) throws SQLException {
        if (!this.type.getRootType().hasVersionAttribute()) {
            return;
        }
        EntityTypeImpl<X> rootType = this.type.getRootType();
        BasicAttribute version = rootType.getVersionAttribute();
        if (this.oldVersion == null) {
            switch (this.type.getVersionType()) {
                case SHORT: {
                    short shortValue = ((Number)version.get(this.instance)).shortValue();
                    this.oldVersion = shortValue;
                    version.set(this.instance, shortValue + 1);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, shortValue);
                    break;
                }
                case SHORT_OBJECT: {
                    Short shortObjValue = version.get(this.instance) == null ? (short)0 : Short.valueOf(((Number)version.get(this.instance)).shortValue());
                    this.oldVersion = shortObjValue;
                    version.set(this.instance, shortObjValue + 1);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, shortObjValue);
                    break;
                }
                case INT: {
                    int intValue = ((Number)version.get(this.instance)).intValue();
                    this.oldVersion = intValue;
                    version.set(this.instance, intValue + 1);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, intValue);
                    break;
                }
                case INT_OBJECT: {
                    Integer intObjValue = version.get(this.instance) == null ? 0 : Integer.valueOf(((Number)version.get(this.instance)).intValue());
                    this.oldVersion = intObjValue;
                    version.set(this.instance, intObjValue + 1);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, intObjValue);
                    break;
                }
                case LONG: {
                    long longValue = ((Number)version.get(this.instance)).longValue();
                    this.oldVersion = longValue;
                    version.set(this.instance, longValue + 1L);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, longValue);
                    break;
                }
                case LONG_OBJECT: {
                    Long longObjValue = version.get(this.instance) == null ? 0L : Long.valueOf(((Number)version.get(this.instance)).longValue());
                    this.oldVersion = longObjValue;
                    version.set(this.instance, longObjValue + 1L);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, longObjValue);
                    break;
                }
                case TIMESTAMP: {
                    Timestamp value = new Timestamp(System.currentTimeMillis());
                    this.oldVersion = version.get(this.instance);
                    version.set(this.instance, value);
                    LOG.debug("Version upgraded instance: {0} - {1}", this, value);
                }
            }
        }
        if (commit) {
            Object newVersion = version.get(this.instance);
            rootType.performVersionUpdate(connection, this, this.oldVersion, newVersion);
            LOG.debug("Version committed instance: {0} - {1} -> {2}", this, this.oldVersion, newVersion);
            this.oldVersion = null;
        } else {
            this.changed();
        }
    }

    public boolean isJoinLoaded(String attributeName) {
        Mapping mapping = this.type.getRootMapping().getMapping(attributeName);
        if (mapping instanceof BasicMappingImpl || mapping instanceof EmbeddedMappingImpl) {
            return true;
        }
        if (((AssociationMappingImpl)mapping).isEager()) {
            return true;
        }
        return this.joinsLoaded.contains(((AbstractMapping)mapping).getPath());
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean isLoadingFromCache() {
        return this.loadingFromCache;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void mergeWith(EntityManagerImpl entityManager, X entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, LinkedList<ManagedInstance<?>> instances) {
        this.snapshot();
        for (BasicMappingImpl<?, ?> basicMappingImpl : this.type.getBasicMappings()) {
            basicMappingImpl.set(this.instance, basicMappingImpl.get(entity));
        }
        for (AbstractMapping abstractMapping : this.type.getAssociations()) {
            ((AssociationMappingImpl)abstractMapping).mergeWith(entityManager, this, entity, requiresFlush, processed, instances);
        }
        this.checkUpdated();
    }

    public void processJoinedMappings() {
        LOG.debug("Post processing associations for instance {0}", this);
        HashSet<String> _joinsLoaded = this.joinsLoaded;
        PluralMappingEx<?, ?, ?>[] arr$ = this.type.getMappingsPlural();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HashSet<String> joinsLoaded2 = _joinsLoaded;
            PluralMappingEx<?, ?, ?> mapping = arr$[i$];
            if (joinsLoaded2.contains(mapping.getPath())) continue;
            if (mapping.isEager()) {
                mapping.load(this);
                continue;
            }
            mapping.setLazy(this);
        }
        X _instance = this.instance;
        EntityManagerImpl entityManager = this.session.getEntityManager();
        for (SingularAssociationMappingImpl<?, ?> mapping : this.type.getAssociationsSingular()) {
            EnhancedInstance enhancedInstance;
            if (!mapping.isEager()) continue;
            if (!_joinsLoaded.contains(mapping.getPath())) {
                mapping.initialize(this);
                continue;
            }
            Object associate = mapping.get(_instance);
            if (!(associate instanceof EnhancedInstance) || (enhancedInstance = (EnhancedInstance)associate).__enhanced__$$__isInitialized()) continue;
            ManagedInstance<?> associateManagedInstance = enhancedInstance.__enhanced__$$__getManagedInstance();
            entityManager.find(associateManagedInstance.getType().getJavaType(), associateManagedInstance.getId().getId());
        }
    }

    public void refresh(EntityManagerImpl entityManager, Connection connection, LockModeType lockMode, Set<Object> processed) {
        LOG.debug("Refeshing instance {0}", this);
        this.type.performRefresh(connection, this, lockMode, processed);
        for (AssociationMappingImpl<?, ?, ?> association : this.type.getAssociations()) {
            association.refresh(this, processed);
        }
    }

    public void reset() {
        LOG.trace("Reset instance {0}", this);
        this.collectionsChanged.clear();
        this.changed = false;
        this.snapshot.clear();
        this.snapshot();
    }

    public void setChanged(PluralMappingEx<?, ?, ?> association) {
        if (this.collectionsChanged.size() == 0 && !this.changed) {
            this.session.setChanged(this);
        }
        this.collectionsChanged.add(association);
    }

    public void setJoinLoaded(JoinedMapping<?, ?, ?> mapping) {
        this.joinsLoaded.add(mapping.getPath());
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public void setLoadingFromCache(boolean loadingFromCache) {
        this.loadingFromCache = loadingFromCache;
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    public void setStatus(Status status) {
        this.oldStatus = this.status;
        if (status != this.status) {
            LOG.debug("Instance status changing for {0}: {1} -> {2}", new Object[]{this, this.status, status});
            this.status = status;
        }
    }

    private void snapshot() {
        LOG.trace("Snapshot generated for instance {0}", this);
        if (this.snapshot.size() == 0) {
            for (AbstractMapping<?, ?, ?> mapping : this.type.getMappingsSingular()) {
                this.snapshot.put(mapping, mapping.get(this.instance));
            }
        }
    }

    public void sortLists() {
        for (PluralMappingEx<?, ?, ?> mapping : this.type.getMappingsPluralSorted()) {
            mapping.sortList(this.instance);
        }
    }

    public String toString() {
        return "ManagedInstance [session=" + this.session + ", type=" + this.type.getName() + ", status=" + (Object)((Object)this.status) + ", id=" + (this.id != null ? this.id.getId() : null) + "]";
    }
}

