/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.persistence.PersistenceException;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;

public class Callback {
    private final EntityListenerMetadata.EntityListenerType listenerType;
    private final CallbackType callbackType;
    private Method method;
    private Object instance;

    public Callback(final AbstractLocator locator, final Class<?> clazz, final String name, EntityListenerMetadata.EntityListenerType listenerType, final CallbackType callbackType) {
        this.callbackType = callbackType;
        this.listenerType = listenerType;
        this.method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    if (callbackType == CallbackType.CALLBACK) {
                        return clazz.getMethod(name, new Class[0]);
                    }
                    return clazz.getMethod(name, Object.class);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to map callback " + clazz.getName() + "." + name, locator);
                }
            }
        });
        try {
            this.instance = callbackType == CallbackType.CALLBACK ? null : clazz.newInstance();
        }
        catch (Exception e) {
            throw new MappingException("Unable to map callback " + clazz.getName() + "." + name, locator);
        }
    }

    public void fire(Object instance) {
        try {
            if (this.callbackType == CallbackType.CALLBACK) {
                this.method.invoke(instance, new Object[0]);
            } else {
                this.method.invoke(this.instance, instance);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Error while invoking callback or listener", (Throwable)e);
        }
    }

    public CallbackType getCallbackType() {
        return this.callbackType;
    }

    public EntityListenerMetadata.EntityListenerType getListenerType() {
        return this.listenerType;
    }

    public static enum CallbackType {
        LISTENER,
        CALLBACK;

    }
}

