/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.sql.DataSource;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaDeleteImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaUpdateImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.jpql.JpqlQuery;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityTransactionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMappingImpl;
import org.batoo.jpa.core.impl.nativeQuery.NativeQuery;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;

public class EntityManagerImpl
implements EntityManager {
    private static final BLogger LOG = BLoggerFactory.getLogger(EntityManagerImpl.class);
    private final EntityManagerFactoryImpl emf;
    private final MetamodelImpl metamodel;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final DataSource datasource;
    private final JdbcAdaptor jdbcAdaptor;
    private final Map<String, Object> properties;
    private final SessionImpl session;
    private boolean open;
    private Connection connection;
    private EntityTransactionImpl transaction;
    private boolean rollbackOnly;
    private FlushModeType flushMode;
    private boolean inFlush;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, MetamodelImpl metamodel, DataSource datasource, Map<String, Object> properties, JdbcAdaptor jdbcAdaptor) {
        this.emf = entityManagerFactory;
        this.metamodel = metamodel;
        this.datasource = datasource;
        this.jdbcAdaptor = jdbcAdaptor;
        this.session = new SessionImpl(this, metamodel);
        this.criteriaBuilder = this.emf.getCriteriaBuilder();
        this.properties = properties;
        this.flushMode = FlushModeType.AUTO;
        this.open = true;
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager has been previously closed");
        }
    }

    public void assertTransaction() {
        this.assertOpen();
        if (this.transaction == null || !this.transaction.isActive()) {
            throw new TransactionRequiredException("No active transaction");
        }
    }

    public <T> void cascadeMerge(EntityTypeImpl<T> type, T entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, LinkedList<ManagedInstance<?>> instances) {
        for (AssociationMappingImpl<?, ?, ?> association : type.getAssociations()) {
            if (association instanceof PluralAssociationMappingImpl) {
                Collection children;
                PluralAssociationMappingImpl mapping = (PluralAssociationMappingImpl)association;
                if (mapping.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP) {
                    Map map = (Map)mapping.get(entity);
                    children = map.values();
                } else {
                    children = (Collection)mapping.get(entity);
                }
                if (children == null) continue;
                if (children instanceof List) {
                    List childrenList = (List)children;
                    for (int i = 0; i < childrenList.size(); ++i) {
                        this.mergeImpl(childrenList.get(i), requiresFlush, processed, instances, association.cascadesMerge());
                    }
                    continue;
                }
                for (Object child : children) {
                    this.mergeImpl(child, requiresFlush, processed, instances, association.cascadesMerge());
                }
                continue;
            }
            Object associate = association.get(entity);
            this.mergeImpl(associate, requiresFlush, processed, instances, association.cascadesMerge());
        }
    }

    public void clear() {
        this.assertOpen();
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback();
            LOG.warn("Session cleared with active and transaction. Updated persistent types will become stale...");
        }
        this.session.clear();
    }

    public void clearTransaction() {
        this.transaction = null;
        this.detachAllIfNotTransactionScoped();
    }

    public void close() {
        this.assertOpen();
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback();
            LOG.warn("Entity manager closed with an active transaction. Updated persistent types will become stale...");
        }
        this.closeConnection();
        this.open = false;
    }

    protected void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    public void closeConnectionIfNecessary() {
    }

    public boolean contains(Object entity) {
        this.assertOpen();
        ManagedInstance<Object> instance = this.session.get(entity);
        return instance != null && instance.getInstance() == entity;
    }

    public Query createNamedQuery(String name) {
        return this.createNamedQuery(name, Object.class);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        JpqlQuery query = this.emf.getNamedQuery(name);
        if (query == null) {
            throw new IllegalArgumentException("No named query found with the name: " + name);
        }
        return query.createTypedQuery(this);
    }

    public Query createNativeQuery(String sqlString) {
        return new NativeQuery(this, sqlString);
    }

    public Query createNativeQuery(String sqlString, Class<?> resultClass) {
        return new NativeQuery(this, sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        throw new NotImplementedException("Native queries are not yet implemented");
    }

    public Query createQuery(CriteriaDeleteImpl<?> deleteQuery) {
        return new QueryImpl(deleteQuery, this);
    }

    public <T> QueryImpl<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new QueryImpl((CriteriaQueryImpl)criteriaQuery, this);
    }

    public Query createQuery(CriteriaUpdateImpl<?> updateQuery) {
        return new QueryImpl(updateQuery, this);
    }

    public Query createQuery(String qlString) {
        return this.emf.getJpqlQuery(qlString).createTypedQuery(this);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.emf.getJpqlQuery(qlString).createTypedQuery(this);
    }

    public void detach(Object entity) {
        this.assertOpen();
        ManagedInstance<?> instance = this.session.remove(entity);
        if (instance != null) {
            instance.cascadeDetach(this);
        }
    }

    public void detachAllIfNotTransactionScoped() {
        if (this.transaction == null || !this.transaction.isActive()) {
            this.clear();
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return this.find(entityClass, primaryKey, lockMode, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        if (primaryKey == null) {
            throw new NullPointerException();
        }
        EntityType type = this.metamodel.entity(entityClass);
        return this.findImpl(primaryKey, lockMode, properties, (EntityTypeImpl<T>)type);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findImpl(Object primaryKey, LockModeType lockMode, Map<String, Object> properties, EntityTypeImpl<T> type) {
        this.session.setLoadTracker();
        try {
            Object enhanced2;
            ManagedInstance<ManagedId<T>> instance = this.session.get(new ManagedId<T>(primaryKey, type));
            if (instance != null) {
                if (instance.getInstance() instanceof EnhancedInstance) {
                    enhanced2 = (EnhancedInstance)((Object)instance.getInstance());
                    if (enhanced2.__enhanced__$$__isInitialized()) {
                        this.lock(instance, lockMode, properties);
                        ManagedId<T> managedId = instance.getInstance();
                        return (T)managedId;
                    }
                } else {
                    if (instance.getStatus() == Status.REMOVED) {
                        T enhanced2 = null;
                        return enhanced2;
                    }
                    this.lock(instance, lockMode, properties);
                    ManagedId<T> enhanced2 = instance.getInstance();
                    return (T)enhanced2;
                }
            }
            enhanced2 = type.performSelect(this, primaryKey, lockMode);
            return (T)enhanced2;
        }
        finally {
            this.session.releaseLoadTracker();
        }
    }

    public void flush() {
        if (this.inFlush) {
            return;
        }
        this.assertTransaction();
        this.inFlush = true;
        try {
            this.session.handleExternals();
            ManagedInstance<?>[] instances = this.session.handleAdditions();
            this.session.cascadeRemovals(instances);
            this.session.handleOrphans(instances);
            this.session.flush(this.getConnection());
        }
        catch (SQLException e) {
            LOG.error(e, "Flush failed");
            throw new PersistenceException("Flush failed", (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            LOG.debug(e, "Flush failed due to validation errors:\n\t" + Joiner.on((String)"\n\t").join((Iterable)e.getConstraintViolations()));
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error(e, "Flush failed");
            throw e;
        }
        finally {
            this.inFlush = false;
        }
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            this.joinTransaction();
            this.connection = this.datasource.getConnection();
            return this.connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to obtain connection from the datasource", (Throwable)e);
        }
    }

    public CriteriaBuilderImpl getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Object getDelegate() {
        this.assertOpen();
        return this;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.emf;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    public LockModeType getLockMode(Object entity) {
        ManagedInstance<Object> instance = this.session.get(entity);
        return instance.getLockMode();
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        if (primaryKey == null) {
            throw new NullPointerException();
        }
        EntityType type = this.metamodel.entity(entityClass);
        ManagedId managedId = new ManagedId(primaryKey, type);
        ManagedInstance instance = this.session.get(managedId);
        if (instance != null) {
            return (T)instance.getInstance();
        }
        instance = type.getManagedInstanceById(this.session, managedId, true);
        this.session.put(instance);
        return (T)instance.getInstance();
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public EntityTransactionImpl getTransaction() {
        if (this.transaction != null) {
            return this.transaction;
        }
        this.assertOpen();
        this.transaction = new EntityTransactionImpl(this, this.getConnection());
        return this.transaction;
    }

    public boolean hasActiveTransaction() {
        return this.transaction != null && this.transaction.isActive();
    }

    public boolean hasTransactionMarkedForRollback() {
        if (this.transaction != null) {
            return this.transaction.getRollbackOnly();
        }
        return false;
    }

    public boolean isJoinedToTransaction() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void isValid(EntityTransactionImpl transaction) {
        if (this.transaction != transaction) {
            throw new PersistenceException("Transaction is stale");
        }
    }

    public void joinTransaction() {
    }

    public void lock(ManagedInstance<?> instance, LockModeType lockMode, Map<String, Object> properties) {
        if (lockMode == LockModeType.OPTIMISTIC || lockMode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
            EntityTypeImpl<?> type = instance.getType().getRootType();
            if (!type.hasVersionAttribute()) {
                throw new PersistenceException("OPTIMISTIC and OPTIMISTIC_FORCE_INCREMENT not supported on non-versioned entity " + instance.getType().getName());
            }
            try {
                if (lockMode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
                    this.assertTransaction();
                    instance.incrementVersion(this.getConnection(), true);
                } else {
                    instance.incrementVersion(this.getConnection(), false);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException("Unabled to update the version", (Throwable)e);
            }
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.lock(this.session.get(entity), lockMode, properties);
    }

    public <T> T merge(T entity) {
        MutableBoolean requiresFlush = new MutableBoolean(false);
        LinkedList persistedInstances = Lists.newLinkedList();
        T mergedEntity = this.mergeImpl(entity, requiresFlush, Maps.newIdentityHashMap(), persistedInstances, true);
        if (requiresFlush.booleanValue()) {
            this.flush();
        }
        for (ManagedInstance instance : persistedInstances) {
            instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.PRE_PERSIST);
        }
        return mergedEntity;
    }

    public <T> T mergeImpl(T entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, LinkedList<ManagedInstance<?>> instances, boolean cascade) {
        Object id;
        if (entity == null) {
            return null;
        }
        Object processedEntity = processed.get(entity);
        if (processedEntity != null) {
            return (T)processedEntity;
        }
        ManagedInstance<Object> instance = this.session.get(entity);
        Class<?> clazz = entity.getClass();
        if (entity instanceof EnhancedInstance) {
            clazz = clazz.getSuperclass();
        }
        EntityType type = this.metamodel.entity(clazz);
        if (instance != null) {
            if (instance.getStatus() == Status.REMOVED) {
                throw new IllegalArgumentException("Entity has been previously removed");
            }
            if (instance.getStatus() == Status.MANAGED || instance.getStatus() == Status.NEW) {
                processed.put(entity, instance.getInstance());
                if (instance.getStatus() == Status.NEW) {
                    instances.add(instance);
                }
                if (instance.getInstance() != entity) {
                    instance.mergeWith(this, entity, requiresFlush, processed, instances);
                } else {
                    this.cascadeMerge((EntityTypeImpl<T>)type, entity, requiresFlush, processed, instances);
                }
                return (T)instance.getInstance();
            }
        }
        if ((id = type.getInstanceId(entity)) != null) {
            Object existingEntity = null;
            try {
                existingEntity = this.find(clazz, id);
            }
            catch (NoResultException e) {
                // empty catch block
            }
            if (existingEntity != null) {
                instance = ((EnhancedInstance)existingEntity).__enhanced__$$__getManagedInstance();
                processed.put(entity, instance.getInstance());
                instance.mergeWith(this, entity, requiresFlush, processed, instances);
                return (T)instance.getInstance();
            }
        }
        ManagedId managedId = new ManagedId(id, type);
        instance = type.getManagedInstanceById(this.session, managedId, false);
        instance.setStatus(Status.NEW);
        instance.enhanceCollections();
        this.session.putExternal(instance);
        processed.put(entity, instance.getInstance());
        instances.add(instance);
        instance.mergeWith(this, entity, requiresFlush, processed, instances);
        if (!instance.fillIdValues()) {
            requiresFlush.setValue(true);
        }
        return (T)instance.getInstance();
    }

    public void persist(Object entity) {
        this.assertTransaction();
        LinkedList persistedInstances = Lists.newLinkedList();
        if (this.persistImpl(entity, Lists.newArrayList(), persistedInstances)) {
            this.flush();
        }
        for (ManagedInstance instance : persistedInstances) {
            instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.PRE_PERSIST);
        }
    }

    public <T> boolean persistImpl(T entity, ArrayList<Object> processed, LinkedList<ManagedInstance<?>> instances) {
        ManagedInstance<?> instance;
        if (processed.contains(entity)) {
            return false;
        }
        if (entity instanceof EnhancedInstance && (instance = ((EnhancedInstance)entity).__enhanced__$$__getManagedInstance()).getStatus() == Status.DETACHED) {
            throw new EntityExistsException("Entity has been previously detached");
        }
        ManagedInstance<T> existing = this.session.get(entity);
        if (existing != null) {
            processed.add(entity);
            instances.add(existing);
            switch (existing.getStatus()) {
                case REMOVED: {
                    existing.setStatus(Status.MANAGED);
                    return existing.cascadePersist(this, processed, instances);
                }
                case NEW: 
                case MANAGED: {
                    return existing.cascadePersist(this, processed, instances);
                }
            }
        }
        EntityType type = this.metamodel.entity(entity.getClass());
        ManagedInstance<T> instance2 = type.getManagedInstance(this.session, entity);
        instance2.setStatus(Status.NEW);
        instance2.enhanceCollections();
        boolean requiresFlush = !instance2.fillIdValues();
        this.session.putExternal(instance2);
        processed.add(entity);
        instances.add(instance2);
        return requiresFlush |= instance2.cascadePersist(this, processed, instances);
    }

    public void refresh(Object entity) {
        this.refresh(entity, LockModeType.NONE, null);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.refresh(entity, lockMode, null);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertOpen();
        this.refreshImpl(entity, lockMode, Sets.newHashSet());
        this.closeConnectionIfNecessary();
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, LockModeType.NONE, properties);
    }

    public ManagedInstance<?> refreshImpl(Object entity, LockModeType lockMode, Set<Object> processed) {
        ManagedInstance<?> instance;
        if (entity == null) {
            return null;
        }
        if (processed.contains(entity)) {
            return null;
        }
        if (entity instanceof EnhancedInstance && (instance = ((EnhancedInstance)entity).__enhanced__$$__getManagedInstance()).getSession() == this.session && instance.getStatus() == Status.MANAGED) {
            instance.refresh(this, this.getConnection(), lockMode, processed);
            processed.add(instance);
            return instance;
        }
        throw new IllegalArgumentException("entity is not managed");
    }

    public void remove(Object entity) {
        this.assertOpen();
        LinkedList removedInstances = Lists.newLinkedList();
        this.removeImpl(entity, Lists.newArrayList(), removedInstances);
        for (ManagedInstance instance : removedInstances) {
            instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.PRE_REMOVE);
        }
    }

    public void removeImpl(Object entity, ArrayList<Object> processed, LinkedList<ManagedInstance<?>> instances) {
        EnhancedInstance enhancedInstance;
        ManagedInstance<?> instance;
        if (processed != null && processed.contains(entity)) {
            return;
        }
        if (entity instanceof EnhancedInstance && (instance = (enhancedInstance = (EnhancedInstance)entity).__enhanced__$$__getManagedInstance()) != null && instance.getStatus() == Status.DETACHED) {
            throw new IllegalArgumentException("Entity has been previously detached");
        }
        ManagedInstance<Object> instance2 = this.session.get(entity);
        if (instance2 != null) {
            if (instance2.getStatus() == Status.MANAGED) {
                instance2.setStatus(Status.REMOVED);
                this.session.setChanged(instance2);
                if (processed != null) {
                    processed.add(entity);
                    instances.add(instance2);
                }
                instance2.cascadeRemove(this, processed, instances);
            } else if (instance2.getStatus() == Status.NEW) {
                this.session.remove(instance2.getInstance());
                instance2.setStatus(Status.DETACHED);
                if (processed != null) {
                    processed.add(entity);
                    instances.add(instance2);
                }
                instance2.cascadeRemove(this, processed, instances);
            }
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
        if (this.transaction != null) {
            this.transaction.setRollbackOnly();
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == DataSource.class) {
            return (T)this.datasource;
        }
        if (clazz == Connection.class) {
            return (T)this.connection;
        }
        return null;
    }
}

