/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedIdAttributeMetadata;

public class EmbeddedAttribute<X, T>
extends SingularAttributeImpl<X, T>
implements SingularAttribute<X, T> {
    private final boolean id;
    private final List<AssociationMetadata> associationOverrides;
    private final List<AttributeOverrideMetadata> attributeOverrides;
    private EmbeddableTypeImpl<T> type;

    public EmbeddedAttribute(IdentifiableTypeImpl<X> declaringType, EmbeddedIdAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.id = true;
        this.associationOverrides = Lists.newArrayList();
        this.attributeOverrides = metadata.getAttributeOverrides();
    }

    public EmbeddedAttribute(ManagedTypeImpl<X> declaringType, EmbeddedAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.id = false;
        this.associationOverrides = metadata.getAssociationOverrides();
        this.attributeOverrides = metadata.getAttributeOverrides();
    }

    @Override
    public <Z extends X> EmbeddedAttribute<Z, T> clone(EntityTypeImpl<Z> type) {
        return new EmbeddedAttribute<Z, T>(type, (EmbeddedIdAttributeMetadata)this.getMetadata());
    }

    public AssociationMetadata getAssociationOverride(String path) {
        for (AssociationMetadata override : this.associationOverrides) {
            if (!override.getName().equals(path)) continue;
            return override;
        }
        return null;
    }

    public ColumnMetadata getAttributeOverride(String path) {
        for (AttributeOverrideMetadata override : this.attributeOverrides) {
            if (!override.getName().equals(path)) continue;
            return override.getColumn();
        }
        return null;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.EMBEDDED;
    }

    public EmbeddableTypeImpl<T> getType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.getMetamodel().embeddable(this.getBindableJavaType());
        return this.type;
    }

    public boolean isAssociation() {
        return false;
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isVersion() {
        return false;
    }

    public T newInstance() {
        return (T)this.getType().newInstance();
    }
}

