/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import java.lang.reflect.Member;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.RootMapping;
import org.batoo.jpa.parser.AbstractLocator;

public abstract class AbstractMapping<Z, X, Y>
implements Mapping<Z, X, Y> {
    private final AbstractParentMapping<?, Z> parent;
    private final String path;
    private final Class<X> javaType;
    private final String name;
    private final MetamodelImpl metamodel;
    private final boolean root;
    private final boolean inherited;
    private final EntityTypeImpl<?> entity;
    private final AttributeImpl<? super Z, X> attribute;

    public AbstractMapping(AbstractParentMapping<?, Z> parent, AttributeImpl<? super Z, X> attribute, Class<X> javaType, String name) {
        this.javaType = javaType;
        this.parent = parent;
        this.attribute = attribute;
        this.name = name;
        this.metamodel = attribute != null ? attribute.getMetamodel() : null;
        this.path = parent != null && parent.getPath() != null ? parent.getPath() + "." + name : name;
        this.root = parent instanceof RootMapping;
        this.entity = (EntityTypeImpl)(this.getRoot().isEntity() ? this.getRoot().getType() : null);
        this.inherited = this.entity != null && this.entity.getRootType() != this.entity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractMapping other = (AbstractMapping)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public final X get(Object instance) {
        if (instance == null) {
            return null;
        }
        if (!this.root && !instance.getClass().isAssignableFrom(((AbstractMapping)((Object)this.getParent())).getJavaType())) {
            instance = ((AbstractMapping)((Object)this.getParent())).get(instance);
        }
        return this.attribute.get(instance);
    }

    public AttributeImpl<? super Z, X> getAttribute() {
        return this.attribute;
    }

    @Override
    public Member getJavaMember() {
        return this.attribute.getJavaMember();
    }

    @Override
    public Class<X> getJavaType() {
        return this.javaType;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.attribute.getLocator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractParentMapping<?, Z> getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public RootMapping<?> getRoot() {
        return this.parent.getRoot();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public boolean isCollection() {
        return this.attribute.isCollection();
    }

    @Override
    public final void set(Object instance, Object value) {
        if (!this.root) {
            Object newInstance = this.parent.get(instance);
            if (newInstance == null) {
                newInstance = ((EmbeddedAttribute)((EmbeddedMappingImpl)this.parent).getAttribute()).newInstance();
                this.parent.set(instance, newInstance);
                instance = newInstance;
            } else {
                instance = newInstance;
            }
        }
        if (!this.inherited) {
            this.attribute.set(instance, value);
        } else {
            EntityTypeImpl<?> type = this.metamodel.getEntity(instance.getClass());
            if (type.extendz(this.entity)) {
                this.attribute.set(instance, value);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.attribute.toString();
    }
}

