/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.ParentMapping;

public abstract class AbstractParentMapping<Z, X>
extends AbstractMapping<Z, X, X>
implements ParentMapping<Z, X> {
    private final Map<String, Mapping<? super X, ?, ?>> children = Maps.newHashMap();
    private JoinedMapping<?, ?, ?>[] eagerMappings;

    public AbstractParentMapping(AbstractParentMapping<?, Z> parent, EmbeddedAttribute<? super Z, X> attribute, Class<X> javaType, String name) {
        super(parent, attribute, javaType, name);
    }

    public void addAssociations(List<AssociationMappingImpl<?, ?, ?>> associations) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof AssociationMappingImpl) {
                associations.add((AssociationMappingImpl)mapping);
                continue;
            }
            if (!(mapping instanceof AbstractParentMapping)) continue;
            ((AbstractParentMapping)mapping).addAssociations(associations);
        }
    }

    public void addBasicMappings(List<BasicMappingImpl<?, ?>> mappings) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof BasicMappingImpl) {
                mappings.add((BasicMappingImpl)mapping);
                continue;
            }
            if (!(mapping instanceof AbstractParentMapping)) continue;
            ((AbstractParentMapping)mapping).addBasicMappings(mappings);
        }
    }

    public void addJoinedMappings(List<JoinedMapping<?, ?, ?>> mappingsJoined) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof JoinedMapping) {
                JoinedMapping joinedMapping = (JoinedMapping)mapping;
                if (!joinedMapping.isJoined()) continue;
                mappingsJoined.add(joinedMapping);
                continue;
            }
            if (!(mapping instanceof AbstractParentMapping)) continue;
            ((AbstractParentMapping)mapping).addJoinedMappings(mappingsJoined);
        }
    }

    public void addPluralMappings(List<PluralMappingEx<?, ?, ?>> elementCollections) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof PluralMappingEx) {
                elementCollections.add((PluralMappingEx)mapping);
                continue;
            }
            if (!(mapping instanceof AbstractParentMapping)) continue;
            ((AbstractParentMapping)mapping).addPluralMappings(elementCollections);
        }
    }

    public void addSingularMappings(List<AbstractMapping<?, ?, ?>> mappings) {
        for (Mapping<X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof AbstractParentMapping) {
                ((AbstractParentMapping)mapping).addSingularMappings(mappings);
                continue;
            }
            if (mapping.isCollection()) continue;
            mappings.add((AbstractMapping)mapping);
        }
    }

    private <Y> void createEmbeddedMapping(EmbeddedAttribute<? super X, Y> attribute) {
        EmbeddedMappingImpl<X, Y> mapping = new EmbeddedMappingImpl<X, Y>(this, attribute);
        this.children.put(attribute.getName(), mapping);
        mapping.createMappings();
    }

    private void createMapping(Attribute<? super X, ?> attribute) {
        switch (attribute.getPersistentAttributeType()) {
            case BASIC: {
                this.children.put(((BasicAttribute)attribute).getName(), new BasicMappingImpl(this, (BasicAttribute)attribute));
                break;
            }
            case ELEMENT_COLLECTION: {
                this.children.put(((PluralAttributeImpl)attribute).getName(), new ElementCollectionMappingImpl(this, (PluralAttributeImpl)attribute));
                break;
            }
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                this.children.put(((AssociatedSingularAttribute)attribute).getName(), new SingularAssociationMappingImpl(this, (AssociatedSingularAttribute)attribute));
                break;
            }
            case MANY_TO_MANY: 
            case ONE_TO_MANY: {
                this.children.put(((PluralAttributeImpl)attribute).getName(), new PluralAssociationMappingImpl(this, (PluralAttributeImpl)attribute));
                break;
            }
            case EMBEDDED: {
                this.createEmbeddedMapping((EmbeddedAttribute)attribute);
            }
        }
    }

    public void createMappings() {
        for (Attribute<X, ?> attribute : this.getType().getAttributes()) {
            EntityTypeImpl type;
            if (attribute.getDeclaringType() != this.getType() && (attribute.getDeclaringType() instanceof MappedSuperclassTypeImpl ? (type = (EntityTypeImpl)this.getType()).getRootType() != type : attribute.getDeclaringType() instanceof EntityTypeImpl)) continue;
            this.createMapping(attribute);
        }
    }

    @Override
    public AbstractMapping<? super X, ?, ?> getChild(String name) {
        return (AbstractMapping)this.children.get(name);
    }

    @Override
    public Collection<Mapping<? super X, ?, ?>> getChildren() {
        return this.children.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinedMapping<?, ?, ?>[] getEagerMappings() {
        if (this.eagerMappings != null) {
            return this.eagerMappings;
        }
        AbstractParentMapping abstractParentMapping = this;
        synchronized (abstractParentMapping) {
            if (this.eagerMappings != null) {
                return this.eagerMappings;
            }
            ArrayList eagerMappings = Lists.newArrayList();
            for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
                JoinedMapping joinedMapping;
                if (!(mapping instanceof JoinedMapping) || !(joinedMapping = (JoinedMapping)mapping).isEager()) continue;
                eagerMappings.add(joinedMapping);
            }
            JoinedMapping[] eagerMappings0 = new JoinedMapping[eagerMappings.size()];
            eagerMappings.toArray(eagerMappings0);
            this.eagerMappings = eagerMappings0;
            return eagerMappings0;
        }
    }

    public AttributeImpl<?, ?> getRootAttribute(AttributeImpl<?, ?> attribute) {
        return this.getParent() instanceof EmbeddedMappingImpl ? ((AbstractMapping)((Object)this.getParent())).getAttribute() : attribute;
    }

    public String getRootPath(String path) {
        return this.getParent() instanceof EmbeddedMappingImpl ? ((AbstractMapping)((Object)this.getParent())).getAttribute().getName() + "." + path : path;
    }

    public abstract ManagedTypeImpl<? super X> getType();

    protected void inherit(Collection<Mapping<? super X, ?, ?>> children) {
        for (Mapping<X, ?, ?> mapping : children) {
            this.children.put(mapping.getName(), mapping);
        }
    }

    public abstract boolean isId();
}

