/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.base.Splitter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.annotations.FetchStrategyType;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.jdbc.JoinTable;
import org.batoo.jpa.jdbc.mapping.AssociationMapping;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.MappableAssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OrphanableAssociationAttributeMetadata;

public abstract class AssociationMappingImpl<Z, X, Y>
extends AbstractMapping<Z, X, Y>
implements JoinedMapping<Z, X, Y>,
AssociationMapping<Z, X, Y> {
    private final boolean eager;
    private final boolean cascadesDetach;
    private final boolean cascadesMerge;
    private final boolean cascadesPersist;
    private final boolean cascadesRefresh;
    private final boolean cascadesRemove;
    private final String mappedBy;
    private final boolean removesOrphans;
    private final int maxFetchDepth;
    private final FetchStrategyType fetchStrategy;
    private CriteriaQueryImpl<Y> selectCriteria;
    private boolean ownerSelect;

    public AssociationMappingImpl(AbstractParentMapping<?, Z> parent, AssociationAttributeMetadata metadata, AttributeImpl<? super Z, X> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        this.mappedBy = metadata instanceof MappableAssociationAttributeMetadata && StringUtils.isNotBlank((String)((MappableAssociationAttributeMetadata)((Object)metadata)).getMappedBy()) ? ((MappableAssociationAttributeMetadata)((Object)metadata)).getMappedBy() : null;
        this.eager = attribute.isCollection() || this.mappedBy == null ? metadata.getFetchType() == FetchType.EAGER : true;
        this.maxFetchDepth = metadata.getMaxFetchDepth();
        this.fetchStrategy = metadata.getFetchStrategy();
        this.removesOrphans = metadata instanceof OrphanableAssociationAttributeMetadata ? ((OrphanableAssociationAttributeMetadata)((Object)metadata)).removesOrphans() : false;
        this.cascadesDetach = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.DETACH);
        this.cascadesMerge = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.MERGE);
        this.cascadesPersist = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.PERSIST);
        this.cascadesRefresh = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.REFRESH);
        this.cascadesRemove = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.REMOVE);
    }

    public final boolean cascadesDetach() {
        return this.cascadesDetach;
    }

    public final boolean cascadesMerge() {
        return this.cascadesMerge;
    }

    public final boolean cascadesPersist() {
        return this.cascadesPersist;
    }

    public final boolean cascadesRefresh() {
        return this.cascadesRefresh;
    }

    public final boolean cascadesRemove() {
        return this.cascadesRemove;
    }

    public abstract void checkTransient(ManagedInstance<?> var1);

    @Override
    public abstract void flush(Connection var1, ManagedInstance<?> var2, boolean var3, boolean var4) throws SQLException;

    private CriteriaQueryImpl<Y> generateMappedSelectCriteria(MetamodelImpl metamodel, CriteriaBuilderImpl cb, Class<Y> bindableType, EntityTypeImpl<Y> entity) {
        CriteriaQuery q = cb.createQuery((Class)bindableType);
        q.internal();
        Root r = q.from(entity);
        r.alias(BatooUtils.acronym(entity.getName()).toLowerCase());
        q.select((Selection)r);
        Iterator pathIterator = Splitter.on((String)".").split((CharSequence)this.getInverse().getPath()).iterator();
        pathIterator.next();
        AbstractPath path = null;
        while (pathIterator.hasNext()) {
            path = path == null ? r.get((String)pathIterator.next()) : path.get((String)pathIterator.next());
        }
        entity.prepareEagerJoins((FetchParent<?, ?>)r, 0, this);
        ParameterExpression pe = cb.parameter(this.getInverse().getJavaType());
        Predicate predicate = cb.equal((Expression)path, (Expression)pe);
        this.selectCriteria = q.where((Expression)predicate);
        return this.selectCriteria;
    }

    private CriteriaQueryImpl<Y> generateOwnerSelectCriteria(MetamodelImpl metamodel, CriteriaBuilderImpl cb, Class<Y> bindableType, EntityTypeImpl<Y> entity) {
        CriteriaQuery q = cb.createQuery((Class)bindableType);
        q.internal();
        EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
        Root r = q.from(type);
        r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
        Iterator pathIterator = Splitter.on((String)".").split((CharSequence)this.getPath()).iterator();
        pathIterator.next();
        AbstractFrom join = null;
        while (pathIterator.hasNext()) {
            join = join == null ? r.join((String)pathIterator.next()) : join.join((String)pathIterator.next());
        }
        q.select(join);
        entity.prepareEagerJoins((FetchParent<?, ?>)join, 0, this);
        this.selectCriteria = q.where((Expression)cb.equal((Expression)r, (Expression)cb.parameter(type.getJavaType())));
        return this.selectCriteria;
    }

    protected AssociationMetadata getAssociationMetadata() {
        AssociationMetadata metadata = null;
        String path = ((AbstractParentMapping)this.getParent()).getRootPath(this.getName());
        AttributeImpl rootAttribute = ((AbstractParentMapping)this.getParent()).getRootAttribute(this.getAttribute());
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMappingImpl && (metadata = ((EmbeddedMappingImpl)this.getParent()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() instanceof MappedSuperclassTypeImpl && (metadata = ((EntityTypeImpl)this.getRoot().getType()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        if (this.getParent() instanceof EmbeddedMappingImpl && (metadata = ((EmbeddedMappingImpl)this.getParent()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        return (AssociationMetadata)((Object)this.getAttribute().getMetadata());
    }

    public FetchStrategyType getFetchStrategy() {
        return this.fetchStrategy;
    }

    public abstract AssociationMappingImpl<?, ?, ?> getInverse();

    @Override
    public abstract JoinTable getJoinTable();

    public String getMappedBy() {
        return this.mappedBy;
    }

    public int getMaxFetchJoinDepth() {
        return this.maxFetchDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CriteriaQueryImpl<Y> getSelectCriteria() {
        if (this.selectCriteria != null) {
            return this.selectCriteria;
        }
        AssociationMappingImpl associationMappingImpl = this;
        synchronized (associationMappingImpl) {
            if (this.selectCriteria != null) {
                return this.selectCriteria;
            }
            MetamodelImpl metamodel = ((EntityTypeImpl)this.getRoot().getType()).getMetamodel();
            CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
            Class<Object> bindableType = this.getAttribute() instanceof PluralAttributeImpl ? ((PluralAttributeImpl)this.getAttribute()).getBindableJavaType() : ((SingularAttributeImpl)this.getAttribute()).getBindableJavaType();
            EntityType entity = metamodel.entity(bindableType);
            boolean bl = this.ownerSelect = this.isOwner() || this.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY;
            if (this.ownerSelect) {
                return this.generateOwnerSelectCriteria(metamodel, cb, (Class<Y>)bindableType, (EntityTypeImpl<Y>)entity);
            }
            return this.generateMappedSelectCriteria(metamodel, cb, (Class<Y>)bindableType, (EntityTypeImpl<Y>)entity);
        }
    }

    @Override
    public abstract EntityTypeImpl<Y> getType();

    @Override
    public abstract void initialize(ManagedInstance<?> var1);

    @Override
    public final boolean isEager() {
        return this.eager;
    }

    public final boolean isOwner() {
        return this.mappedBy == null;
    }

    protected boolean isOwnerSelect() {
        return this.ownerSelect;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        if (this.getForeignKey() != null) {
            return this.getForeignKey().createDestinationJoin(joinType, parentAlias, alias);
        }
        if (this.getInverse() != null && this.getInverse().getForeignKey() != null) {
            return this.getInverse().getForeignKey().createSourceJoin(joinType, parentAlias, alias);
        }
        if (this.getJoinTable() != null) {
            return this.getJoinTable().createJoin(joinType, parentAlias, alias, true);
        }
        return this.getInverse().getJoinTable().createJoin(joinType, parentAlias, alias, false);
    }

    public abstract void link() throws MappingException;

    public abstract void mergeWith(EntityManagerImpl var1, ManagedInstance<?> var2, Object var3, MutableBoolean var4, IdentityHashMap<Object, Object> var5, LinkedList<ManagedInstance<?>> var6);

    public abstract boolean references(Object var1, Object var2);

    public abstract void refresh(ManagedInstance<?> var1, Set<Object> var2);

    public boolean removesOrphans() {
        return this.removesOrphans;
    }

    public abstract void setInverse(AssociationMappingImpl<?, ?, ?> var1);
}

