/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.BatooUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.ManagedList;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.ElementMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.ListComparator;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.jdbc.CollectionTable;
import org.batoo.jpa.jdbc.Joinable;
import org.batoo.jpa.jdbc.JoinableTable;
import org.batoo.jpa.jdbc.OrderColumn;
import org.batoo.jpa.jdbc.mapping.ElementCollectionMapping;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.ElementCollectionAttributeMetadata;

public class ElementCollectionMappingImpl<Z, C, E>
extends AbstractMapping<Z, C, E>
implements PluralMappingEx<Z, C, E>,
ElementCollectionMapping<Z, C, E> {
    private final PluralAttributeImpl<? super Z, C, E> attribute;
    private final boolean eager;
    private final CollectionTable collectionTable;
    private final ColumnMetadata column;
    private final EnumType enumType;
    private final boolean lob;
    private final TemporalType temporalType;
    private final String orderBy;
    private final ColumnMetadata orderColumn;
    private final ColumnMetadata mapKeyColumn;
    private final String mapKey;
    private final EnumType mapKeyEnumType;
    private final TemporalType mapKeyTemporalType;
    private TypeImpl<E> type;
    private SingularMappingEx<? super E, ?> keyMapping;
    private ElementMappingImpl<E> rootMapping;
    private FinalWrapper<Comparator<E>> comparator;
    private FinalWrapper<CriteriaQueryImpl<E>> selectCriteria;
    private FinalWrapper<CriteriaQueryImpl<Object[]>> selectMapCriteria;

    public ElementCollectionMappingImpl(AbstractParentMapping<?, Z> parent, PluralAttributeImpl<? super Z, C, E> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        ElementCollectionAttributeMetadata metadata = (ElementCollectionAttributeMetadata)attribute.getMetadata();
        this.attribute = attribute;
        this.eager = metadata.getFetchType() == FetchType.EAGER;
        this.collectionTable = new CollectionTable(attribute.getMetamodel().getJdbcAdaptor(), this, metadata.getCollectionTable());
        this.column = metadata.getColumn();
        this.enumType = metadata.getEnumType();
        this.lob = metadata.isLob();
        this.temporalType = metadata.getTemporalType();
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            this.orderColumn = metadata.getOrderColumn();
            this.orderBy = metadata.getOrderBy();
        } else {
            this.orderBy = null;
            this.orderColumn = null;
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            this.mapKeyColumn = metadata.getMapKeyColumn();
            this.mapKeyTemporalType = metadata.getMapKeyTemporalType();
            this.mapKeyEnumType = metadata.getMapKeyEnumType();
            this.mapKey = metadata.getMapKey();
        } else {
            this.mapKeyColumn = null;
            this.mapKeyTemporalType = null;
            this.mapKeyEnumType = null;
            this.mapKey = null;
        }
    }

    @Override
    public void attach(Connection connection, ManagedInstance<?> instance, Joinable[] batch, int size) throws SQLException {
        this.collectionTable.performInsert(connection, instance.getInstance(), batch, size);
    }

    @Override
    public boolean cascadesMerge() {
        return false;
    }

    @Override
    public void detach(Connection connection, ManagedInstance<?> instance, Object key, Object child) throws SQLException {
        this.collectionTable.performRemove(connection, instance.getInstance(), key, child);
    }

    @Override
    public void detachAll(Connection connection, ManagedInstance<?> instance) throws SQLException {
        this.collectionTable.performRemoveAll(connection, instance.getInstance());
    }

    @Override
    public void enhance(ManagedInstance<?> instance) {
        Object c = this.get(instance.getInstance());
        if (c == null) {
            this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, false));
        } else {
            this.set(instance.getInstance(), this.attribute.newCollection(this, instance, c));
        }
    }

    @Override
    public Object extractKey(Object value) {
        return this.keyMapping.get(value);
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        Object collection = this.get(managedInstance.getInstance());
        if (collection != null) {
            ((ManagedCollection)collection).flush(connection, removals, force);
        }
    }

    public PluralAttributeImpl<? super Z, C, E> getAttribute() {
        return this.attribute;
    }

    public CollectionTable getCollectionTable() {
        return this.collectionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<E> getComparator() {
        FinalWrapper<Comparator<E>> wrapper = this.comparator;
        if (wrapper == null) {
            ElementCollectionMappingImpl elementCollectionMappingImpl = this;
            synchronized (elementCollectionMappingImpl) {
                if (this.comparator == null) {
                    this.comparator = new FinalWrapper(new ListComparator(this));
                }
                wrapper = this.comparator;
            }
        }
        return (Comparator)wrapper.value;
    }

    @Override
    public JoinableTable getJoinTable() {
        return this.collectionTable;
    }

    public SingularMappingEx<? super E, ?> getKeyMapping() {
        return this.keyMapping;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public AbstractMapping<?, ?, ?> getMapping(String path) {
        return this.rootMapping.getMapping(path);
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.ELEMENT_COLLECTION;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OrderColumn getOrderColumn() {
        if (this.collectionTable != null) {
            return this.collectionTable.getOrderColumn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<E> getSelectCriteria() {
        FinalWrapper<CriteriaQueryImpl<E>> wrapper = this.selectCriteria;
        ElementCollectionMappingImpl elementCollectionMappingImpl = this;
        synchronized (elementCollectionMappingImpl) {
            if (this.selectCriteria == null) {
                MetamodelImpl metamodel = this.attribute.getMetamodel();
                CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
                Object q = cb.createQuery((Class)this.attribute.getBindableJavaType());
                ((AbstractCriteriaQueryImpl)q).internal();
                EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
                Root r = ((AbstractCriteriaQueryImpl)q).from(type);
                r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
                Join join = r.join(this.attribute.getName());
                join.alias(BatooUtils.acronym(this.attribute.getName()));
                q = ((CriteriaQueryImpl)q).select((Selection)join);
                ((CriteriaQueryImpl)q).where((Expression)cb.equal((Expression)r, (Expression)cb.parameter(type.getJavaType())));
                this.selectCriteria = new FinalWrapper<Object>(q);
            }
            wrapper = this.selectCriteria;
        }
        return (CriteriaQueryImpl)wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<Object[]> getSelectMapCriteria() {
        FinalWrapper<CriteriaQueryImpl<Object[]>> wrapper = this.selectMapCriteria;
        ElementCollectionMappingImpl elementCollectionMappingImpl = this;
        synchronized (elementCollectionMappingImpl) {
            if (this.selectCriteria == null) {
                MetamodelImpl metamodel = this.attribute.getMetamodel();
                CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
                CriteriaQuery q = cb.createQuery(Object[].class);
                q.internal();
                EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
                Root r = q.from(type);
                r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
                MapJoinImpl join = (MapJoinImpl)r.join(this.attribute.getName());
                join.alias(BatooUtils.acronym(this.attribute.getName()));
                q = q.multiselect(new Selection[]{join.key(), join.value()});
                q = q.where((Expression)cb.equal((Expression)r, (Expression)cb.parameter(type.getJavaType())));
                this.selectMapCriteria = new FinalWrapper<CriteriaQuery>(q);
            }
            wrapper = this.selectMapCriteria;
        }
        return (CriteriaQueryImpl)wrapper.value;
    }

    @Override
    public TypeImpl<E> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, false));
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public boolean isEager() {
        return this.eager;
    }

    @Override
    public boolean isJoined() {
        return true;
    }

    @Override
    public boolean isMap() {
        return this.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        return this.collectionTable.getKey().createSourceJoin(joinType, parentAlias, alias);
    }

    public void link() {
        String name;
        this.type = this.attribute.getElementType();
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            this.rootMapping = new ElementMappingImpl(this, (EmbeddableTypeImpl)this.type);
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            MapAttributeImpl mapAttribute = (MapAttributeImpl)this.attribute;
            if (this.mapKey != null) {
                if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                    this.keyMapping = (SingularMappingEx)this.rootMapping.getMapping(this.mapKey);
                }
                if (this.keyMapping == null) {
                    throw new MappingException("Cannot locate the MapKey: " + this.mapKey, this.attribute.getLocator());
                }
            } else {
                name = this.mapKeyColumn != null && StringUtils.isNotBlank((String)this.mapKeyColumn.getName()) ? this.mapKeyColumn.getName() : this.attribute.getName() + "_KEY";
                this.collectionTable.setKeyColumn(this.mapKeyColumn, name, this.mapKeyTemporalType, this.mapKeyEnumType, mapAttribute.getKeyJavaType());
            }
        }
        String defaultName = this.getAttribute().getName();
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            this.collectionTable.link((EntityTypeDescriptor)this.getRoot().getTypeDescriptor(), (EmbeddableTypeImpl)this.type, defaultName, this.rootMapping);
        } else {
            this.collectionTable.link((EntityTypeDescriptor)this.getRoot().getTypeDescriptor(), this.type, defaultName, this.column, this.enumType, this.temporalType, this.lob);
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            name = this.orderColumn != null && StringUtils.isNotBlank((String)this.orderColumn.getName()) ? this.orderColumn.getName() : this.attribute.getName() + "_ORDER";
            this.collectionTable.setOrderColumn(this.orderColumn, name, this.attribute.getLocator());
        }
    }

    @Override
    public void load(ManagedInstance<?> instance) {
        this.setCollection(instance, this.loadCollection(instance));
    }

    @Override
    public Collection<? extends E> loadCollection(ManagedInstance<?> instance) {
        EntityManagerImpl em = instance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectCriteria());
        q.setParameter(1, instance.getInstance());
        return q.getResultList();
    }

    @Override
    public <K> Map<? extends K, ? extends E> loadMap(ManagedInstance<?> instance) {
        EntityManagerImpl em = instance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectMapCriteria());
        q.setParameter(1, instance.getInstance());
        HashMap resultMap = Maps.newHashMap();
        for (Object[] pair : q.getResultList()) {
            resultMap.put(pair[0], pair[1]);
        }
        return resultMap;
    }

    @Override
    public void setCollection(ManagedInstance<?> instance, Collection<? extends E> children) {
        ManagedCollection collection = (ManagedCollection)this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, false);
        BatooUtils.addAll(children, collection.getDelegate());
        this.set(instance.getInstance(), collection);
    }

    @Override
    public void setLazy(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, true));
    }

    @Override
    public void sortList(Object instance) {
        ManagedList list = (ManagedList)this.get(instance);
        if (list.isInitialized()) {
            Collections.sort(list.getDelegate(), this.getComparator());
        }
    }
}

