/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinTable;
import org.batoo.jpa.jdbc.Joinable;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.mapping.ParentMapping;
import org.batoo.jpa.jdbc.mapping.SingularAssociationMapping;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;

public class SingularAssociationMappingImpl<Z, X>
extends AssociationMappingImpl<Z, X, X>
implements SingularAssociationMapping<Z, X>,
SingularMappingEx<Z, X> {
    private final AssociatedSingularAttribute<? super Z, X> attribute;
    private final JoinTable joinTable;
    private final ForeignKey foreignKey;
    private EntityTypeImpl<X> type;
    private AssociationMappingImpl<?, ?, ?> inverse;

    public SingularAssociationMappingImpl(AbstractParentMapping<?, Z> parent, AssociatedSingularAttribute<? super Z, X> attribute) {
        super(parent, attribute.getMetadata(), attribute);
        this.attribute = attribute;
        AssociationMetadata metadata = this.getAssociationMetadata();
        if (this.isOwner()) {
            if (metadata.getJoinTable() != null) {
                this.joinTable = new JoinTable(attribute.getMetamodel().getJdbcAdaptor(), (EntityTypeImpl)attribute.getDeclaringType(), this, metadata.getJoinTable());
                this.foreignKey = null;
            } else {
                this.foreignKey = new ForeignKey(this.getAttribute().getMetamodel().getJdbcAdaptor(), this, metadata.getJoinColumns());
                this.joinTable = null;
            }
        } else {
            this.joinTable = null;
            this.foreignKey = null;
        }
    }

    @Override
    public void checkTransient(ManagedInstance<?> managedInstance) {
        Object instanceId;
        Object instance = this.get(managedInstance.getInstance());
        if (instance != null && (instanceId = this.type.getInstanceId(instance)) == null) {
            throw new PersistenceException("Instance " + instance + " is not managed");
        }
    }

    @Override
    public Object extractKey(Object value) {
        return null;
    }

    @Override
    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        return false;
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        Object entity;
        if (this.getJoinTable() != null && !removals && (entity = this.get(managedInstance.getInstance())) != null) {
            Joinable[] batch = new Joinable[]{new Joinable(null, entity, 0)};
            this.joinTable.performInsert(connection, managedInstance.getInstance(), batch, 1);
        }
    }

    @Override
    public AssociatedSingularAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public IdType getIdType() {
        if (this.attribute.isId()) {
            return IdType.MANUAL;
        }
        ParentMapping parent = this.getParent();
        if (parent instanceof EmbeddedMappingImpl) {
            return ((EmbeddedMappingImpl)parent).getIdType();
        }
        return null;
    }

    @Override
    public AssociationMappingImpl<?, ?, ?> getInverse() {
        return this.inverse;
    }

    @Override
    public JoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.SINGULAR_ASSOCIATION;
    }

    @Override
    public String getMapsId() {
        return this.attribute.getMapsId();
    }

    @Override
    public EntityTypeImpl<X> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> managedInstance) {
        EntityManagerImpl em = managedInstance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectCriteria());
        q.setParameter(1, managedInstance.getInstance());
        try {
            Object newParent;
            Object child = q.getSingleResult();
            Object instance = managedInstance.getInstance();
            this.set(instance, child);
            if (this.getInverse() != null && (newParent = this.getInverse().get(child)) == null && newParent != this) {
                this.getInverse().set(child, instance);
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public boolean isId() {
        return this.getIdType() != null;
    }

    @Override
    public boolean isJoined() {
        return this.joinTable != null || this.foreignKey != null;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public void link() throws MappingException {
        MetamodelImpl metamodel = this.getAttribute().getMetamodel();
        this.type = metamodel.entity(this.attribute.getJavaType());
        if (!this.isOwner()) {
            this.inverse = (AssociationMappingImpl)this.type.getRootMapping().getMapping(this.getMappedBy());
            if (this.inverse == null) {
                throw new MappingException("Cannot find the mappedBy attribute " + this.getMappedBy() + " specified on " + this.attribute.getJavaMember(), new AbstractLocator[0]);
            }
            this.inverse.setInverse(this);
        } else {
            EntityTypeImpl entity = (EntityTypeImpl)this.getRoot().getType();
            if (this.joinTable != null) {
                this.joinTable.link(entity, this.type);
            } else {
                this.foreignKey.link(this, this.type);
            }
        }
    }

    @Override
    public void mergeWith(EntityManagerImpl entityManager, ManagedInstance<?> instance, Object entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, LinkedList<ManagedInstance<?>> instances) {
        Object newEntity = entityManager.mergeImpl(this.get(entity), requiresFlush, processed, instances, this.cascadesMerge());
        Object oldEntity = this.get(instance.getInstance());
        if (oldEntity == newEntity) {
            return;
        }
        if (oldEntity != null && (this.removesOrphans() || this.inverse != null)) {
            if (this.removesOrphans()) {
                entityManager.remove(oldEntity);
            }
            if (this.inverse != null && this.inverse.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                ManagedInstance oldInstance = instance.getSession().get(oldEntity);
                this.inverse.set(oldInstance.getInstance(), null);
            }
        }
        this.set(instance.getInstance(), newEntity);
    }

    @Override
    public boolean references(Object instance, Object reference) {
        return this.get(instance) == reference;
    }

    @Override
    public void refresh(ManagedInstance<?> instance, Set<Object> processed) {
        this.initialize(instance);
        if (this.cascadesRefresh()) {
            instance.getSession().getEntityManager().refreshImpl(instance.getInstance(), null, processed);
        }
    }

    @Override
    public void setInverse(AssociationMappingImpl<?, ?, ?> inverse) {
        this.inverse = inverse;
    }
}

