/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.sql.Connection;
import javax.persistence.DiscriminatorType;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.parser.metadata.DiscriminatorColumnMetadata;

public class DiscriminatorColumn
extends AbstractColumn {
    private final EntityTable table;
    private final String columnDefinition;
    private final DiscriminatorType discriminatorType;
    private final int length;
    private final String name;

    private static Class<?> getJavaType(DiscriminatorColumnMetadata metadata) {
        if (metadata == null) {
            return String.class;
        }
        switch (metadata.getDiscriminatorType()) {
            case STRING: {
                return String.class;
            }
            case INTEGER: {
                return Integer.class;
            }
        }
        return Character.TYPE;
    }

    public DiscriminatorColumn(JdbcAdaptor jdbcAdaptor, EntityTable primaryTable, DiscriminatorColumnMetadata metadata) {
        super(DiscriminatorColumn.getJavaType(metadata), null, null, null, false, metadata != null ? metadata.getLocator() : null);
        this.name = jdbcAdaptor.escape(metadata != null ? metadata.getName() : "DTYPE");
        this.table = primaryTable;
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : null;
        DiscriminatorType discriminatorType = this.discriminatorType = metadata != null ? metadata.getDiscriminatorType() : DiscriminatorType.STRING;
        this.length = metadata != null ? (metadata.getDiscriminatorType() == DiscriminatorType.CHAR ? 1 : metadata.getLength()) : 31;
        this.table.addColumn(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getSqlType() {
        switch (this.discriminatorType) {
            case STRING: 
            case CHAR: {
                return 12;
            }
        }
        return 4;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getValue(Connection connection, Object instance) {
        return null;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public void setTable(AbstractTable table) {
    }

    @Override
    public void setValue(Object instance, Object value) {
    }
}

