/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.DiscriminatorColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.OptimisticLockFailedException;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.metadata.TableMetadata;

public class EntityTable
extends AbstractTable {
    private final EntityTypeDescriptor entity;
    private final Map<String, AbstractColumn> pkColumns = Maps.newHashMap();
    private final JdbcAdaptor jdbcAdaptor;
    private BasicColumn identityColumn;
    private final Map<String, BasicColumn[]> indexes = Maps.newHashMap();
    private final HashMap<Integer, String> removeSqlMap = Maps.newHashMap();
    private FinalWrapper<HashMap<AbstractColumn, String>> idColumns;

    public EntityTable(JdbcAdaptor jdbcAdaptor, EntityTypeDescriptor entity, TableMetadata metadata) {
        super(entity.getName(), metadata);
        this.jdbcAdaptor = jdbcAdaptor;
        this.entity = entity;
    }

    @Override
    public void addColumn(AbstractColumn column) {
        JoinColumn joinColumn;
        super.addColumn(column);
        if (column.isPrimaryKey()) {
            this.pkColumns.put(column.getName(), column);
            if (column.getIdType() == IdType.IDENTITY) {
                this.identityColumn = (BasicColumn)column;
            }
        } else if (column instanceof JoinColumn && (joinColumn = (JoinColumn)column).isPrimaryKey()) {
            this.pkColumns.put(column.getName(), joinColumn);
        }
    }

    public boolean addIndex(String name, BasicColumn ... columns) {
        if (this.indexes.containsKey(name)) {
            return true;
        }
        this.indexes.put(name, columns);
        return false;
    }

    public EntityTypeDescriptor getEntity() {
        return this.entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<AbstractColumn, String> getIdFields() {
        if (this.idColumns != null) {
            return (HashMap)this.idColumns.value;
        }
        EntityTable entityTable = this;
        synchronized (entityTable) {
            if (this.idColumns != null) {
                return (HashMap)this.idColumns.value;
            }
            HashMap _idFields = Maps.newHashMap();
            for (AbstractColumn column : this.pkColumns.values()) {
                _idFields.put(column, column.getName());
            }
            this.idColumns = new FinalWrapper<HashMap>(_idFields);
        }
        return (HashMap)this.idColumns.value;
    }

    public Map<String, BasicColumn[]> getIndexes() {
        return this.indexes;
    }

    protected JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    @Override
    public Set<String> getPkColumnNames() {
        return this.pkColumns.keySet();
    }

    public Collection<AbstractColumn> getPkColumns() {
        return this.pkColumns.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql(int size) {
        String sql = this.removeSqlMap.get(size);
        if (sql != null) {
            return sql;
        }
        EntityTable entityTable = this;
        synchronized (entityTable) {
            sql = this.removeSqlMap.get(size);
            if (sql != null) {
                return sql;
            }
            String restriction = size == 1 ? this.getRestrictionSql(this.pkColumns) : this.pkColumns.values().iterator().next().getName() + " IN (" + StringUtils.repeat((String)"?", (String)", ", (int)size) + ")";
            sql = "DELETE FROM " + this.getQName() + " WHERE " + restriction;
            this.removeSqlMap.put(size, sql);
            return sql;
        }
    }

    public void performInsert(Connection connection, EntityTypeDescriptor entityType, Object[] instances, int size) throws SQLException {
        String insertSql = this.getInsertSql(entityType, size);
        AbstractColumn[] insertColumns = this.getInsertColumns(entityType, size);
        Object[] params = new Object[insertColumns.length * size];
        boolean hasLob = false;
        for (int i = 0; i < size; ++i) {
            Object instance = instances[i];
            for (int j = 0; j < insertColumns.length; ++j) {
                AbstractColumn column = insertColumns[j];
                params[i * insertColumns.length + j] = column instanceof DiscriminatorColumn ? entityType.getDiscriminatorValue() : column.getValue(connection, instance);
                hasLob |= column.isLob();
            }
        }
        new QueryRunner(this.jdbcAdaptor, hasLob).update(connection, insertSql, params);
        if (this.identityColumn != null) {
            String selectLastIdSql = this.jdbcAdaptor.getSelectLastIdentitySql(this.identityColumn);
            Number id = (Number)new QueryRunner(this.jdbcAdaptor, false).query(connection, selectLastIdSql, new SingleValueHandler());
            this.identityColumn.setValue(instances[0], id);
        }
    }

    public void performRemove(Connection connection, Object[] instances, int size) throws SQLException {
        String removeSql = this.getRemoveSql(size);
        AbstractColumn[] restrictionColumns = this.getRestrictionColumns();
        Object[] params = new Object[size * restrictionColumns.length];
        for (int i = 0; i < size; ++i) {
            Object instance = instances[i];
            for (int j = 0; j < restrictionColumns.length; ++j) {
                AbstractColumn column = restrictionColumns[j];
                params[i * restrictionColumns.length + j] = column.getValue(connection, instance);
            }
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor, false);
        if (size != runner.update(connection, removeSql, params)) {
            throw new OptimisticLockFailedException();
        }
    }

    public void performUpdate(Connection connection, EntityTypeDescriptor type, Object instance, Object oldVersion) throws SQLException {
        String updateSql = this.getUpdateSql(type, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(type);
        AbstractColumn[] restrictionColumns = this.getRestrictionColumns();
        boolean hasLob = false;
        int nextParamNo = 0;
        Object[] params = new Object[updateColumns.length + restrictionColumns.length];
        for (AbstractColumn column : updateColumns) {
            params[nextParamNo++] = column.getValue(connection, instance);
            hasLob |= column.isLob();
        }
        for (AbstractColumn column : restrictionColumns) {
            params[nextParamNo++] = column.isVersion() ? oldVersion : column.getValue(connection, instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor, hasLob);
        if (1 != runner.update(connection, updateSql, params)) {
            throw new OptimisticLockFailedException();
        }
    }

    public boolean performUpdateWithUpdatability(Connection connection, EntityTypeDescriptor type, Object instance, Object oldVersion) throws SQLException {
        String updateSql = this.getUpdateSql(type, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(type);
        AbstractColumn[] restrictionColumns = this.getRestrictionColumns();
        if (updateColumns.length == 0) {
            return false;
        }
        int nextParam = 0;
        boolean hasLob = false;
        Object[] params = new Object[updateColumns.length + restrictionColumns.length];
        for (AbstractColumn column : updateColumns) {
            params[nextParam++] = column.getValue(connection, instance);
            hasLob |= column.isLob();
        }
        for (AbstractColumn column : restrictionColumns) {
            params[nextParam++] = column.isVersion() ? oldVersion : column.getValue(connection, instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor, hasLob);
        if (1 != runner.update(connection, updateSql, params)) {
            throw new OptimisticLockFailedException();
        }
        return true;
    }

    public void performVersionUpdate(Connection connection, Object instance, Object oldVersion, Object newVersion) throws SQLException {
        String updateSql = this.getVersionUpdateSql(this.pkColumns);
        AbstractColumn[] restrictionColumns = this.getRestrictionColumns();
        Object[] params = new Object[restrictionColumns.length];
        params[0] = newVersion;
        for (int i = 1; i < restrictionColumns.length - 1; ++i) {
            AbstractColumn column = restrictionColumns[i];
            params[i] = column.getValue(connection, instance);
        }
        params[params.length - 1] = oldVersion;
        if (1 != new QueryRunner(this.jdbcAdaptor, false).update(connection, updateSql, params)) {
            throw new OptimisticLockFailedException();
        }
    }

    public String toString() {
        String columns = Joiner.on((String)", ").join((Iterable)Collections2.transform(this.getColumnMap().values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                StringBuffer out = new StringBuffer();
                out.append(input.isPrimaryKey() ? "ID [" : "COL [");
                out.append("name=");
                out.append(input.getName());
                out.append(", type=");
                out.append(input.getSqlType());
                out.append("]");
                return out.toString();
            }
        }));
        return "Table [owner=" + this.entity.getName() + ", name=" + this.getQName() + ", columns=[" + columns + "]]";
    }
}

