/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.GenerationType;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.CollectionTable;
import org.batoo.jpa.jdbc.DDLMode;
import org.batoo.jpa.jdbc.DateTimeFunctionType;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.JoinTable;
import org.batoo.jpa.jdbc.NumericFunctionType;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.adapter.AbstractJdbcAdaptor;
import org.batoo.jpa.jdbc.adapter.JdbcColumn;
import org.batoo.jpa.jdbc.adapter.JdbcForeignKey;
import org.batoo.jpa.jdbc.adapter.JdbcTable;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;
import org.batoo.jpa.jdbc.generator.TableGenerator;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;

public abstract class JdbcAdaptor
extends AbstractJdbcAdaptor {
    private static final String[] TABLE_OR_VIEW = new String[]{"TABLE", "VIEW"};
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final BLogger LOG = BLoggerFactory.getLogger(JdbcAdaptor.class);
    private List<String> words;
    private final Map<AbstractTable, JdbcTable> tables = Maps.newHashMap();
    private int insertBatchSize;
    private int removeBatchSize;

    public JdbcAdaptor() {
        this.loadReservedWords();
    }

    private String createAlterTableStatement(AbstractTable table, List<AbstractColumn> columnsToAdd) {
        ArrayList ddlColumns = Lists.newArrayList();
        for (AbstractColumn column : columnsToAdd) {
            ddlColumns.add("ADD COLUMN " + this.createColumnDDL(column));
        }
        StringBuilder statement = new StringBuilder();
        statement.append("ALTER TABLE ").append(table.getQName()).append("\n\t");
        statement.append(Joiner.on((String)"\n\t").join((Iterable)ddlColumns));
        return statement.toString();
    }

    public abstract String createColumnDDL(AbstractColumn var1);

    private String createCreateTableStatement(AbstractTable table) throws SQLException {
        HashMap ddlColumns = Maps.newHashMap();
        ArrayList pkColumns = Lists.newArrayList();
        ArrayList uniqueColumns = Lists.newArrayList();
        Collection<AbstractColumn> columns = this.getColumns(table);
        for (AbstractColumn column : columns) {
            String columnDDL = this.createColumnDDL(column);
            String existingColumnDDL = (String)ddlColumns.get(column.getName());
            if (existingColumnDDL != null && !existingColumnDDL.equals(columnDDL)) {
                throw new SQLException("Table " + table.getName() + " has two columns with same name '" + column.getName() + "' but different DDL");
            }
            ddlColumns.put(column.getName(), columnDDL);
            if (column.isUnique()) {
                uniqueColumns.add(column.getName());
            }
            if (!column.isPrimaryKey()) continue;
            pkColumns.add(column.getName());
        }
        return this.createCreateTableStatement(table, ddlColumns.values(), pkColumns, uniqueColumns);
    }

    public String createCreateTableStatement(AbstractTable table, Collection<String> ddlColumns, List<String> pkColumns, List<String> uniqueColumns) {
        String columns = Joiner.on((String)",\n\t").join(ddlColumns);
        String keys = Joiner.on((String)", ").join(pkColumns);
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE TABLE ").append(table.getQName()).append(" (\n\t");
        statement.append(columns);
        if (StringUtils.isNotBlank((String)keys)) {
            statement.append(",");
            statement.append("\nPRIMARY KEY(").append(keys).append(")");
        }
        statement.append(")");
        return statement.toString();
    }

    public synchronized void createForeignKey(DataSource datasource, ForeignKey foreignKey) {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        try {
            JdbcTable tableMetadata = this.getTableMetadata(datasource, foreignKey.getTable());
            if (tableMetadata == null) {
                LOG.warn("Foreign key {0} cannot be created, table not found: ", foreignKey);
                return;
            }
            JdbcForeignKey foreignKeyMetadata = tableMetadata.getForeignKey(foreignKey.getName());
            if (foreignKeyMetadata != null) {
                if (!foreignKeyMetadata.matches(foreignKey)) {
                    String sql = this.getDropForeignKeySql(tableMetadata.getSchema(), tableMetadata.getName(), foreignKey.getName());
                    runner.update(sql);
                } else {
                    return;
                }
            }
            String referenceTableName = foreignKey.getReferencedTableQName();
            String tableName = foreignKey.getTable().getQName();
            String foreignKeyColumns = Joiner.on((String)", ").join((Iterable)Lists.transform(foreignKey.getJoinColumns(), (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    return input.getReferencedColumnName();
                }
            }));
            String keyColumns = Joiner.on((String)", ").join((Iterable)Lists.transform(foreignKey.getJoinColumns(), (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    return input.getName();
                }
            }));
            String sql = "ALTER TABLE " + tableName + "\n\tADD CONSTRAINT " + foreignKey.getName() + " FOREIGN KEY (" + keyColumns + ")" + "\n\tREFERENCES " + referenceTableName + "(" + foreignKeyColumns + ")";
            runner.update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot (re)create foreign key.");
        }
    }

    protected void createIndex(DataSource datasource, EntityTable table, String indexName, BasicColumn[] columns) throws SQLException {
        String columnNames = Joiner.on((String)", ").join((Iterable)Lists.transform((List)Lists.newArrayList((Object[])columns), (Function)new Function<BasicColumn, String>(){

            public String apply(BasicColumn input) {
                return input.getName();
            }
        }));
        new QueryRunner(datasource, this.isPmdBroken()).update("CREATE INDEX " + indexName + " ON " + table.getQName() + "(" + columnNames + ")");
    }

    private void createIndexes(DataSource datasource, AbstractTable table) {
        if (table instanceof EntityTable) {
            Map<String, BasicColumn[]> indexes = ((EntityTable)table).getIndexes();
            for (Map.Entry<String, BasicColumn[]> entry : indexes.entrySet()) {
                try {
                    this.createIndex(datasource, (EntityTable)table, entry.getKey(), entry.getValue());
                }
                catch (SQLException e) {
                    LOG.warn(e, "Cannot create index {0}", entry.getKey());
                }
            }
        }
    }

    public void createOrUpdateTable(AbstractTable table, DataSource datasource, DDLMode ddlMode) {
        try {
            if (ddlMode == DDLMode.DROP || ddlMode == DDLMode.CREATE) {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                if (tableMetadata == null) {
                    this.createTable(datasource, table);
                }
            } else if (ddlMode == DDLMode.UPDATE) {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                if (tableMetadata == null) {
                    this.createTable(datasource, table);
                } else {
                    this.updateTable(datasource, table);
                }
            }
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Table DDL Failed for table " + table.getQName());
        }
    }

    public abstract void createSequenceIfNecessary(DataSource var1, SequenceGenerator var2);

    private void createTable(DataSource datasource, AbstractTable table) {
        try {
            new QueryRunner(datasource, this.isPmdBroken()).update(this.createCreateTableStatement(table));
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create table " + table.getQName());
        }
        this.createIndexes(datasource, table);
    }

    public final void createTableGeneratorIfNecessary(DataSource datasource, TableGenerator table) {
        try {
            if (this.getTableMetadata(datasource, table.getCatalog(), table.getSchema(), table.getTable()) == null) {
                String sql = "CREATE TABLE " + table.getQName() + " (" + "\n\t" + table.getPkColumnName() + " VARCHAR(255)," + "\n\t" + table.getValueColumnName() + " INT," + "\nPRIMARY KEY(" + table.getPkColumnName() + "))";
                new QueryRunner(datasource, this.isPmdBroken()).update(sql);
            }
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create table generator " + table.getTable());
        }
    }

    public void dropAllForeignKeys(DataSource datasource, Set<AbstractTable> tableSet) {
        AbstractTable[] tables = tableSet.toArray(new AbstractTable[tableSet.size()]);
        try {
            Arrays.sort(tables, new Comparator<AbstractTable>(){

                @Override
                public int compare(AbstractTable o1, AbstractTable o2) {
                    if (o1 instanceof JoinTable && !(o2 instanceof JoinTable)) {
                        return -1;
                    }
                    if (o2 instanceof JoinTable && !(o1 instanceof JoinTable)) {
                        return 1;
                    }
                    if (o1 instanceof CollectionTable && !(o2 instanceof CollectionTable)) {
                        return -1;
                    }
                    if (o2 instanceof CollectionTable && !(o1 instanceof CollectionTable)) {
                        return 1;
                    }
                    if (o1 instanceof SecondaryTable && !(o2 instanceof SecondaryTable)) {
                        return -1;
                    }
                    if (o2 instanceof SecondaryTable && !(o1 instanceof SecondaryTable)) {
                        return 1;
                    }
                    for (ForeignKey key : o1.getForeignKeys()) {
                        if (!key.getReferencedTableQName().equals(o2.getQName())) continue;
                        return 1;
                    }
                    for (ForeignKey key : o2.getForeignKeys()) {
                        if (!key.getReferencedTableQName().equals(o2.getQName())) continue;
                        return -1;
                    }
                    return 0;
                }
            });
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e, "");
        }
        for (AbstractTable table : tables) {
            JdbcTable tableMetadata = null;
            try {
                tableMetadata = this.getTableMetadata(datasource, table);
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop foreign keys for table " + table.getName());
            }
            if (tableMetadata == null) continue;
            for (JdbcForeignKey foreignKey : tableMetadata.getForeignKeys()) {
                try {
                    new QueryRunner(datasource, this.isPmdBroken()).update(this.getDropForeignKeySql(table.getSchema(), table.getName(), foreignKey.getName()));
                }
                catch (SQLException e) {
                    this.logRelaxed(e, "Cannot drop foreign key " + foreignKey.getName());
                }
            }
        }
    }

    public void dropAllSequences(DataSource datasource, Collection<SequenceGenerator> sequences) throws SQLException {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        for (SequenceGenerator sequence : sequences) {
            try {
                this.dropSequence(runner, sequence);
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop sequence.");
            }
        }
    }

    public void dropAllTables(DataSource datasource, Collection<AbstractTable> tables) throws SQLException {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        for (AbstractTable table : tables) {
            try {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                this.tables.remove(table);
                if (tableMetadata == null) continue;
                this.dropTable(runner, table);
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop table " + table.getName());
            }
        }
        try {
            runner.update("DROP TABLE BATOO_ID");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    protected void dropSequence(QueryRunner runner, SequenceGenerator sequence) throws SQLException {
        runner.update("DROP SEQUENCE " + sequence.getQName());
    }

    protected void dropTable(QueryRunner runner, AbstractTable table) throws SQLException {
        runner.update("DROP TABLE " + table.getQName());
    }

    public String escape(String name) {
        if (name == null) {
            return null;
        }
        if (this.words.contains(name.toUpperCase(Locale.ENGLISH))) {
            return name + "_";
        }
        return name;
    }

    protected Collection<AbstractColumn> getColumns(AbstractTable table) {
        ArrayList columns = Lists.newArrayList((Object[])table.getColumns());
        Collections.sort(columns, new Comparator<AbstractColumn>(){

            @Override
            public int compare(AbstractColumn o1, AbstractColumn o2) {
                if (o1.isPrimaryKey() && !o2.isPrimaryKey()) {
                    return -1;
                }
                if (o2.isPrimaryKey() && !o1.isPrimaryKey()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return columns;
    }

    protected String getColumnType(AbstractColumn cd, int sqlType) {
        switch (sqlType) {
            case 2004: {
                return "BLOB(" + cd.getLength() + ")";
            }
            case 2005: {
                return "CLOB(" + cd.getLength() + ")";
            }
            case 12: {
                return "VARCHAR(" + cd.getLength() + ")";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -6: 
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 8: {
                return "DOUBLE" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "DECIMAL" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    public String getCurrentDate() {
        return "CURRENT_DATE";
    }

    public String getCurrentTime() {
        return "CURRENT_TIME";
    }

    public String getCurrentTimeStamp() {
        return "CURRENT_TIMESTAMP";
    }

    protected abstract String getDatabaseName();

    public String getDateTimeFunctionTemplate(DateTimeFunctionType type) {
        switch (type) {
            case SECOND: {
                return "SECOND({0})";
            }
            case MINUTE: {
                return "MINUTE({0})";
            }
            case HOUR: {
                return "HOUR({0})";
            }
            case DAYOFMONTH: {
                return "DAY_OF_MONTH({0})";
            }
            case DAYOFWEEK: {
                return "DAY_OF_WEEK({0})";
            }
            case DAYOFYEAR: {
                return "DAY_OF_YEAR({0})";
            }
            case MONTH: {
                return "MONTH({0})";
            }
            case WEEK: {
                return "WEEK({0})";
            }
        }
        return "YEAR({0})";
    }

    protected String getDropForeignKeySql(String schema, String table, String foreignKey) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object)schema, (Object)table, new Object[0]);
        return "ALTER TABLE " + qualifiedName + " DROP FOREIGN KEY " + foreignKey;
    }

    public int getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public abstract long getNextSequence(DataSource var1, String var2) throws SQLException;

    public String getNumericFunctionTemplate(NumericFunctionType type) {
        switch (type) {
            case ABS: {
                return "ABS({0})";
            }
            case LENGTH: {
                return "LENGTH({0})";
            }
            case MOD: {
                return "MOD({0}, {1})";
            }
        }
        return "SQRT({0})";
    }

    public abstract PaginationParamsOrder getPaginationParamsOrder();

    protected String getPkCreateSql(String schema, String table, Set<String> pkColumns) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object[])new String[]{schema, table});
        return "ALTER TABLE " + qualifiedName + " ADD PRIMARY KEY (" + Joiner.on((String)", ").join(pkColumns) + ")";
    }

    protected String getPkDropSql(String schema, String table, String pkName) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object[])new String[]{schema, table});
        return "ALTER TABLE " + qualifiedName + " DROP PRIMARY KEY";
    }

    public int getRemoveBatchSize() {
        return this.removeBatchSize;
    }

    public abstract String getSelectLastIdentitySql(BasicColumn var1);

    private synchronized JdbcTable getTableMetadata(DataSource datasource, AbstractTable table) throws SQLException {
        JdbcTable tableMetadata = this.tables.get(table);
        if (tableMetadata != null) {
            return tableMetadata;
        }
        tableMetadata = this.getTableMetadata(datasource, table.getCatalog(), table.getSchema(), table.getName());
        if (tableMetadata != null) {
            this.tables.put(table, tableMetadata);
        }
        return tableMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcTable getTableMetadata(DataSource datasource, String catalog, String schema, String table) throws SQLException {
        ResultSet tables;
        Connection connection;
        block4: {
            JdbcTable jdbcTable;
            connection = datasource.getConnection();
            tables = null;
            try {
                String tableName;
                DatabaseMetaData dbMetadata = connection.getMetaData();
                if (StringUtils.isBlank((String)catalog)) {
                    catalog = null;
                }
                if (StringUtils.isBlank((String)schema)) {
                    schema = null;
                }
                if (!(tables = dbMetadata.storesUpperCaseIdentifiers() ? dbMetadata.getTables(BatooUtils.upper(catalog), BatooUtils.upper(schema), BatooUtils.upper(table), TABLE_OR_VIEW) : (dbMetadata.storesLowerCaseIdentifiers() ? dbMetadata.getTables(BatooUtils.lower(catalog), BatooUtils.lower(schema), BatooUtils.lower(table), TABLE_OR_VIEW) : dbMetadata.getTables(catalog, schema, table, TABLE_OR_VIEW))).next() || !table.equalsIgnoreCase(tableName = tables.getString(TABLE_NAME))) break block4;
                jdbcTable = new JdbcTable(dbMetadata, tables);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection);
                DbUtils.closeQuietly(tables);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection);
            DbUtils.closeQuietly((ResultSet)tables);
            return jdbcTable;
        }
        DbUtils.closeQuietly((Connection)connection);
        DbUtils.closeQuietly((ResultSet)tables);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSql(ClassLoader classLoader, DataSource dataSource, String importSqlFileName) {
        String sql;
        if (StringUtils.isBlank((String)importSqlFileName)) {
            return;
        }
        InputStream is = classLoader.getResourceAsStream(importSqlFileName);
        if (is == null) {
            LOG.error("Cannot load the import sql resource: {0}", importSqlFileName);
            return;
        }
        try {
            sql = IOUtils.toString((InputStream)is);
        }
        catch (Exception e) {
            LOG.error(e, "Cannot load the import sql resource: {0}", importSqlFileName);
            return;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        LOG.info("Executing import sql: {0}", importSqlFileName);
        try {
            Connection connection = dataSource.getConnection();
            try {
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                try {
                    BufferedReader reader = new BufferedReader(new StringReader(sql));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String sqlLine = line.trim();
                        if (sqlLine.startsWith("--") || sqlLine.startsWith("//") || sqlLine.startsWith("/*")) continue;
                        Iterator statements = Splitter.on((String)";").omitEmptyStrings().split((CharSequence)sqlLine).iterator();
                        while (statements.hasNext()) {
                            try {
                                statement.execute((String)statements.next());
                            }
                            catch (SQLException e) {
                                LOG.error("Error executing sql import fragment: {0}", sqlLine);
                                throw e;
                            }
                        }
                    }
                    connection.setAutoCommit(true);
                }
                finally {
                    DbUtils.closeQuietly((Statement)statement);
                }
            }
            finally {
                DbUtils.closeQuietly((Connection)connection);
            }
        }
        catch (Exception e) {
            LOG.error(e, "Error executing import sql: {0}", importSqlFileName);
        }
        LOG.info("Import successful.");
    }

    public boolean isPmdBroken() {
        return false;
    }

    private void loadReservedWords() throws MappingException {
        String packageName = this.getClass().getPackage().getName().replaceAll("\\.", "/");
        String name = this.getDatabaseName();
        try {
            String fileName = packageName + "/" + name.toLowerCase(Locale.ENGLISH) + ".words";
            List words = IOUtils.readLines((InputStream)this.getClass().getClassLoader().getResourceAsStream(fileName));
            this.words = Lists.transform((List)words, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toUpperCase(Locale.ENGLISH);
                }
            });
        }
        catch (IOException e) {
            throw new MappingException("Broken JDBC Adapter " + this.getClass().getSimpleName() + ". Reserved words for the adapter cannot be loaded", new AbstractLocator[0]);
        }
    }

    protected void logRelaxed(SQLException e, String message) {
        LOG.warn(message + " Check debug log for details: " + e.getMessage());
        LOG.debug(e, message);
    }

    public boolean modifiesParameters() {
        return false;
    }

    public void modifyParameters(ParameterMetaData pmd, Object[] params) {
    }

    public abstract boolean paginationNeedsMaxResultsAlways();

    public abstract boolean paginationNeedsStartAlways();

    public boolean parameterizedPagination() {
        return true;
    }

    protected String qualified(String schema, String jdbcClassName) {
        if (StringUtils.isBlank((String)schema)) {
            return jdbcClassName;
        }
        return schema + "." + jdbcClassName;
    }

    public void setInsertBatchSize(int insertBatchSize) {
        this.insertBatchSize = insertBatchSize;
    }

    public void setRemoveBatchSize(int removeBatchSize) {
        this.removeBatchSize = removeBatchSize;
    }

    public abstract IdType supports(GenerationType var1);

    public boolean supportsNamedParams() {
        return true;
    }

    public boolean supportsOrdinalParams() {
        return true;
    }

    private void updateTable(DataSource datasource, AbstractTable table) {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        try {
            JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
            HashSet columnsFound = Sets.newHashSet();
            ArrayList columnsToAdd = Lists.newArrayList();
            for (AbstractColumn column : table.getColumns()) {
                JdbcColumn columnMetadata = tableMetadata.getColumn(column.getName());
                if (columnMetadata == null) {
                    columnsToAdd.add(column);
                    continue;
                }
                columnsFound.add(column.getName());
            }
            tableMetadata.logNotNullExtraColumns(table.getColumnNames());
            boolean pkDropped = false;
            if (tableMetadata.requiresPkDrop(table.getPkColumnNames())) {
                try {
                    runner.update(this.getPkDropSql(tableMetadata.getSchema(), table.getName(), tableMetadata.getPkName()));
                    pkDropped = true;
                }
                catch (SQLException e) {
                    LOG.error(e, "Cannot drop the primary key for table {0}. Primary key changes will not be reflected!", table.getName());
                }
            }
            if (columnsToAdd.size() > 0) {
                runner.update(this.createAlterTableStatement(table, columnsToAdd));
            }
            this.createIndexes(datasource, table);
            if (pkDropped) {
                runner.update(this.getPkCreateSql(tableMetadata.getSchema(), table.getName(), table.getPkColumnNames()));
            }
        }
        catch (SQLException e) {
            LOG.error(e, "Unable to update table {0}", table.getName());
        }
    }

    public static enum PaginationParamsOrder {
        SQL_START_MAX(true),
        SQL_MAX_START(true),
        SQL_START_END(true),
        SQL_END_START(true),
        MAX_START_SQL(false),
        START_MAX_SQL(false);

        private final boolean afterMainSql;

        private PaginationParamsOrder(boolean afterMainSql) {
            this.afterMainSql = afterMainSql;
        }

        public boolean isAfterMainSql() {
            return this.afterMainSql;
        }
    }
}

