/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.sql.DataSource;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;

public class PostgreSqlAdaptor
extends JdbcAdaptor {
    private static final String[] PRODUCT_NAMES = new String[]{"PostgreSQL"};

    @Override
    public String applyConcat(List<String> arguments) {
        return Joiner.on((String)" || ").join(arguments);
    }

    @Override
    public String applyLikeEscape(String escapePattern) {
        return " {ESCAPE " + escapePattern + "}";
    }

    @Override
    public String applyLock(String sql, LockModeType lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_READ: {
                return sql + "\nFOR READ ONLY";
            }
            case PESSIMISTIC_WRITE: {
                return sql + "\nFOR UPDATE";
            }
        }
        return sql;
    }

    @Override
    public String applyPagination(String sql, int startPosition, int maxResult) {
        if (startPosition != 0) {
            sql = sql + "\nOFFSET " + startPosition + " ROWS";
        }
        if (maxResult != Integer.MAX_VALUE) {
            sql = sql + "\nFETCH FIRST " + maxResult + " ROWS ONLY";
        }
        return sql;
    }

    @Override
    public String createColumnDDL(AbstractColumn column) {
        return column.getName() + " " + this.getColumnType(column, column.getSqlType()) + (!column.isNullable() ? " NOT NULL" : "") + (column.isUnique() ? " UNIQUE" : "");
    }

    @Override
    public void createSequenceIfNecessary(DataSource datasource, SequenceGenerator sequence) {
        String sql = "CREATE SEQUENCE " + sequence.getSequenceName() + " START WITH " + sequence.getInitialValue() + " INCREMENT BY " + sequence.getAllocationSize();
        try {
            new QueryRunner(datasource).update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create sequence " + sequence.getName());
        }
    }

    @Override
    protected void dropTable(QueryRunner runner, AbstractTable table) throws SQLException {
        runner.update("DROP TABLE " + table.getQName() + " CASCADE");
    }

    @Override
    protected String getColumnType(AbstractColumn cd, int sqlType) {
        if (cd.getIdType() == IdType.IDENTITY) {
            return "SERIAL";
        }
        switch (sqlType) {
            case 2004: 
            case 2005: {
                return "BYTEA";
            }
            case 12: {
                return "VARCHAR(" + cd.getLength() + ")";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -6: 
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 8: {
                return "DOUBLE PRECISION" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "DECIMAL" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    @Override
    protected String getDatabaseName() {
        return "PgSql";
    }

    @Override
    protected String getDropForeignKeySql(String schema, String table, String foreignKey) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object)schema, (Object)table, new Object[0]);
        return "ALTER TABLE " + qualifiedName + " DROP CONSTRAINT " + foreignKey;
    }

    @Override
    public long getNextSequence(DataSource datasource, String sequenceName) throws SQLException {
        return ((Number)new QueryRunner(datasource).query("SELECT NEXTVAL('" + sequenceName + "')", new SingleValueHandler())).longValue();
    }

    @Override
    public JdbcAdaptor.PaginationParamsOrder getPaginationParamsOrder() {
        return JdbcAdaptor.PaginationParamsOrder.SQL_START_MAX;
    }

    @Override
    protected String[] getProductNames() {
        return PRODUCT_NAMES;
    }

    @Override
    public String getSelectLastIdentitySql(BasicColumn identityColumn) {
        return "SELECT CURRVAL('" + identityColumn.getTable().getQName() + "_" + identityColumn.getName() + "_seq')";
    }

    @Override
    public boolean paginationNeedsMaxResultsAlways() {
        return false;
    }

    @Override
    public boolean paginationNeedsStartAlways() {
        return false;
    }

    @Override
    public boolean parameterizedPagination() {
        return false;
    }

    @Override
    public IdType supports(GenerationType type) {
        if (type == null) {
            return IdType.SEQUENCE;
        }
        switch (type) {
            case IDENTITY: {
                return IdType.IDENTITY;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case TABLE: {
                return IdType.TABLE;
            }
        }
        return IdType.SEQUENCE;
    }
}

