/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.sql.DataSource;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.NumericFunctionType;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;

public class SawSqlAdaptor
extends JdbcAdaptor {
    private static final String[] PRODUCT_NAMES = new String[]{"SQL Anywhere"};

    @Override
    public String applyConcat(List<String> arguments) {
        return "(" + Joiner.on((String)" + ").join(arguments) + ")";
    }

    @Override
    public String applyLikeEscape(String escapePattern) {
        return " ESCAPE " + escapePattern;
    }

    @Override
    public String applyLock(String sql, LockModeType lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_READ: {
                return sql + "\nFOR READ ONLY";
            }
            case PESSIMISTIC_WRITE: {
                return sql + "\nFOR UPDATE";
            }
        }
        return sql;
    }

    @Override
    public String applyPagination(String sql, int startPosition, int maxResult) {
        String orderby;
        if (startPosition == 0) {
            return sql.replaceFirst("SELECT", "SELECT TOP " + maxResult);
        }
        StringBuffer sqlStr = new StringBuffer(sql = BatooUtils.indent(sql));
        int orderIndex = sqlStr.indexOf("ORDER BY");
        CharSequence charSequence = orderby = orderIndex > -1 ? sqlStr.subSequence(orderIndex, sqlStr.length()) : "ORDER BY CURRENT_TIMESTAMP";
        if (orderIndex > -1) {
            sqlStr.delete(orderIndex, sqlStr.length());
        }
        int fromIndex = sqlStr.indexOf("FROM");
        sqlStr.insert(fromIndex, "\t, ROW_NUMBER() OVER (" + orderby + ") AS ROW_NUM__INTERNAL ");
        if (maxResult == Integer.MAX_VALUE) {
            return "SELECT * FROM (\n" + sqlStr + "\n) AS PAGINATED_RESULT WHERE ROW_NUM__INTERNAL > ? ORDER BY ROW_NUM__INTERNAL";
        }
        return "SELECT * FROM (\n" + sqlStr + ")\nAS PAGINATED_RESULT WHERE ROW_NUM__INTERNAL > ? AND ROW_NUM__INTERNAL < ? ORDER BY ROW_NUM__INTERNAL";
    }

    @Override
    public String applySubStr(String innerFragment, String startFragment, String endFragment) {
        if (endFragment != null) {
            return "SUBSTRING(" + Joiner.on((String)", ").skipNulls().join(new Object[]{innerFragment, startFragment, endFragment}) + ")";
        }
        return "SUBSTRING(" + Joiner.on((String)", ").skipNulls().join(new Object[]{innerFragment, startFragment, Integer.toString(Integer.MAX_VALUE)}) + ")";
    }

    @Override
    public String applyTrim(CriteriaBuilder.Trimspec trimspec, String trimChar, String argument) {
        if (trimChar != null) {
            throw new PersistenceException("MSSQL Server does not support trim character");
        }
        if (trimspec == null) {
            trimspec = CriteriaBuilder.Trimspec.BOTH;
        }
        switch (trimspec) {
            case LEADING: {
                return "LTRIM(" + argument + ")";
            }
            case TRAILING: {
                return "RTRIM(" + argument + ")";
            }
        }
        return "RTRIM(LTRIM(" + argument + "))";
    }

    @Override
    public String castBoolean(String sqlFragment) {
        return super.castBoolean(sqlFragment) + " = 1";
    }

    @Override
    public String createColumnDDL(AbstractColumn column) {
        boolean identity = column.getIdType() == IdType.IDENTITY;
        return column.getName() + " " + this.getColumnType(column, column.getSqlType()) + (!column.isNullable() ? " NOT NULL" : "") + (column.isUnique() ? " UNIQUE" : "") + (identity ? " IDENTITY(1,1)" : "");
    }

    @Override
    public void createSequenceIfNecessary(DataSource datasource, SequenceGenerator sequence) {
        String sql = "CREATE SEQUENCE " + sequence.getSequenceName() + " START WITH " + sequence.getInitialValue() + " INCREMENT BY " + sequence.getAllocationSize();
        try {
            new QueryRunner(datasource).update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create sequence " + sequence.getName());
        }
    }

    @Override
    protected String getColumnType(AbstractColumn cd, int sqlType) {
        switch (sqlType) {
            case 2004: {
                return "VARBINARY(" + cd.getLength() + ")";
            }
            case 2005: {
                return "NVARCHAR(" + cd.getLength() + ")";
            }
            case 12: {
                return "NVARCHAR(" + cd.getLength() + ")";
            }
            case 91: 
            case 92: 
            case 93: {
                return "DATE";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: 
            case 8: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "DECIMAL" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    @Override
    public String getCurrentDate() {
        return "GETDATE()";
    }

    @Override
    public String getCurrentTime() {
        return "GETDATE()";
    }

    @Override
    public String getCurrentTimeStamp() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    protected String getDatabaseName() {
        return "MsSql";
    }

    @Override
    public long getNextSequence(DataSource datasource, String sequenceName) throws SQLException {
        return ((Number)new QueryRunner(datasource).query("SELECT " + sequenceName + ".NEXTVAL", new SingleValueHandler())).longValue();
    }

    @Override
    public String getNumericFunctionTemplate(NumericFunctionType type) {
        if (type == NumericFunctionType.MOD) {
            return "{0} % {1}";
        }
        if (type == NumericFunctionType.LENGTH) {
            return "LEN({0})";
        }
        return super.getNumericFunctionTemplate(type);
    }

    @Override
    public JdbcAdaptor.PaginationParamsOrder getPaginationParamsOrder() {
        return JdbcAdaptor.PaginationParamsOrder.SQL_START_END;
    }

    @Override
    protected String[] getProductNames() {
        return PRODUCT_NAMES;
    }

    @Override
    public String getSelectLastIdentitySql(BasicColumn identityColumn) {
        return "SELECT @@IDENTITY";
    }

    @Override
    public boolean isPmdBroken() {
        return true;
    }

    @Override
    public boolean paginationNeedsMaxResultsAlways() {
        return true;
    }

    @Override
    public boolean paginationNeedsStartAlways() {
        return false;
    }

    @Override
    public IdType supports(GenerationType type) {
        if (type == null) {
            return IdType.SEQUENCE;
        }
        switch (type) {
            case IDENTITY: {
                return IdType.SEQUENCE;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case TABLE: {
                return IdType.TABLE;
            }
        }
        return IdType.SEQUENCE;
    }
}

