/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.extension;

import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.SocketMetadata;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class MySqlNioSocketFactory
implements SocketFactory,
SocketMetadata {
    private static final String TCP_NO_DELAY_PROPERTY_NAME = "tcpNoDelay";
    private static final String TCP_KEEP_ALIVE_DEFAULT_VALUE = "true";
    private static final String TCP_KEEP_ALIVE_PROPERTY_NAME = "tcpKeepAlive";
    private static final String TCP_RCV_BUF_PROPERTY_NAME = "tcpRcvBuf";
    private static final String TCP_SND_BUF_PROPERTY_NAME = "tcpSndBuf";
    private static final String TCP_TRAFFIC_CLASS_PROPERTY_NAME = "tcpTrafficClass";
    private static final String TCP_RCV_BUF_DEFAULT_VALUE = "0";
    private static final String TCP_SND_BUF_DEFAULT_VALUE = "0";
    private static final String TCP_TRAFFIC_CLASS_DEFAULT_VALUE = "0";
    private static final String TCP_NO_DELAY_DEFAULT_VALUE = "true";
    private static Method setTraficClassMethod;
    protected String host = null;
    protected int port = 3306;
    protected Socket rawSocket = null;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    private void configureSocket(Properties props) throws SocketException, IOException {
        try {
            int trafficClass;
            int sendBufferSize;
            int receiveBufferSize;
            this.rawSocket.setTcpNoDelay(Boolean.valueOf(props.getProperty(TCP_NO_DELAY_PROPERTY_NAME, "true")));
            String keepAlive = props.getProperty(TCP_KEEP_ALIVE_PROPERTY_NAME, "true");
            if (keepAlive != null && keepAlive.length() > 0) {
                this.rawSocket.setKeepAlive(Boolean.valueOf(keepAlive));
            }
            if ((receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"))) > 0) {
                this.rawSocket.setReceiveBufferSize(receiveBufferSize);
            }
            if ((sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"))) > 0) {
                this.rawSocket.setSendBufferSize(sendBufferSize);
            }
            if ((trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"))) > 0 && setTraficClassMethod != null) {
                setTraficClassMethod.invoke((Object)this.rawSocket, trafficClass);
            }
        }
        catch (Throwable t) {
            this.unwrapExceptionToProperClassAndThrowIt(t);
        }
    }

    public Socket connect(String hostname, int portNumber, Properties properties) throws SocketException, IOException {
        if (properties != null) {
            this.host = hostname;
            this.port = portNumber;
            Object connectWithTimeoutMethod = null;
            Object socketBindMethod = null;
            String localSocketHostname = properties.getProperty("localSocketAddress");
            String connectTimeoutStr = properties.getProperty("connectTimeout");
            boolean wantsTimeout = connectTimeoutStr != null && connectTimeoutStr.length() > 0 && !connectTimeoutStr.equals("0");
            boolean wantsLocalBind = localSocketHostname != null && localSocketHostname.length() > 0;
            boolean needsConfigurationBeforeConnect = this.socketNeedsConfigurationBeforeConnect(properties);
            if (wantsTimeout || wantsLocalBind || needsConfigurationBeforeConnect) {
                if (connectTimeoutStr != null) {
                    try {
                        Integer.parseInt(connectTimeoutStr);
                    }
                    catch (NumberFormatException nfe) {
                        throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                    }
                }
                if (wantsLocalBind && socketBindMethod == null) {
                    throw new SocketException("Can't specify \"localSocketAddress\" on JVMs older than 1.4");
                }
                if (wantsTimeout && connectWithTimeoutMethod == null) {
                    throw new SocketException("Can't specify \"connectTimeout\" on JVMs older than 1.4");
                }
            }
            if (!(wantsLocalBind || wantsTimeout || needsConfigurationBeforeConnect)) {
                InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                Exception caughtWhileConnecting = null;
                for (InetAddress possibleAddress : possibleAddresses) {
                    try {
                        SocketChannel socketChannel = SocketChannel.open();
                        socketChannel.connect(new InetSocketAddress(possibleAddress, this.port));
                        this.rawSocket = socketChannel.socket();
                        this.configureSocket(properties);
                        break;
                    }
                    catch (Exception ex) {
                        caughtWhileConnecting = ex;
                    }
                }
                if (this.rawSocket == null) {
                    this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                }
                return this.rawSocket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isLocallyConnected(ConnectionImpl conn) throws SQLException {
        long threadId = conn.getId();
        Statement processListStmt = conn.getMetadataSafeStatement();
        ResultSet rs = null;
        try {
            String processHost = null;
            rs = processListStmt.executeQuery("SHOW PROCESSLIST");
            while (rs.next()) {
                long id = rs.getLong(1);
                if (threadId != id) continue;
                processHost = rs.getString(3);
                break;
            }
            if (processHost != null && processHost.indexOf(":") != -1) {
                processHost = processHost.split(":")[0];
                try {
                    boolean isLocal;
                    boolean bl = isLocal = InetAddress.getByName(processHost).equals(this.rawSocket.getLocalAddress());
                    return bl;
                }
                catch (UnknownHostException e) {
                    conn.getLog().logWarn((Object)Messages.getString((String)"Connection.CantDetectLocalConnect", (Object[])new Object[]{this.host}), (Throwable)e);
                    boolean bl = false;
                    processListStmt.close();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            processListStmt.close();
        }
    }

    private boolean socketNeedsConfigurationBeforeConnect(Properties props) {
        int receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"));
        if (receiveBufferSize > 0) {
            return true;
        }
        int sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"));
        if (sendBufferSize > 0) {
            return true;
        }
        int trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"));
        return trafficClass > 0 && setTraficClassMethod != null;
    }

    private void unwrapExceptionToProperClassAndThrowIt(Throwable error) throws SocketException, IOException {
        if (error instanceof InvocationTargetException) {
            error = ((InvocationTargetException)error).getTargetException();
        }
        if (error instanceof SocketException) {
            throw (SocketException)error;
        }
        if (error instanceof IOException) {
            throw (IOException)error;
        }
        throw new SocketException(error.toString());
    }

    static {
        try {
            setTraficClassMethod = Socket.class.getMethod("setTrafficClass", Integer.TYPE);
        }
        catch (SecurityException e) {
            setTraficClassMethod = null;
        }
        catch (NoSuchMethodException e) {
            setTraficClassMethod = null;
        }
    }
}

