/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl;

import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.batoo.common.BatooException;
import org.batoo.jpa.parser.impl.orm.OrmContentHandler;
import org.batoo.jpa.parser.metadata.Metadata;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OrmParser {
    private final XMLReader reader;
    private final String fileName;
    private final OrmContentHandler handler;

    public OrmParser(String fileName) {
        this.fileName = fileName;
        this.handler = new OrmContentHandler(this.fileName);
        try {
            this.reader = this.createReader();
        }
        catch (Exception e) {
            throw new BatooException("Unable to initialize ORM Parser", e);
        }
        this.reader.setContentHandler(this.handler);
    }

    public void consume(InputStream is) {
        try {
            this.reader.parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new BatooException("Unable to parse ORM XML File " + this.fileName, e);
        }
    }

    private XMLReader createReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        return parserFactory.newSAXParser().getXMLReader();
    }

    public Metadata getMetadata() {
        return this.handler.getMetadata();
    }
}

