/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.JoinColumn;
import javax.persistence.UniqueConstraint;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.JoinColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.UniqueConstraintMetadataImpl;
import org.batoo.jpa.parser.metadata.CollectionTableMetadata;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class CollectionTableMetadataImpl
implements CollectionTableMetadata {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private final String name;
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();
    private final List<JoinColumnMetadata> joinColumns = Lists.newArrayList();

    public CollectionTableMetadataImpl(AbstractLocator locator, CollectionTable annotation) {
        this.locator = locator;
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.name = annotation.name();
        for (UniqueConstraint uniqueConstraint : annotation.uniqueConstraints()) {
            this.uniqueConstraints.add(new UniqueConstraintMetadataImpl(locator, uniqueConstraint));
        }
        for (UniqueConstraint uniqueConstraint : annotation.joinColumns()) {
            this.joinColumns.add(new JoinColumnMetadataImpl(this.locator, (JoinColumn)uniqueConstraint));
        }
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public List<JoinColumnMetadata> getJoinColumns() {
        return this.joinColumns;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }
}

