/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.UniqueConstraintMetadataImpl;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class TableMetadataImpl
implements TableMetadata {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private final String name;
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();

    public TableMetadataImpl(AbstractLocator locator, Table annotation) {
        this.locator = locator;
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.name = annotation.name();
        for (UniqueConstraint constraint : annotation.uniqueConstraints()) {
            this.uniqueConstraints.add(new UniqueConstraintMetadataImpl(locator, constraint));
        }
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }
}

