/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.LockModeType;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.HintElement;
import org.batoo.jpa.parser.impl.orm.LockModeElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.QueryElement;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class NamedQueryElement
extends ParentElement
implements NamedQueryMetadata {
    private String name;
    private String query;
    private LockModeType lockMode;
    private final Map<String, Object> hints = Maps.newHashMap();

    public NamedQueryElement(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "query", "hint", "lock-mode");
    }

    @Override
    protected void generate() {
        this.name = this.getAttribute("name", "");
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public LockModeType getLockMode() {
        return this.lockMode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof HintElement) {
            this.hints.put(((HintElement)child).getName(), ((HintElement)child).getValue());
        }
        if (child instanceof QueryElement) {
            this.query = ((QueryElement)child).getQuery();
        }
        if (child instanceof LockModeElement) {
            this.lockMode = ((LockModeElement)child).getLockMode();
        }
    }
}

