/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.type;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EntityListenersElement;
import org.batoo.jpa.parser.impl.orm.EntityMappings;
import org.batoo.jpa.parser.impl.orm.ExcludeDefaultListenersElement;
import org.batoo.jpa.parser.impl.orm.ExcludeSuperclassListenersElement;
import org.batoo.jpa.parser.impl.orm.IdClassElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.attribute.AttributesElement;
import org.batoo.jpa.parser.metadata.CallbackMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.type.MappedSuperclassMetadata;

public class MappedSuperclassElementFactory
extends ParentElement
implements MappedSuperclassMetadata {
    private String className;
    private boolean metadataComplete;
    private AccessType accessType;
    private AttributesElement attrs;
    private String idClass;
    private boolean excludeDefaultListeners;
    private boolean excludeSuperclassListeners;
    private final List<EntityListenerMetadata> listeners = Lists.newArrayList();
    private final List<CallbackMetadata> callbacks = Lists.newArrayList();

    public MappedSuperclassElementFactory(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "attributes", "id-class", "entity-listeners", "pre-persist", "pre-remove", "pre-update", "post-load", "post-persist", "post-remove", "post-update", "exclude-default-listeners", "exclude-superclass-listeners");
    }

    @Override
    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    @Override
    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    @Override
    protected void generate() {
        this.className = this.getAttribute("class", "");
        this.metadataComplete = this.getAttribute("metadata-complete", false);
        this.accessType = this.getAttribute("access") != null ? AccessType.valueOf((String)this.getAttribute("access")) : null;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType != null ? this.accessType : ((EntityMappings)this.getParent()).getAccessType();
    }

    @Override
    public AttributesElement getAttributes() {
        return this.attrs;
    }

    @Override
    public List<CallbackMetadata> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public List<EntityListenerMetadata> getListeners() {
        return this.listeners;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof AttributesElement) {
            this.attrs = (AttributesElement)child;
        }
        if (child instanceof IdClassElement) {
            this.idClass = ((IdClassElement)child).getIdClass();
        }
        if (child instanceof EntityListenersElement) {
            this.listeners.addAll(((EntityListenersElement)child).getListeners());
        }
        if (child instanceof CallbackMetadata) {
            this.callbacks.add((CallbackMetadata)((Object)this.callbacks));
        }
        if (child instanceof ExcludeDefaultListenersElement) {
            this.excludeDefaultListeners = true;
        }
        if (child instanceof ExcludeSuperclassListenersElement) {
            this.excludeSuperclassListeners = true;
        }
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }
}

