/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.collections;

import java.util.ListIterator;
import org.batoo.common.collections.FastLinkedList;

public class FastLinkedListIterator<E>
implements ListIterator<E> {
    private final FastLinkedList<E> list;
    private final boolean forward;
    private FastLinkedList.FastLinkedListNode<E> lastReturned;
    private FastLinkedList.FastLinkedListNode<E> next;
    private int nextIndex;

    FastLinkedListIterator(FastLinkedList<E> list, int index, boolean forward) {
        this.list = list;
        this.forward = forward;
        this.next = index == this.list.size ? null : this.list.node(index);
        this.nextIndex = index;
    }

    @Override
    public void add(E e) {
        this.lastReturned = null;
        if (this.next == null) {
            this.list.linkLast(e);
        } else {
            this.list.linkBefore(e, this.next);
        }
        ++this.nextIndex;
    }

    @Override
    public boolean hasNext() {
        if (this.forward) {
            return this.nextIndex < this.list.size;
        }
        return this.nextIndex > 0;
    }

    @Override
    public boolean hasPrevious() {
        if (this.forward) {
            return this.nextIndex > 0;
        }
        return this.nextIndex < this.list.size;
    }

    @Override
    public E next() {
        if (this.forward) {
            return this.realNext();
        }
        return this.realPrevious();
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        if (this.forward) {
            return this.realPrevious();
        }
        return this.realNext();
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    private E realNext() {
        FastLinkedList.FastLinkedListNode<E> next = this.next;
        this.lastReturned = next;
        this.next = this.next.next;
        ++this.nextIndex;
        return next.item;
    }

    private E realPrevious() {
        this.next = this.next == null ? this.list.last : this.next.prev;
        this.lastReturned = this.next;
        --this.nextIndex;
        return this.lastReturned.item;
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        FastLinkedList.FastLinkedListNode lastNext = this.lastReturned.next;
        this.list.unlink(this.lastReturned);
        if (this.next == this.lastReturned) {
            this.next = lastNext;
        } else {
            --this.nextIndex;
        }
        this.lastReturned = null;
    }

    @Override
    public void set(E e) {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        this.lastReturned.item = e;
    }
}

