/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.log;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ToStringBuilder
extends ReflectionToStringBuilder {
    private static final ToStringStyle LONG = new LongToStringStyle();
    private static final ToStringStyle SHORT = new ShortToStringStyle();
    private static ThreadLocal<DetailLevel> level = new ThreadLocal();
    private static ThreadLocal<String> indent = new ThreadLocal();

    private static ToStringStyle getStyle(DetailLevel level) {
        if (level == null || level == DetailLevel.SHORT) {
            return SHORT;
        }
        return LONG;
    }

    public static void setDetailLevel(DetailLevel level) {
        ToStringBuilder.level.set(level);
    }

    public ToStringBuilder(Object object) {
        super(object, ToStringBuilder.getStyle(level.get()));
    }

    public ToStringBuilder(Object object, DetailLevel level) {
        super(object, ToStringBuilder.getStyle(level));
    }

    public ToStringBuilder excludeFieldNames(String ... fieldNames) {
        super.setExcludeFieldNames(fieldNames);
        return this;
    }

    private static final class ShortToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart(" [");
            this.setFieldSeparator(", ");
            this.setContentEnd("]");
        }
    }

    private static final class LongToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        LongToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart(" [");
            this.setFieldSeparator(SystemUtils.LINE_SEPARATOR);
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd("]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void appendDetail(StringBuffer buffer, String fieldName, Collection coll) {
            String indent = this.indent();
            buffer.append("{");
            try {
                Iterator i = coll.iterator();
                while (i.hasNext()) {
                    buffer.append(SystemUtils.LINE_SEPARATOR);
                    buffer.append(indent);
                    buffer.append("  ");
                    buffer.append(i.next());
                    if (!i.hasNext()) continue;
                    buffer.append(",");
                }
            }
            finally {
                indent.set(((String)indent.get()).substring(2));
            }
            buffer.append("}");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void appendDetail(StringBuffer buffer, String fieldName, Map map) {
            String indent = this.indent();
            buffer.append("{");
            try {
                Iterator i = map.entrySet().iterator();
                while (i.hasNext()) {
                    buffer.append(SystemUtils.LINE_SEPARATOR);
                    buffer.append(indent);
                    buffer.append("  ");
                    Map.Entry entry = i.next();
                    buffer.append(entry.getKey());
                    buffer.append("=");
                    buffer.append(entry.getValue());
                    if (!i.hasNext()) continue;
                    buffer.append(",");
                }
            }
            finally {
                indent.set(((String)indent.get()).substring(2));
            }
            buffer.append("}");
        }

        public void appendEnd(StringBuffer buffer, Object object) {
            String indent = (String)indent.get();
            indent.set(indent.length() == 0 ? null : indent.substring(2));
            super.appendEnd(buffer, object);
        }

        protected void appendFieldStart(StringBuffer buffer, String fieldName) {
            buffer.append((String)indent.get());
            super.appendFieldStart(buffer, fieldName);
        }

        public void appendStart(StringBuffer buffer, Object object) {
            this.indent();
            super.appendStart(buffer, object);
        }

        private String indent() {
            String indent = (String)indent.get();
            indent.set(indent != null ? indent + "  " : "");
            return indent;
        }
    }

    public static enum DetailLevel {
        SHORT,
        LONG;

    }
}

