/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class AggregationExpression<T>
extends AbstractExpression<T> {
    private final AggregationFunctionType type;
    private final AbstractExpression<?> x;
    private String alias;

    public AggregationExpression(AggregationFunctionType type, Expression<?> x) {
        super(x.getJavaType());
        this.type = type;
        this.x = (AbstractExpression)x;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return MessageFormat.format(this.type.jpqlFragment, this.x.generateJpqlRestriction(query));
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{MessageFormat.format(this.type.sqlFragment, this.x.getSqlRestrictionFragments(query)[0])};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        if (this.getJavaType() == Long.class) {
            return (T)Long.valueOf(row.getLong(this.alias));
        }
        if (this.getJavaType() == Double.class) {
            return (T)Double.valueOf(row.getDouble(this.alias));
        }
        return (T)row.getObject(this.alias);
    }

    public static enum AggregationFunctionType {
        AVG("AVG({0})", "avg({0})"),
        SUM("SUM({0})", "sum({0})"),
        MIN("MIN({0})", "min({0})"),
        MAX("MAX({0})", "max({0})");

        private final String sqlFragment;
        private final String jpqlFragment;

        private AggregationFunctionType(String sqlfragment, String jpqlFragment) {
            this.sqlFragment = sqlfragment;
            this.jpqlFragment = jpqlFragment;
        }
    }
}

