/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CaseTransformationExpression
extends AbstractExpression<String> {
    private final AbstractExpression<?> inner;
    private String alias;
    private final CaseTransformationType function;

    public CaseTransformationExpression(Expression<String> inner, CaseTransformationType function) {
        super(String.class);
        this.inner = (AbstractExpression)inner;
        this.function = function;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return MessageFormat.format(this.function.jpqlFragment, this.inner.generateJpqlRestriction(query));
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    private String generateSqlRestriction(BaseQueryImpl<?> query) {
        return MessageFormat.format(this.function.sqlFragment, this.inner.getSqlRestrictionFragments(query)[0]);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.generateSqlRestriction(query) + " AS " + this.alias;
        }
        return this.generateSqlRestriction(query);
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{this.generateSqlRestriction(query)};
    }

    @Override
    public String handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (String)row.getObject(this.alias);
    }

    public static enum CaseTransformationType {
        UPPER("UPPER({0})", "upper({0})"),
        LOWER("LOWER({0})", "lower{0}");

        private final String sqlFragment;
        private final String jpqlFragment;

        private CaseTransformationType(String sqlfragment, String jpqlFragment) {
            this.sqlFragment = sqlfragment;
            this.jpqlFragment = jpqlFragment;
        }
    }
}

