/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CastExpression<T>
extends AbstractExpression<T> {
    private String alias;
    private final AbstractExpression<?> inner;

    public CastExpression(AbstractExpression<?> inner, Class<T> javaType) {
        super(javaType);
        this.inner = inner;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "cast(" + this.inner.generateJpqlRestriction(query) + ", " + this.getJavaType().getSimpleName().toLowerCase(Locale.ENGLISH) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{query.getJdbcAdaptor().applyCast(this.inner.getSqlRestrictionFragments(query)[0], this.getJavaType())};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }
}

