/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.persistence.PersistenceException;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;

public class CollectionExpression<C extends Collection<E>, E>
extends AbstractExpression<C> {
    private final ParentPath<?, ?> parentPath;
    private final AbstractMapping<?, Collection<E>, E> abstractMapping;

    public CollectionExpression(ParentPath<?, ?> parentPath, AbstractMapping<?, Collection<E>, E> mapping) {
        super(mapping.getJavaType());
        this.parentPath = parentPath;
        this.abstractMapping = mapping;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return this.parentPath.generateJpqlRestriction(query) + "." + this.abstractMapping.getAttribute().getName();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection paths cannot be selected: " + this);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection paths cannot be selected: " + this);
    }

    public AbstractMapping<?, Collection<E>, E> getMapping() {
        return this.abstractMapping;
    }

    public ParentPath<?, ?> getParentPath() {
        return this.parentPath;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        throw new PersistenceException("Collection paths cannot be restricted: " + this);
    }

    @Override
    public C handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return null;
    }

    public String toString() {
        return "CollectionExpression [parentPath=" + this.parentPath + ", abstractMapping=" + this.abstractMapping + "]";
    }
}

