/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class IsNullExpression
extends AbstractExpression<Boolean> {
    private final AbstractExpression<?> inner;
    private final boolean not;
    private String alias;

    public IsNullExpression(boolean not, AbstractExpression<?> inner) {
        super(Boolean.class);
        this.not = not;
        this.inner = inner;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        if (this.not) {
            return this.inner.generateJpqlRestriction(query) + " is not null";
        }
        return this.inner.generateJpqlRestriction(query) + " is null";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        if (this.not) {
            return new String[]{this.inner.getSqlRestrictionFragments(query)[0] + " IS NOT NULL"};
        }
        return new String[]{this.inner.getSqlRestrictionFragments(query)[0] + " IS NULL"};
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Boolean)row.getObject(this.alias);
    }
}

