/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class LikeExpression
extends AbstractExpression<Boolean> {
    private final AbstractExpression<String> inner;
    private final AbstractExpression<String> pattern;
    private final AbstractExpression<Character> escape;
    private String alias;
    private final boolean not;

    public LikeExpression(Expression<String> inner, Expression<String> pattern, Expression<Character> escape, boolean not) {
        super(Boolean.class);
        this.inner = (AbstractExpression)inner;
        this.pattern = (AbstractExpression)pattern;
        this.escape = (AbstractExpression)escape;
        this.not = not;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.inner.generateJpqlRestriction(query));
        if (this.not) {
            builder.append(" not");
        }
        builder.append(" like ");
        builder.append(this.pattern.generateJpqlRestriction(query));
        if (this.escape != null) {
            builder.append(" escape ");
            builder.append(this.escape.generateJpqlRestriction(query));
        }
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.inner.getSqlRestrictionFragments(query)[0]);
        if (this.not) {
            builder.append(" NOT");
        }
        builder.append(" LIKE ");
        builder.append(this.pattern.getSqlRestrictionFragments(query)[0]);
        if (this.escape != null) {
            builder.append(query.getJdbcAdaptor().applyLikeEscape(this.escape.getSqlRestrictionFragments(query)[0]));
        }
        return new String[]{builder.toString()};
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Boolean)row.getObject(this.alias);
    }
}

