/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class NullIfExpression<T>
extends AbstractExpression<T> {
    private String alias;
    private final AbstractExpression<? extends T> x;
    private final AbstractExpression<?> y;

    public NullIfExpression(Expression<? extends T> x, Expression<?> y) {
        super(x.getJavaType());
        this.x = (AbstractExpression)x;
        this.y = (AbstractExpression)y;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "nullif(" + this.x.generateJpqlRestriction(query) + ", " + this.y.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{"NULLIF(" + this.x.getSqlRestrictionFragments(query)[0] + ", " + this.y.getSqlRestrictionFragments(query)[0] + ")"};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }
}

