/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.EntityMapping;
import org.batoo.jpa.jdbc.mapping.Mapping;

public class SizeExpression<C>
extends AbstractExpression<Integer> {
    private final CollectionExpression<?, ?> collection;
    private String alias;

    public SizeExpression(Expression<C> collection) {
        super(Integer.class);
        this.collection = (CollectionExpression)collection;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "size(" + this.collection.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        Root r;
        CriteriaBuilderImpl cb = query.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
        Joinable rp = this.collection.getParentPath().getRootPath();
        LinkedList chain = Lists.newLinkedList();
        Mapping<Object, Collection<Object>, Object> mapping = this.collection.getMapping();
        while (!(mapping instanceof EntityMapping)) {
            chain.addFirst(mapping);
            mapping = mapping.getParent();
        }
        SubqueryImpl<Long> s = query.subquery(Long.class);
        Root from = r = s.from(rp.getEntity());
        for (AbstractMapping chainMember : chain) {
            from = from.join(chainMember.getName());
        }
        s.where((Expression<Boolean>)cb.equal((Expression)r, (AbstractExpression)((Object)rp)));
        s.select(cb.count(cb.literal((Object)1)));
        return s.getSqlRestrictionFragments(query);
    }

    @Override
    public Integer handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return Long.valueOf(row.getLong(this.alias)).intValue();
    }
}

