/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.join;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;

public abstract class AbstractJoin<Z, X>
extends AbstractFrom<Z, X>
implements Join<Z, X> {
    private final JoinedMapping<? super Z, ?, X> mapping;
    private final JoinType joinType;
    private final AbstractFrom<?, Z> parent;

    public AbstractJoin(AbstractFrom<?, Z> parent, JoinedMapping<? super Z, ?, X> mapping, JoinType jointType) {
        super(parent, mapping.getType(), mapping, jointType);
        this.parent = parent;
        this.mapping = mapping;
        this.joinType = jointType;
    }

    @Override
    public String generateJpqlJoins(AbstractCriteriaQueryImpl<?> criteriaQuery) {
        this.ensureAlias(criteriaQuery);
        StringBuilder builder = new StringBuilder();
        builder.append(this.joinType == JoinType.LEFT ? "left" : "inner");
        builder.append(" join ").append(this.getParent().getAlias()).append(".").append(this.mapping.getAttribute().getName()).append(" as ").append(this.getAlias());
        String joins = super.generateJpqlJoins(criteriaQuery);
        if (StringUtils.isNotBlank((String)joins)) {
            builder.append("\n").append(joins);
        }
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        super.generateJpqlSelect(query, selected);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParent().generateJpqlSelect(query, false));
        builder.append(".").append(this.mapping.getAttribute().getName());
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    public Attribute<? super Z, ?> getAttribute() {
        return this.mapping.getAttribute();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    protected JoinedMapping<? super Z, ?, X> getMapping() {
        return this.mapping;
    }

    public AbstractFrom<?, Z> getParent() {
        return this.parent;
    }

    protected UnsupportedOperationException notSupported() {
        return new UnsupportedOperationException("on() operations not supported");
    }
}

