/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.ElementMappingImpl;
import org.batoo.jpa.jdbc.mapping.Mapping;

public class MapKeyPath<Z, X>
extends ParentPath<Z, X> {
    private final MapJoinImpl<?, X, ?> mapJoin;
    private ElementMappingImpl<X> elementMappingImpl;

    public MapKeyPath(MapJoinImpl<Z, X, ?> mapJoin, Class<X> javaType) {
        super(mapJoin.getParent(), javaType);
        this.mapJoin = mapJoin;
        if (this.mapJoin.getModel().getKeyType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            this.elementMappingImpl = new ElementMappingImpl(null, (EmbeddableTypeImpl)this.mapJoin.getModel().getKeyType());
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "key(" + this.mapJoin.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.mapJoin.generateSqlSelect(query, selected, MapJoinImpl.MapSelectType.KEY);
    }

    @Override
    public FetchParentImpl<?, X> getFetchRoot() {
        return null;
    }

    @Override
    protected <C, Y> AbstractMapping<? super X, C, Y> getMapping(String name) {
        Mapping child;
        if (this.mapJoin.getModel().getKeyType() instanceof EmbeddableTypeImpl && (child = this.elementMappingImpl.getChild(name)) != null) {
            return child;
        }
        throw this.cannotDereference(name);
    }

    public MapAttributeImpl<?, ?, X> getModel() {
        return this.mapJoin.getModel();
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return this.mapJoin.getSqlRestrictionFragments(query, MapJoinImpl.MapSelectType.KEY);
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object value = this.mapJoin.handle(session, row, MapJoinImpl.MapSelectType.KEY);
        return (X)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    public Expression<Class<? extends X>> type() {
        return new StaticTypeExpression(this, this.mapJoin.getModel().getKeyJavaType());
    }
}

