/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import java.util.concurrent.Callable;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.batoo.jpa.core.impl.deployment.DeploymentManager;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public final class DeploymentUnitTask
implements Callable<Void>,
Comparable<DeploymentUnitTask> {
    private final Object unit;
    private final DeploymentManager manager;

    public DeploymentUnitTask(DeploymentManager manager, Object unit) {
        this.manager = manager;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Void call() throws Exception {
        this.waitForSuper();
        this.waitforIdDependency();
        try {
            Void void_ = this.manager.perform(this.unit);
            return void_;
        }
        finally {
            this.manager.performed(this.unit);
        }
    }

    @Override
    public int compareTo(DeploymentUnitTask o) {
        if (this.unit instanceof NamedQueryMetadata) {
            return 0;
        }
        ManagedType thisUnit = (ManagedType)this.unit;
        ManagedType otherUnit = (ManagedType)o.unit;
        if (thisUnit instanceof EmbeddableTypeImpl && !(otherUnit instanceof EmbeddableTypeImpl)) {
            return -1;
        }
        if (otherUnit instanceof EmbeddableTypeImpl && !(thisUnit instanceof EmbeddableTypeImpl)) {
            return 1;
        }
        if (thisUnit instanceof MappedSuperclassTypeImpl && !(otherUnit instanceof MappedSuperclassTypeImpl)) {
            return -1;
        }
        if (otherUnit instanceof MappedSuperclassTypeImpl && !(thisUnit instanceof MappedSuperclassTypeImpl)) {
            return 1;
        }
        if (thisUnit.getJavaType().isAssignableFrom(otherUnit.getJavaType())) {
            return -1;
        }
        if (otherUnit.getJavaType().isAssignableFrom(thisUnit.getJavaType())) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentUnitTask other = (DeploymentUnitTask)obj;
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public String toString() {
        return "DeploymentUnitTask [unit=" + this.unit + "]";
    }

    private <X> void waitforIdDependency() throws InterruptedException {
        EntityTypeImpl entity;
        if (this.unit instanceof EntityTypeImpl && !(entity = (EntityTypeImpl)this.unit).hasSingleIdAttribute()) {
            for (SingularAttribute idAttribute : entity.getIdClassAttributes()) {
                if (!(idAttribute instanceof AssociatedSingularAttribute)) continue;
                Type type = ((AssociatedSingularAttribute)idAttribute).getType();
                while (!this.manager.hasPerformed((TypeImpl<?>)type)) {
                    Thread.sleep(10L);
                }
            }
        }
    }

    private void waitForSuper() throws InterruptedException {
        if (this.unit instanceof IdentifiableTypeImpl) {
            IdentifiableType supertype = ((IdentifiableTypeImpl)this.unit).getSupertype();
            while (!this.manager.hasPerformed((TypeImpl<?>)supertype)) {
                Thread.sleep(10L);
            }
        }
    }
}

