/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import javax.persistence.metamodel.EntityType;
import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.deployment.DeploymentManager;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;

public class LinkManager
extends DeploymentManager<EntityTypeImpl<?>> {
    private static final BLogger LOG = BLoggerFactory.getLogger(LinkManager.class);
    private final Phase phase;

    public static void perform(MetamodelImpl metamodel) throws BatooException {
        new LinkManager(metamodel, Phase.LINK_ASSOCIATIONS).perform();
        new LinkManager(metamodel, Phase.LINK_ELEMENT_COLLECTIONS).perform();
        new LinkManager(metamodel, Phase.LINK_DEPENDENCIES).perform();
    }

    private LinkManager(MetamodelImpl metamodel, Phase phase) {
        super(LOG, "Link Manager", metamodel, DeploymentManager.Context.ENTITIES);
        this.phase = phase;
    }

    @Override
    public Void perform(EntityTypeImpl<?> entity) throws BatooException {
        switch (this.phase) {
            case LINK_ASSOCIATIONS: {
                for (AssociationMappingImpl<?, ?, ?> mapping : entity.getAssociations()) {
                    if (mapping.getRoot().getType() != entity) continue;
                    mapping.link();
                }
                break;
            }
            case LINK_ELEMENT_COLLECTIONS: {
                for (PluralMappingEx<?, ?, ?> mapping : entity.getMappingsPlural()) {
                    if (mapping.getRoot().getType() != entity || !(mapping instanceof ElementCollectionMappingImpl)) continue;
                    ((ElementCollectionMappingImpl)mapping).link();
                }
                break;
            }
            case LINK_DEPENDENCIES: {
                for (EntityType<?> type : this.getMetamodel().getEntities()) {
                    entity.prepareDependenciesFor((EntityTypeImpl)type);
                }
                break;
            }
        }
        return null;
    }

    public static enum Phase {
        LINK_ASSOCIATIONS,
        LINK_ELEMENT_COLLECTIONS,
        LINK_DEPENDENCIES;

    }
}

