/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.batoo.jpa.core.impl.manager.Callback;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.model.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.CallbackMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.type.IdentifiableTypeMetadata;

public class CallbackManager {
    private final boolean excludeDefaultListeners;
    private final boolean excludeSuperclassListeners;
    private final Callback[] postLoad;
    private final Callback[] postPersist;
    private final Callback[] postRemove;
    private final Callback[] postUpdate;
    private final Callback[] prePersist;
    private final Callback[] preRemove;
    private final Callback[] preUpdate;

    public CallbackManager(IdentifiableTypeMetadata metadata, Class<?> javaType) {
        this.excludeDefaultListeners = metadata.excludeDefaultListeners();
        this.excludeSuperclassListeners = metadata.excludeSuperclassListeners();
        Map<EntityListenerMetadata.EntityListenerType, List<Callback>> callbacks = this.linkCallbacks(javaType, metadata.getCallbacks(), metadata.getListeners());
        this.postLoad = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_LOAD);
        this.postPersist = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_PERSIST);
        this.postRemove = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_REMOVE);
        this.postUpdate = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_UPDATE);
        this.prePersist = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_PERSIST);
        this.preRemove = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_REMOVE);
        this.preUpdate = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_UPDATE);
    }

    public CallbackManager(List<EntityListenerMetadata> defaultListeners) {
        this.excludeDefaultListeners = false;
        this.excludeSuperclassListeners = false;
        Map<EntityListenerMetadata.EntityListenerType, List<Callback>> callbacks = this.linkCallbacks(null, null, defaultListeners);
        this.postLoad = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_LOAD);
        this.postPersist = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_PERSIST);
        this.postRemove = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_REMOVE);
        this.postUpdate = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.POST_REMOVE);
        this.prePersist = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_PERSIST);
        this.preRemove = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_REMOVE);
        this.preUpdate = this.getCallbacks(callbacks, EntityListenerMetadata.EntityListenerType.PRE_UPDATE);
    }

    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    public void fireCallbacks(Object instance, EntityListenerMetadata.EntityListenerType type) {
        Callback[] callbacks = null;
        switch (type) {
            case POST_LOAD: {
                callbacks = this.postLoad;
                break;
            }
            case POST_REMOVE: {
                callbacks = this.postRemove;
                break;
            }
            case POST_PERSIST: {
                callbacks = this.postPersist;
                break;
            }
            case POST_UPDATE: {
                callbacks = this.postUpdate;
                break;
            }
            case PRE_PERSIST: {
                callbacks = this.prePersist;
                break;
            }
            case PRE_REMOVE: {
                callbacks = this.preRemove;
                break;
            }
            case PRE_UPDATE: {
                callbacks = this.preUpdate;
            }
        }
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.fire(instance);
            }
        }
    }

    public CallbackAvailability getAvailibility(MetamodelImpl metamodel, IdentifiableTypeImpl<?> superType) {
        CallbackAvailability availability = new CallbackAvailability();
        if (!this.excludeDefaultListeners) {
            metamodel.updateAvailability(availability);
        }
        if (!this.excludeSuperclassListeners && superType != null) {
            superType.updateAvailability(availability, null);
        }
        return availability.updateAvailability(this);
    }

    private Callback[] getCallbacks(Map<EntityListenerMetadata.EntityListenerType, List<Callback>> callbacks, EntityListenerMetadata.EntityListenerType type) {
        List<Callback> list = callbacks.get((Object)type);
        if (list == null) {
            return null;
        }
        return list.toArray(new Callback[list.size()]);
    }

    public boolean isExcludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public boolean isExcludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    private void linkCallback(Map<EntityListenerMetadata.EntityListenerType, List<Callback>> callbacks, Callback callback) {
        ArrayList list = callbacks.get((Object)callback.getListenerType());
        if (list == null) {
            list = Lists.newArrayList();
            callbacks.put(callback.getListenerType(), list);
        }
        list.add(callback);
    }

    private Map<EntityListenerMetadata.EntityListenerType, List<Callback>> linkCallbacks(Class<?> javaType, List<CallbackMetadata> callbacks, List<EntityListenerMetadata> listeners) {
        HashMap callbackMap = Maps.newHashMap();
        if (listeners != null) {
            for (EntityListenerMetadata listenerMetadata : listeners) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(listenerMetadata.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new MappingException("Cannot map listener", listenerMetadata.getLocator());
                }
                if (listenerMetadata.getCallbacks() == null || listenerMetadata.getCallbacks().isEmpty()) {
                    Method[] methods;
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || method.getParameterTypes()[0] != Object.class) continue;
                        if (method.getAnnotation(PrePersist.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.PRE_PERSIST, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PreUpdate.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.PRE_UPDATE, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PreRemove.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.PRE_REMOVE, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PostPersist.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.POST_PERSIST, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PostLoad.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.POST_LOAD, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PostUpdate.class) != null) {
                            this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.POST_UPDATE, Callback.CallbackType.LISTENER));
                        }
                        if (method.getAnnotation(PostRemove.class) == null) continue;
                        this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, method.getName(), EntityListenerMetadata.EntityListenerType.POST_REMOVE, Callback.CallbackType.LISTENER));
                    }
                    continue;
                }
                for (CallbackMetadata callbackMetadata : listenerMetadata.getCallbacks()) {
                    this.linkCallback(callbackMap, new Callback(listenerMetadata.getLocator(), clazz, callbackMetadata.getName(), callbackMetadata.getType(), Callback.CallbackType.LISTENER));
                }
            }
        }
        if (callbacks != null) {
            for (CallbackMetadata callbackMetadata : callbacks) {
                this.linkCallback(callbackMap, new Callback(callbackMetadata.getLocator(), javaType, callbackMetadata.getName(), callbackMetadata.getType(), Callback.CallbackType.CALLBACK));
            }
        }
        return callbackMap;
    }

    public Callback[] postLoad() {
        return this.postLoad;
    }

    public Callback[] postPersist() {
        return this.postPersist;
    }

    public Callback[] postRemove() {
        return this.postRemove;
    }

    public Callback[] postUpdate() {
        return this.postUpdate;
    }

    public Callback[] prePersist() {
        return this.prePersist;
    }

    public Callback[] preRemove() {
        return this.preRemove;
    }

    public Callback[] preUpdate() {
        return this.preUpdate;
    }
}

