/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;

public class EntityTransactionImpl
implements EntityTransaction {
    private final EntityManagerImpl em;
    private final Connection connection;
    private boolean active;
    private boolean rollbackOnly;

    public EntityTransactionImpl(EntityManagerImpl entityManager, Connection connection) {
        this.em = entityManager;
        this.connection = connection;
    }

    private void assertValid() {
        if (this.rollbackOnly) {
            throw new PersistenceException("Transaction is set to rollback only");
        }
        this.em.isValid(this);
    }

    public void begin() {
        this.assertValid();
        try {
            if (!this.active) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to begin transaction", (Throwable)e);
        }
        this.active = true;
    }

    public void commit() {
        if (!this.active) {
            throw new TransactionRequiredException("Transaction has not been started");
        }
        this.assertValid();
        if (this.rollbackOnly) {
            throw new TransactionRequiredException("Transaction is marked as rollback only");
        }
        try {
            this.em.flush();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            this.em.clearTransaction();
            this.active = false;
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to commit transaction", (Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.active && !this.rollbackOnly;
    }

    public void rollback() {
        this.assertValid();
        try {
            this.connection.rollback();
            this.em.clearTransaction();
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to rollback transaction", (Throwable)e);
        }
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }
}

